/*
 * Decompiled with CFR 0.152.
 */
package org.testng.mustache;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Stack;
import org.testng.mustache.Value;

public class Model {
    private Map<String, Object> m_model;
    private Stack<SubModel> m_subModels = new Stack();

    public Model(Map<String, Object> model) {
        this.m_model = model;
    }

    public void push(String variable, Object subModel) {
        SubModel sl = new SubModel();
        sl.variable = variable;
        sl.subModel = subModel;
        this.m_subModels.push(sl);
    }

    public Value resolveValue(String variable) {
        if (!this.m_subModels.isEmpty()) {
            for (SubModel object : this.m_subModels) {
                Value value = this.resolveOnClass(object.subModel, variable);
                if (value == null) continue;
                return value;
            }
        }
        return new Value(this.m_model.get(variable));
    }

    private Value resolveOnClass(Object object, String variable) {
        Class<?> cls = object.getClass();
        try {
            Field f = cls.getField(variable);
            return new Value(f.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    public Object getTopSubModel() {
        return this.m_subModels.peek().variable;
    }

    public void popSubModel() {
        this.m_subModels.pop();
    }

    public String resolveValueToString(String variable) {
        StringBuilder result = new StringBuilder();
        Value value = this.resolveValue(variable);
        if (value.get() != null) {
            return value.get().toString();
        }
        return "";
    }

    public String toString() {
        return "[Model " + this.m_model + " subModel:" + this.m_subModels + "]";
    }

    private static class SubModel {
        String variable;
        Object subModel;

        private SubModel() {
        }
    }
}

