/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.NotEmpty;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValidateWithGroupsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ValidateWithGroupsTest.webArchiveBuilder().withTestClass(ValidateWithGroupsTest.class)).withClasses(Address.class, NotEmpty.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-groups", id="a"), @SpecAssertion(section="validationapi-validatorapi-groups", id="b")})
    public void testCorrectGroupsAreAppliedForValidate() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)new Address(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 2);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotNull.class, NotEmpty.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("city"), ConstraintViolationAssert.pathWith().property("zipCode"));
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Default.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 2);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotNull.class, NotEmpty.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("city"), ConstraintViolationAssert.pathWith().property("zipCode"));
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 2);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotEmpty.class, NotEmpty.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("street"), ConstraintViolationAssert.pathWith().property("zipCode"));
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Default.class, Address.Minimal.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 3);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotNull.class, NotEmpty.class, NotEmpty.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("street"), ConstraintViolationAssert.pathWith().property("city"), ConstraintViolationAssert.pathWith().property("zipCode"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-groups", id="a"), @SpecAssertion(section="validationapi-validatorapi-groups", id="b")})
    public void testCorrectGroupsAreAppliedForValidateProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("city"));
        constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[]{Default.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("city"));
        constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validateProperty((Object)new Address(), "street", new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotEmpty.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("street"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-groups", id="a"), @SpecAssertion(section="validationapi-validatorapi-groups", id="b")})
    public void testCorrectGroupsAreAppliedForValidateValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Address.class, "city", null, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("city"));
        constraintViolations = validator.validateValue(Address.class, "city", null, new Class[]{Default.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("city"));
        constraintViolations = validator.validateValue(Address.class, "city", null, new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validateValue(Address.class, "street", null, new Class[]{Address.Minimal.class});
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotEmpty.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("street"));
    }
}

