/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class NegativePositiveConstraintsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)NegativePositiveConstraintsTest.webArchiveBuilder().withTestClass(NegativePositiveConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-negative", id="a")})
    public void testNegativeConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NegativeEntity dummy = new NegativeEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"), ConstraintViolationAssert.pathWith().property("doublePrimitive"), ConstraintViolationAssert.pathWith().property("floatPrimitive"));
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.doublePrimitive = 123.34;
        dummy.floatPrimitive = 456.34f;
        dummy.intObject = 100;
        dummy.longObject = 15678L;
        dummy.byteObject = (byte)50;
        dummy.shortObject = (short)3;
        dummy.doubleObject = 123.34;
        dummy.floatObject = Float.valueOf(5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"), ConstraintViolationAssert.pathWith().property("doublePrimitive"), ConstraintViolationAssert.pathWith().property("floatPrimitive"), ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
        dummy.intPrimitive = 0;
        dummy.longPrimitive = 0L;
        dummy.bytePrimitive = (byte)0;
        dummy.shortPrimitive = (short)0;
        dummy.doublePrimitive = 0.0;
        dummy.floatPrimitive = 0.0f;
        dummy.intObject = 0;
        dummy.longObject = 0L;
        dummy.byteObject = (byte)0;
        dummy.shortObject = (short)0;
        dummy.doubleObject = 0.0;
        dummy.floatObject = Float.valueOf(0.0f);
        dummy.bigDecimal = BigDecimal.valueOf(0L);
        dummy.bigInteger = BigInteger.valueOf(0L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"), ConstraintViolationAssert.pathWith().property("doublePrimitive"), ConstraintViolationAssert.pathWith().property("floatPrimitive"), ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
        dummy.intPrimitive = -101;
        dummy.longPrimitive = -1001L;
        dummy.bytePrimitive = (byte)-111;
        dummy.shortPrimitive = (short)-142;
        dummy.doublePrimitive = -123.34;
        dummy.floatPrimitive = -456.34f;
        dummy.intObject = -100;
        dummy.longObject = -15678L;
        dummy.byteObject = (byte)-50;
        dummy.shortObject = (short)-3;
        dummy.doubleObject = -123.34;
        dummy.floatObject = Float.valueOf(-5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(-100.9);
        dummy.bigInteger = BigInteger.valueOf(-100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-negative", id="a")})
    public void testNegativeConstraintInfinityAndNaN() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NegativeEntity dummy = new NegativeEntity();
        dummy.intPrimitive = -1;
        dummy.longPrimitive = -1L;
        dummy.bytePrimitive = (byte)-1;
        dummy.shortPrimitive = (short)-1;
        dummy.doublePrimitive = -1.0;
        dummy.floatPrimitive = -1.0f;
        dummy.floatObject = Float.valueOf(Float.NEGATIVE_INFINITY);
        dummy.doubleObject = Double.NEGATIVE_INFINITY;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.floatObject = Float.valueOf(Float.POSITIVE_INFINITY);
        dummy.doubleObject = Double.POSITIVE_INFINITY;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"));
        dummy.floatObject = Float.valueOf(Float.NaN);
        dummy.doubleObject = Double.NaN;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-negativeorzero", id="a")})
    public void testNegativeOrZeroConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NegativeOrZeroEntity dummy = new NegativeOrZeroEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.doublePrimitive = 123.34;
        dummy.floatPrimitive = 456.34f;
        dummy.intObject = 100;
        dummy.longObject = 15678L;
        dummy.byteObject = (byte)50;
        dummy.shortObject = (short)3;
        dummy.doubleObject = 123.34;
        dummy.floatObject = Float.valueOf(5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"), ConstraintViolationAssert.pathWith().property("doublePrimitive"), ConstraintViolationAssert.pathWith().property("floatPrimitive"), ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
        dummy.intPrimitive = 0;
        dummy.longPrimitive = 0L;
        dummy.bytePrimitive = (byte)0;
        dummy.shortPrimitive = (short)0;
        dummy.doublePrimitive = 0.0;
        dummy.floatPrimitive = 0.0f;
        dummy.intObject = 0;
        dummy.longObject = 0L;
        dummy.byteObject = (byte)0;
        dummy.shortObject = (short)0;
        dummy.doubleObject = 0.0;
        dummy.floatObject = Float.valueOf(0.0f);
        dummy.bigDecimal = BigDecimal.valueOf(0L);
        dummy.bigInteger = BigInteger.valueOf(0L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.intPrimitive = -101;
        dummy.longPrimitive = -1001L;
        dummy.bytePrimitive = (byte)-111;
        dummy.shortPrimitive = (short)-142;
        dummy.doublePrimitive = -123.34;
        dummy.floatPrimitive = -456.34f;
        dummy.intObject = -100;
        dummy.longObject = -15678L;
        dummy.byteObject = (byte)-50;
        dummy.shortObject = (short)-3;
        dummy.doubleObject = -123.34;
        dummy.floatObject = Float.valueOf(-5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(-100.9);
        dummy.bigInteger = BigInteger.valueOf(-100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-negativeorzero", id="a")})
    public void testNegativeOrZeroConstraintInfinityAndNaN() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NegativeOrZeroEntity dummy = new NegativeOrZeroEntity();
        dummy.floatObject = Float.valueOf(Float.NEGATIVE_INFINITY);
        dummy.doubleObject = Double.NEGATIVE_INFINITY;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.floatObject = Float.valueOf(Float.POSITIVE_INFINITY);
        dummy.doubleObject = Double.POSITIVE_INFINITY;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"));
        dummy.floatObject = Float.valueOf(Float.NaN);
        dummy.doubleObject = Double.NaN;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-positive", id="a")})
    public void testPositiveConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PositiveEntity dummy = new PositiveEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"), ConstraintViolationAssert.pathWith().property("doublePrimitive"), ConstraintViolationAssert.pathWith().property("floatPrimitive"));
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.doublePrimitive = 123.34;
        dummy.floatPrimitive = 456.34f;
        dummy.intObject = 100;
        dummy.longObject = 15678L;
        dummy.byteObject = (byte)50;
        dummy.shortObject = (short)3;
        dummy.doubleObject = 123.34;
        dummy.floatObject = Float.valueOf(5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.intPrimitive = 0;
        dummy.longPrimitive = 0L;
        dummy.bytePrimitive = (byte)0;
        dummy.shortPrimitive = (short)0;
        dummy.doublePrimitive = 0.0;
        dummy.floatPrimitive = 0.0f;
        dummy.intObject = 0;
        dummy.longObject = 0L;
        dummy.byteObject = (byte)0;
        dummy.shortObject = (short)0;
        dummy.doubleObject = 0.0;
        dummy.floatObject = Float.valueOf(0.0f);
        dummy.bigDecimal = BigDecimal.valueOf(0L);
        dummy.bigInteger = BigInteger.valueOf(0L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"), ConstraintViolationAssert.pathWith().property("doublePrimitive"), ConstraintViolationAssert.pathWith().property("floatPrimitive"), ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
        dummy.intPrimitive = -101;
        dummy.longPrimitive = -1001L;
        dummy.bytePrimitive = (byte)-111;
        dummy.shortPrimitive = (short)-142;
        dummy.doublePrimitive = -123.34;
        dummy.floatPrimitive = -456.34f;
        dummy.intObject = -100;
        dummy.longObject = -15678L;
        dummy.byteObject = (byte)-50;
        dummy.shortObject = (short)-3;
        dummy.doubleObject = -123.34;
        dummy.floatObject = Float.valueOf(-5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(-100.9);
        dummy.bigInteger = BigInteger.valueOf(-100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"), ConstraintViolationAssert.pathWith().property("doublePrimitive"), ConstraintViolationAssert.pathWith().property("floatPrimitive"), ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-positiveorzero", id="a")})
    public void testPositiveConstraintInfinityAndNaN() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PositiveEntity dummy = new PositiveEntity();
        dummy.intPrimitive = 1;
        dummy.longPrimitive = 1L;
        dummy.bytePrimitive = (byte)1;
        dummy.shortPrimitive = (short)1;
        dummy.doublePrimitive = 1.0;
        dummy.floatPrimitive = 1.0f;
        dummy.floatObject = Float.valueOf(Float.POSITIVE_INFINITY);
        dummy.doubleObject = Double.POSITIVE_INFINITY;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.floatObject = Float.valueOf(Float.NEGATIVE_INFINITY);
        dummy.doubleObject = Double.NEGATIVE_INFINITY;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"));
        dummy.floatObject = Float.valueOf(Float.NaN);
        dummy.doubleObject = Double.NaN;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-positiveorzero", id="a")})
    public void testPositiveOrZeroConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PositiveOrZeroEntity dummy = new PositiveOrZeroEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.doublePrimitive = 123.34;
        dummy.floatPrimitive = 456.34f;
        dummy.intObject = 100;
        dummy.longObject = 15678L;
        dummy.byteObject = (byte)50;
        dummy.shortObject = (short)3;
        dummy.doubleObject = 123.34;
        dummy.floatObject = Float.valueOf(5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.intPrimitive = 0;
        dummy.longPrimitive = 0L;
        dummy.bytePrimitive = (byte)0;
        dummy.shortPrimitive = (short)0;
        dummy.doublePrimitive = 0.0;
        dummy.floatPrimitive = 0.0f;
        dummy.intObject = 0;
        dummy.longObject = 0L;
        dummy.byteObject = (byte)0;
        dummy.shortObject = (short)0;
        dummy.doubleObject = 0.0;
        dummy.floatObject = Float.valueOf(0.0f);
        dummy.bigDecimal = BigDecimal.valueOf(0L);
        dummy.bigInteger = BigInteger.valueOf(0L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.intPrimitive = -101;
        dummy.longPrimitive = -1001L;
        dummy.bytePrimitive = (byte)-111;
        dummy.shortPrimitive = (short)-142;
        dummy.doublePrimitive = -123.34;
        dummy.floatPrimitive = -456.34f;
        dummy.intObject = -100;
        dummy.longObject = -15678L;
        dummy.byteObject = (byte)-50;
        dummy.shortObject = (short)-3;
        dummy.doubleObject = -123.34;
        dummy.floatObject = Float.valueOf(-5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(-100.9);
        dummy.bigInteger = BigInteger.valueOf(-100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"), ConstraintViolationAssert.pathWith().property("doublePrimitive"), ConstraintViolationAssert.pathWith().property("floatPrimitive"), ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-positive", id="a")})
    public void testPositiveOrZeroConstraintInfinityAndNaN() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PositiveOrZeroEntity dummy = new PositiveOrZeroEntity();
        dummy.floatObject = Float.valueOf(Float.POSITIVE_INFINITY);
        dummy.doubleObject = Double.POSITIVE_INFINITY;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        dummy.floatObject = Float.valueOf(Float.NEGATIVE_INFINITY);
        dummy.doubleObject = Double.NEGATIVE_INFINITY;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"));
        dummy.floatObject = Float.valueOf(Float.NaN);
        dummy.doubleObject = Double.NaN;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("doubleObject"), ConstraintViolationAssert.pathWith().property("floatObject"));
    }

    private static class PositiveOrZeroEntity {
        @PositiveOrZero
        private BigDecimal bigDecimal;
        @PositiveOrZero
        private BigInteger bigInteger;
        @PositiveOrZero
        private byte bytePrimitive;
        @PositiveOrZero
        private short shortPrimitive;
        @PositiveOrZero
        private int intPrimitive;
        @PositiveOrZero
        private long longPrimitive;
        @PositiveOrZero
        private double doublePrimitive;
        @PositiveOrZero
        private float floatPrimitive;
        @PositiveOrZero
        private Byte byteObject;
        @PositiveOrZero
        private Short shortObject;
        @PositiveOrZero
        private Integer intObject;
        @PositiveOrZero
        private Long longObject;
        @PositiveOrZero
        private Double doubleObject;
        @PositiveOrZero
        private Float floatObject;

        private PositiveOrZeroEntity() {
        }
    }

    private static class PositiveEntity {
        @Positive
        private BigDecimal bigDecimal;
        @Positive
        private BigInteger bigInteger;
        @Positive
        private byte bytePrimitive;
        @Positive
        private short shortPrimitive;
        @Positive
        private int intPrimitive;
        @Positive
        private long longPrimitive;
        @Positive
        private double doublePrimitive;
        @Positive
        private float floatPrimitive;
        @Positive
        private Byte byteObject;
        @Positive
        private Short shortObject;
        @Positive
        private Integer intObject;
        @Positive
        private Long longObject;
        @Positive
        private Double doubleObject;
        @Positive
        private Float floatObject;

        private PositiveEntity() {
        }
    }

    private static class NegativeOrZeroEntity {
        @NegativeOrZero
        private BigDecimal bigDecimal;
        @NegativeOrZero
        private BigInteger bigInteger;
        @NegativeOrZero
        private byte bytePrimitive;
        @NegativeOrZero
        private short shortPrimitive;
        @NegativeOrZero
        private int intPrimitive;
        @NegativeOrZero
        private long longPrimitive;
        @NegativeOrZero
        private double doublePrimitive;
        @NegativeOrZero
        private float floatPrimitive;
        @NegativeOrZero
        private Byte byteObject;
        @NegativeOrZero
        private Short shortObject;
        @NegativeOrZero
        private Integer intObject;
        @NegativeOrZero
        private Long longObject;
        @NegativeOrZero
        private Double doubleObject;
        @NegativeOrZero
        private Float floatObject;

        private NegativeOrZeroEntity() {
        }
    }

    private static class NegativeEntity {
        @Negative
        private BigDecimal bigDecimal;
        @Negative
        private BigInteger bigInteger;
        @Negative
        private byte bytePrimitive;
        @Negative
        private short shortPrimitive;
        @Negative
        private int intPrimitive;
        @Negative
        private long longPrimitive;
        @Negative
        private double doublePrimitive;
        @Negative
        private float floatPrimitive;
        @Negative
        private Byte byteObject;
        @Negative
        private Short shortObject;
        @Negative
        private Integer intObject;
        @Negative
        private Long longObject;
        @Negative
        private Double doubleObject;
        @Negative
        private Float floatObject;

        private NegativeEntity() {
        }
    }
}

