/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.declaration;

import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotBlank;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Cinema;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Reference;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.ReferenceValueExtractor;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValueExtractorDefinedInConfigurationApiTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ValueExtractorDefinedInConfigurationApiTest.webArchiveBuilder().withTestClass(ValueExtractorDefinedInConfigurationApiTest.class)).withPackage(Cinema.class.getPackage())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-registering", id="c"), @SpecAssertion(section="validationapi-bootstrapping-configuration", id="g")})
    public void canUseCustomExtractor() throws Exception {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new ReferenceValueExtractor()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)Cinema.invalidVisitor(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitor").property("name", false, null, null, Reference.class, 0)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-registering", id="d")
    public void canUseCustomValueExtractorPerValidator() throws Exception {
        Validator validator = Validation.buildDefaultValidatorFactory().usingContext().addValueExtractor((ValueExtractor)new ReferenceValueExtractor()).getValidator();
        Set violations = validator.validate((Object)Cinema.invalidVisitor(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitor").property("name", false, null, null, Reference.class, 0)));
    }
}

