/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.impl.ContainerCreationException;
import org.jboss.arquillian.container.impl.ContainerImpl;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalContainerRegistry
implements ContainerRegistry {
    private List<Container> containers = new ArrayList<Container>();
    private Injector injector;

    public LocalContainerRegistry(Injector injector) {
        this.injector = injector;
    }

    public Container create(ContainerDef definition, ServiceLoader loader) {
        Validate.notNull((Object)definition, (String)"Definition must be specified");
        try {
            return this.addContainer((Container)this.injector.inject((Object)new ContainerImpl(definition.getContainerName(), (DeployableContainer)loader.onlyOne(DeployableContainer.class), definition)));
        }
        catch (Exception e) {
            throw new ContainerCreationException("Could not create Container " + definition.getContainerName(), e);
        }
    }

    public Container getContainer(String name) {
        return this.findMatchingContainer(name);
    }

    public List<Container> getContainers() {
        return Collections.unmodifiableList(new ArrayList<Container>(this.containers));
    }

    public Container getContainer(TargetDescription target) {
        Validate.notNull((Object)target, (String)"Target must be specified");
        if (TargetDescription.DEFAULT.equals((Object)target)) {
            return this.findDefaultContainer();
        }
        return this.findMatchingContainer(target.getName());
    }

    private Container addContainer(Container contianer) {
        this.containers.add(contianer);
        return contianer;
    }

    private Container findDefaultContainer() {
        if (this.containers.size() == 1) {
            return this.containers.get(0);
        }
        for (Container container : this.containers) {
            if (!container.getContainerConfiguration().isDefault()) continue;
            return container;
        }
        return null;
    }

    private Container findMatchingContainer(String name) {
        for (Container container : this.containers) {
            if (!container.getName().equals(name)) continue;
            return container;
        }
        return null;
    }
}

