/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.impl.ManagerImpl;
import org.jboss.arquillian.core.impl.UncheckedThrow;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.InvocationException;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.NonManagedObserver;
import org.jboss.arquillian.core.spi.ObserverMethod;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventContextImpl<T>
implements EventContext<T> {
    private ManagerImpl manager;
    private List<ObserverMethod> interceptors;
    private List<ObserverMethod> observers;
    private NonManagedObserver<T> nonManagedObserver;
    private T event;
    private int currentInterceptor = 0;

    public EventContextImpl(ManagerImpl manager, List<ObserverMethod> interceptors, List<ObserverMethod> observers, NonManagedObserver<T> nonManagedObserver, T event) {
        Validate.notNull((Object)manager, (String)"Manager must be specified");
        Validate.notNull(event, (String)"Event must be specified");
        this.manager = manager;
        this.interceptors = interceptors == null ? new ArrayList() : interceptors;
        this.observers = observers == null ? new ArrayList() : observers;
        this.nonManagedObserver = nonManagedObserver;
        this.event = event;
    }

    public T getEvent() {
        return this.event;
    }

    public void proceed() {
        if (this.currentInterceptor == this.interceptors.size()) {
            this.invokeObservers();
            this.invokeNonManagedObserver();
        } else {
            ObserverMethod interceptor = this.interceptors.get(this.currentInterceptor++);
            this.manager.debug(interceptor, true);
            interceptor.invoke((Manager)this.manager, (Object)this);
        }
    }

    private void invokeObservers() {
        for (ObserverMethod observer : this.observers) {
            try {
                this.manager.debug(observer, false);
                observer.invoke((Manager)this.manager, this.event);
            }
            catch (InvocationException e) {
                Throwable cause = e.getCause();
                if (this.manager.isExceptionHandled(cause)) {
                    UncheckedThrow.throwUnchecked(cause);
                    continue;
                }
                this.manager.fireException(cause);
            }
        }
    }

    private void invokeNonManagedObserver() {
        if (this.nonManagedObserver != null) {
            this.manager.inject(this.nonManagedObserver);
            this.nonManagedObserver.fired(this.getEvent());
        }
    }
}

