/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintStream;
import java.io.PrintWriter;

public class JavaTestError
extends Error {
    protected Throwable original;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JavaTestError.class);
    private static final String GENERIC_START = i18n.getString("fault.genericMsgStart");
    private static final String GENERIC_END = i18n.getString("fault.genericMsgEnd");
    private static final String ROOT_CAUSE = i18n.getString("fault.origin");
    private static final String UNEXPECTED_EXCEPTION = i18n.getString("fault.unexpected");

    public JavaTestError(String s) {
        super(s);
    }

    public JavaTestError(String s, Throwable original) {
        super(s);
        this.original = original;
    }

    public JavaTestError(Throwable original) {
        super(i18n.getString("fault.default", original));
        this.original = original;
    }

    public JavaTestError(I18NResourceBundle i18n, String key) {
        super(i18n.getString(key));
    }

    public JavaTestError(I18NResourceBundle i18n, String key, Object arg) {
        super(i18n.getString(key, arg));
    }

    public JavaTestError(I18NResourceBundle i18n, String key, Object[] args) {
        super(i18n.getString(key, args));
    }

    public JavaTestError(I18NResourceBundle i18n, String key, Throwable original) {
        super(i18n.getString(key, original));
        this.original = original;
    }

    public JavaTestError(I18NResourceBundle i18n, String key, Object arg, Throwable original) {
        super(i18n.getString(key, new Object[]{arg, original}));
        this.original = original;
    }

    public JavaTestError(I18NResourceBundle i18n, String key, Object[] args, Throwable original) {
        super(i18n.getString(key, JavaTestError.join(args, original)));
        this.original = original;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.println(GENERIC_START);
        super.printStackTrace(s);
        if (this.original != null) {
            s.println(ROOT_CAUSE);
            this.original.printStackTrace(s);
        }
        s.println(GENERIC_END);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.println(GENERIC_START);
        super.printStackTrace(s);
        if (this.original != null) {
            s.println(ROOT_CAUSE);
            this.original.printStackTrace(s);
        }
        s.println(GENERIC_END);
    }

    public Throwable getOriginalFault() {
        return this.original;
    }

    private static Object[] join(Object[] args, Object a) {
        Object[] newArgs = new Object[args.length + 1];
        System.arraycopy(args, 0, newArgs, 0, args.length);
        newArgs[args.length] = a;
        return newArgs;
    }

    public static void unexpectedException(Throwable t) {
        System.err.println(GENERIC_START);
        System.err.println(UNEXPECTED_EXCEPTION);
        t.printStackTrace(System.err);
        System.err.println(GENERIC_END);
    }
}

