/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.tests;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.eclipse.hawk.integration.tests.mm.Tree.Tree;
import org.eclipse.hawk.integration.tests.mm.Tree.TreeFactory;
import org.eclipse.hawk.integration.tests.mm.Tree.TreePackage;
import org.eclipse.hawk.svn.tests.rules.TemporarySVNRepository;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.tests.AbstractTimeAwareModelIndexingTest;
import org.eclipse.hawk.timeaware.tests.TimeAwareTestSuite;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SubversionNodeHistoryTest
extends AbstractTimeAwareModelIndexingTest {
    @Rule
    public TemporarySVNRepository svnRepository = new TemporarySVNRepository();

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return TimeAwareTestSuite.caseParams();
    }

    public SubversionNodeHistoryTest(File baseDir, IGraphDatabaseFactory dbFactory) {
        super(baseDir, dbFactory, (ModelIndexingTest.IModelSupportFactory)new EMFModelSupportFactory());
    }

    @Override
    protected void setUpMetamodels() throws Exception {
        TreePackage.eINSTANCE.getName();
    }

    @Test
    public void travelToMissingTimepointReturnsNull() throws Throwable {
        this.twoCommitTree();
        this.scheduleAndWait(() -> {
            EOLQueryEngine.GraphNodeWrapper gnw = (EOLQueryEngine.GraphNodeWrapper)this.timeAwareEOL("return Tree.latest.prev.all.first;");
            Assert.assertNotNull((Object)gnw.getNode());
            Assert.assertNull((Object)((ITimeAwareGraphNode)gnw.getNode()).travelInTime(-1L));
            return null;
        });
    }

    @Test
    public void createDeleteNode() throws Throwable {
        this.twoCommitTree();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Tree.all.size;"));
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Tree.latest.all.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.latest.prev.size;"));
            Assert.assertEquals((Object)3, (Object)this.timeAwareEOL("return Tree.versions.size;"));
            Assert.assertEquals((Object)"xy", (Object)this.timeAwareEOL("return Tree.latest.prev.all.first.label;"));
            return null;
        });
    }

    private void twoCommitTree() throws Exception {
        File fTree = new File(this.svnRepository.getCheckoutDirectory(), "root.xmi");
        Resource rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree t = this.treeFactory.createTree();
        t.setLabel("xy");
        rTree.getContents().add((Object)t);
        rTree.save(null);
        this.svnRepository.add(new File[]{fTree});
        this.svnRepository.commit("First commit");
        this.svnRepository.remove(new File[]{fTree});
        this.svnRepository.commit("Second commit - remove file");
        this.requestSVNIndex();
    }

    @Test
    public void countInstancesFromModelTypes() throws Throwable {
        this.twoCommitTree();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Model.types.selectOne(t|t.name='Tree').all.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Model.types.selectOne(t|t.name='Tree').latest.prev.all.size;"));
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Model.types.selectOne(t|t.name='Tree').latest.prev.prev.all.size;"));
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Model.types.selectOne(t|t.name='Tree').earliest.all.size;"));
            return null;
        });
    }

    @Test
    public void countInstancesFromModel() throws Throwable {
        this.twoCommitTree();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Model.types.selectOne(t|t.name='Tree').all.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Model.types.selectOne(t|t.name='Tree').latest.prev.all.size;"));
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Model.types.selectOne(t|t.name='Tree').latest.prev.prev.all.size;"));
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Model.types.selectOne(t|t.name='Tree').earliest.all.size;"));
            return null;
        });
    }

    @Test
    public void countInstancesTimeline() throws Throwable {
        this.twoCommitTree();
        this.scheduleAndWait(() -> {
            List results = (List)this.timelineEOL("return Tree.all.size;");
            Assert.assertEquals((Object)0, ((List)results.get(0)).get(1));
            Assert.assertEquals((long)0L, (long)((Integer)this.timeAwareEOL("return Model.allInstancesAt(t).size;", "t", ((List)results.get(0)).get(0))).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)this.timeAwareEOL("return Model.allInstancesAt(" + ((List)results.get(0)).get(0) + ").size;")).intValue());
            Assert.assertEquals((Object)1, ((List)results.get(1)).get(1));
            Assert.assertEquals((long)1L, (long)((Integer)this.timeAwareEOL("return Model.allInstancesAt(t).size;", "t", ((List)results.get(1)).get(0))).intValue());
            Assert.assertEquals((Object)0, ((List)results.get(2)).get(1));
            Assert.assertEquals((long)0L, (long)((Integer)this.timeAwareEOL("return Model.allInstancesAt(t).size;", "t", ((List)results.get(2)).get(0))).intValue());
            return null;
        });
    }

    @Test
    public void countInstancesModelAll() throws Throwable {
        File fTree = new File(this.svnRepository.getCheckoutDirectory(), "root.xmi");
        Resource rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree t = this.treeFactory.createTree();
        t.setLabel("xy");
        rTree.getContents().add((Object)t);
        rTree.save(null);
        this.svnRepository.add(new File[]{fTree});
        this.svnRepository.commit("First commit");
        this.requestSVNIndex();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Model.allInstances.collect(t|t.label).size;"));
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Model.allInstances.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Model.allInstancesNow.size;"));
            return null;
        });
    }

    private Tree keepAddingChildren() throws Exception {
        File fTree = new File(this.svnRepository.getCheckoutDirectory(), "m.xmi");
        Resource rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree tRoot = this.treeFactory.createTree();
        tRoot.setLabel("Root");
        rTree.getContents().add((Object)tRoot);
        rTree.save(null);
        this.svnRepository.add(new File[]{fTree});
        this.svnRepository.commit("Create root");
        for (String childLabel : Arrays.asList("T1", "T2", "T3")) {
            this.createChild(tRoot, childLabel);
            rTree.save(null);
            this.svnRepository.commit("Add " + childLabel);
        }
        this.requestSVNIndex();
        return tRoot;
    }

    @Test
    public void commitMessages() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)"Create root", (Object)this.timeAwareEOL("return Model.getRepository(Tree.latest.all.selectOne(t|t.label='Root').earliest).message;"));
            Assert.assertEquals((Object)"Add T1", (Object)this.timeAwareEOL("return Model.getRepository(Tree.latest.all.selectOne(t|t.label='T1').earliest).message;"));
            Assert.assertEquals((Object)"Add T2", (Object)this.timeAwareEOL("return Model.getRepository(Tree.latest.all.selectOne(t|t.label='T2').earliest).message;"));
            Assert.assertEquals((Object)"Add T3", (Object)this.timeAwareEOL("return Model.getRepository(Tree.latest.all.selectOne(t|t.label='T3').earliest).message;"));
            return null;
        });
    }

    @Test
    public void followReferences() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            Object taGNW = this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').earliest.next.children.first;");
            Assert.assertTrue((String)"Following a reference in a time-aware backend should result in a time-aware graph node wrapper", (boolean)(taGNW instanceof TimeAwareEOLQueryEngine.TimeAwareGraphNodeWrapper));
            return null;
        });
    }

    @Test
    public void rangesAreBothInclusive() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            EOLQueryEngine.GraphNodeWrapper gnw = (EOLQueryEngine.GraphNodeWrapper)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.latest.label = 'Root');");
            ITimeAwareGraphNode taNode = (ITimeAwareGraphNode)gnw.getNode();
            long earliestInstant = taNode.getEarliestInstant();
            long latestInstant = taNode.getLatestInstant();
            List allVersions = taNode.getAllVersions();
            Assert.assertEquals((long)earliestInstant, (long)((ITimeAwareGraphNode)allVersions.get(allVersions.size() - 1)).getTime());
            Assert.assertEquals((long)latestInstant, (long)((ITimeAwareGraphNode)allVersions.get(0)).getTime());
            List versionsUpTo = taNode.getVersionsUpTo(latestInstant);
            Assert.assertEquals((long)earliestInstant, (long)((ITimeAwareGraphNode)versionsUpTo.get(versionsUpTo.size() - 1)).getTime());
            Assert.assertEquals((long)latestInstant, (long)((ITimeAwareGraphNode)versionsUpTo.get(0)).getTime());
            List versionsFrom = taNode.getVersionsFrom(earliestInstant);
            Assert.assertEquals((long)earliestInstant, (long)((ITimeAwareGraphNode)versionsFrom.get(versionsFrom.size() - 1)).getTime());
            Assert.assertEquals((long)latestInstant, (long)((ITimeAwareGraphNode)versionsFrom.get(0)).getTime());
            List versionsBW = taNode.getVersionsBetween(earliestInstant, latestInstant);
            Assert.assertEquals((long)earliestInstant, (long)((ITimeAwareGraphNode)versionsBW.get(versionsFrom.size() - 1)).getTime());
            Assert.assertEquals((long)latestInstant, (long)((ITimeAwareGraphNode)versionsBW.get(0)).getTime());
            return null;
        });
    }

    @Test
    public void alwaysTrue() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').always(v|v.label = 'Root');")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').never(v|v.label <> 'Root');")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').eventually(v|v.children.size > 2);")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').eventually(v|v.children.size > 3);")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').eventuallyAtMost(v | v.children.size > 2, 2);")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').eventuallyAtMost(v | v.children.size > 0, 2);")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').eventuallyAtLeast(v | v.children.size > 2, 2);")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').eventuallyAtLeast(v | v.children.size > 0, 2);")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').since(v|v.children.size > 1).always(v | v.children.size>1);")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').since(v|v.children.size > 1).eventually(v | v.children.size<1);")));
            return null;
        });
    }

    @Test
    public void after() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((String)".after is an open left range, i.e. excludes matching version", (long)2L, (long)((Integer)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').earliest.after(v|v.children.size > 0).children.size;")).intValue());
            Assert.assertNull((String)".after with no match returns null", (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').after(v|v.children.size > 5);"));
            return null;
        });
    }

    @Test
    public void until() throws Throwable {
        Tree tRoot = this.keepAddingChildren();
        Tree tFourthChild = TreeFactory.eINSTANCE.createTree();
        tFourthChild.setLabel("T4");
        tRoot.getChildren().add((Object)tFourthChild);
        tRoot.eResource().save(null);
        this.svnRepository.commit("Added fourth child");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((String)".until is a closed end range, i.e. includes matching version", (long)2L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').until(v|v.children.size > 1).latest.children.size;")).intValue());
            Assert.assertNull((String)".until with no match returns null", (Object)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').until(v|v.children.size > 5);"));
            Assert.assertEquals((String)".since + .until works", (long)2L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').since(v|v.children.size > 1).until(v|v.children.size > 2).versions.size;")).intValue());
            return null;
        });
    }

    @Test
    public void before() throws Throwable {
        Tree tRoot = this.keepAddingChildren();
        Tree tFourthChild = TreeFactory.eINSTANCE.createTree();
        tFourthChild.setLabel("T4");
        tRoot.getChildren().add((Object)tFourthChild);
        tRoot.eResource().save(null);
        this.svnRepository.commit("Added fourth child");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((String)".before is a open end range, i.e. excludes matching version", (long)1L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').before(v|v.children.size > 1).latest.children.size;")).intValue());
            Assert.assertNull((String)".before with no match returns null", (Object)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').before(v|v.children.size > 5);"));
            Assert.assertEquals((String)".after + .before works", (long)1L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').after(v|v.children.size.println('after for ' + v.time + ': ') > 0).before(v|v.children.size.println('before for ' + v.time + ': ') > 2).versions.size;")).intValue());
            Assert.assertFalse((String)".after + .before can give an undefined node", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').after(v|v.children.size > 0).before(v|v.children.size > 1).isDefined();")));
            return null;
        });
    }

    @Test
    public void sinceThen() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            Assert.assertFalse((String)"Type node - Without .sinceThen, always uses all versions", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.always(v|v.all.size > 0);")));
            Assert.assertTrue((String)"Type node - With .sinceThen, scope is limited to that version onwards", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.sinceThen.always(v|v.all.size > 0);")));
            Assert.assertFalse((String)"Model element - Without .sinceThen, always uses all versions", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label = 'Root').next.always(v|v.children.size > 0);")));
            Assert.assertTrue((String)"Model element - With .sinceThen, scope is limited to that version onwards", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label = 'Root').next.sinceThen.always(v|v.children.size > 0);")));
            return null;
        });
    }

    @Test
    public void afterThen() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            Assert.assertFalse((String)"Type node - Without .afterThen, always uses all versions", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.always(v|v.all.size > 1);")));
            Assert.assertTrue((String)"Type node - With .afterThen, scope is limited to that version onwards", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.afterThen.always(v|v.all.size > 1);")));
            Assert.assertFalse((String)"Model element - Without .afterThen, always uses all versions", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label = 'Root').next.always(v|v.children.size > 1);")));
            Assert.assertTrue((String)"Model element - With .sinceThen, scope is limited to that version onwards", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label = 'Root').next.afterThen.always(v|v.children.size > 1);")));
            return null;
        });
    }

    @Test
    public void untilThen() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            Assert.assertTrue((String)"Positive combination of .sinceThen + .untilThen", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.sinceThen.latest.prev.untilThen.always(v|v.all.size > 0 and v.all.size < 4);")));
            Assert.assertFalse((String)"Negative combination of .sinceThen + .untilThen", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.sinceThen.latest.untilThen.always(v|v.all.size > 0 and v.all.size < 4);")));
            return null;
        });
    }

    @Test
    public void beforeThen() throws Throwable {
        this.keepAddingChildren();
        this.scheduleAndWait(() -> {
            Assert.assertTrue((String)"Positive combination of .afterThen + .beforeThen", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.afterThen.latest.beforeThen.always(v|v.all.size > 0 and v.all.size < 4);")));
            Assert.assertFalse((String)"Negative combination of .sinceThen + .beforeThen", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.sinceThen.latest.beforeThen.always(v|v.all.size > 0 and v.all.size < 4);")));
            return null;
        });
    }

    @Test
    public void whenPoints() throws Throwable {
        Tree tRoot = this.keepAddingChildren();
        tRoot.getChildren().remove(2);
        tRoot.eResource().save(null);
        this.svnRepository.commit("Removed third child");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((String)"all versions of root", (long)5L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').versions.size;")).intValue());
            Assert.assertEquals((String)".when with all versions", (long)5L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').when(v|v.children.size >= 0).versions.size;")).intValue());
            Assert.assertFalse((String)".when with no versions returns null", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').when(v|v.children.size > 5).isDefined();")));
            Assert.assertEquals((String)".when with some contiguous versions", (long)2L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').when(v|v.children.size < 2).versions.size;")).intValue());
            Assert.assertEquals((String)".when with one version", (long)1L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').when(v|v.children.size = 3).versions.size;")).intValue());
            Assert.assertEquals((String)".when with some non-contiguous versions", (long)2L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').when(v|v.children.size = 2).versions.size;")).intValue());
            Assert.assertEquals((String)".when with non-contiguous versions + back and forth", (long)2L, (long)((Integer)this.timeAwareEOL("return Tree.earliest.next.all.selectOne(t|t.label='Root').when(v|v.children.size = 2).next.prev.children.size;")).intValue());
            return null;
        });
    }

    @Test
    public void unscope() throws Throwable {
        File fTree = new File(this.svnRepository.getCheckoutDirectory(), "m.xmi");
        Resource rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree tRoot = this.treeFactory.createTree();
        tRoot.setLabel("Empty");
        rTree.getContents().add((Object)tRoot);
        rTree.save(null);
        this.svnRepository.add(new File[]{fTree});
        this.svnRepository.commit("Create root");
        Tree t1A = this.treeFactory.createTree();
        t1A.setLabel("T1A");
        tRoot.setLabel("NotEmpty");
        tRoot.getChildren().add((Object)t1A);
        rTree.save(null);
        this.svnRepository.commit("First non-empty interval, commit 1");
        Tree t1B = this.treeFactory.createTree();
        t1B.setLabel("T1B");
        tRoot.getChildren().add((Object)t1B);
        rTree.save(null);
        this.svnRepository.commit("First non-empty interval, commit 2");
        tRoot.setLabel("Empty");
        tRoot.getChildren().clear();
        rTree.save(null);
        this.svnRepository.commit("Gap revision, empty root");
        tRoot.setLabel("NotEmpty");
        Tree t1C = this.treeFactory.createTree();
        t1C.setLabel("T1C");
        tRoot.getChildren().add((Object)t1C);
        rTree.save(null);
        this.svnRepository.commit("Second non-empty interval, commit 1");
        tRoot.getChildren().add((Object)t1A);
        tRoot.getChildren().remove((Object)t1C);
        rTree.save(null);
        this.svnRepository.commit("Third non-empty interval, commit 2");
        tRoot.setLabel("Empty");
        tRoot.getChildren().clear();
        rTree.save(null);
        this.svnRepository.commit("Final gap revision, empty root");
        this.requestSVNIndex();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((String)"There are three versions with an empty root node", (long)3L, (long)((Integer)this.timeAwareEOL("return Tree.latest.all.selectOne(t|not t.eContainer.isDefined()).earliest.when(v|v.children.isEmpty).versions.size;")).intValue());
            Assert.assertTrue((String)"Root element labels are not empty when they say so - .when version", (boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|not t.eContainer.isDefined()).earliest.when(v|v.label = 'NotEmpty').always(v|not v.children.isEmpty);")));
            Assert.assertTrue((String)"Interval version without .unscope would give null value", (boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|not t.eContainer.isDefined()).earliest.when(v|v.label = 'NotEmpty' and v.prev.label = 'Empty').always(v | not v.sinceThen.before(v|v.label = 'Empty').isDefined());")));
            Assert.assertTrue((String)"Root element labels are not empty when they say so - interval version with .unscope, .sinceThen and .before", (boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|not t.eContainer.isDefined()).earliest.when(v|v.label.println('label: ') = 'NotEmpty' and v.prev.label = 'Empty').always(v| v.unscoped.sinceThen.before(v | v.label = 'Empty').always(v | v.children.size.println('Children of ' + v.label + ' at ' + v.time + ': ') > 0));")));
            Assert.assertTrue((String)"Root element labels are not empty when they say so - interval version with .unscope, .sinceThen and .until", (boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|not t.eContainer.isDefined()).earliest.when(v|v.label = 'NotEmpty' and v.prev.label = 'Empty').always(v| v.unscoped.sinceThen.until(v | not v.next.isDefined() or v.next.label = 'Empty').always(v | v.children.size.println('Children of ' + v.label + ' at ' + v.time + ': ') > 0));")));
            Assert.assertTrue((String)"Type node - scoped .always returns true", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.sinceThen.always(v|v.all.size > 0);")));
            Assert.assertFalse((String)"Type node - unscoped .always returns true", (boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.sinceThen.unscoped.always(v|v.all.size > 0);")));
            return null;
        });
    }

    @Test
    public void onceFalse() throws Throwable {
        Tree tRoot = this.keepAddingChildren();
        tRoot.setLabel("SomethingElse");
        tRoot.eResource().save(null);
        this.svnRepository.commit("Changed label");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.latest.label='SomethingElse').always(v|v.label = 'Root');")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').always(v|v.label = 'Root');")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').never(v|v.label = 'Root');")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').never(v|v.label <> 'Root');")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').eventually(v|v.label <> 'Root');")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').eventually(v|v.label = 'Root');")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').eventuallyAtMost(v|v.label <> 'Root', 1);")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').eventuallyAtMost(v|v.label = 'Root', 2);")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').eventuallyAtLeast(v|v.label <> 'Root', 2);")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.prev.all.selectOne(t|t.label='Root').eventuallyAtLeast(v|v.label = 'Root', 2);")));
            Assert.assertNotNull((String)".since by itself returns a node", (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.latest.label='SomethingElse').earliest.since(v|v.label <> 'Root');"));
            Assert.assertFalse((String)".since + .eventually works", (boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').earliest.since(v|v.label <> 'Root').eventually(v|v.label = 'Root');")));
            Assert.assertTrue((String)".since + .never works", (boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').earliest.since(v|v.label <> 'Root').never(v|v.label.println('Label at ' + v.time + ': ') = 'Root');")));
            Assert.assertTrue((String)".since + .always works", (boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').earliest.since(v|v.label <> 'Root').always(v|v.children.size > 1);")));
            Assert.assertFalse((String)".since can be chained", (boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.latest.label='SomethingElse').earliest.since(v|v.label <> 'Root').since(v|v.children.size = 0).isDefined();")));
            return null;
        });
    }

    @Test
    public void whenAnnotated() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        this.indexer.addDerivedAttribute("Tree", "Tree", "hasNoChildren", "TimelineAnnotation", false, false, false, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "return self.children.isEmpty;");
        File fTree = new File(this.svnRepository.getCheckoutDirectory(), "m.xmi");
        Resource rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree tRoot = this.treeFactory.createTree();
        tRoot.setLabel("Root");
        rTree.getContents().add((Object)tRoot);
        rTree.save(null);
        this.svnRepository.add(new File[]{fTree});
        this.svnRepository.commit("Create root");
        Tree t1 = this.createChild(tRoot, "t1");
        rTree.save(null);
        this.svnRepository.commit("Add child");
        tRoot.getChildren().remove((Object)t1);
        rTree.save(null);
        this.svnRepository.commit("Remove child");
        this.requestSVNIndex();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)3, (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').versions.size;"));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').earliest.when(v|v.children.size = 0).versions.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').when(v|v.children.size = 0).versions.size;"));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').earliest.whenAnnotated('hasNoChildren').versions.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='Root').whenAnnotated('hasNoChildren').versions.size;"));
            return null;
        });
    }

    private Tree createChild(Tree tRoot, String label) {
        Tree t1 = this.treeFactory.createTree();
        t1.setLabel(label);
        tRoot.getChildren().add((Object)t1);
        return t1;
    }

    private void requestSVNIndex() throws Exception {
        this.requestSVNIndex(this.svnRepository);
    }
}

