/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.services.impl;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.gendoc.m2t.model.Fragment;
import org.eclipse.gendoc.script.services.impl.ModuleManagerService;

public class FragmentComparator
implements Comparator<Fragment> {
    private final ModuleManagerService moduleManagerService;

    FragmentComparator(ModuleManagerService moduleManagerService) {
        this.moduleManagerService = moduleManagerService;
    }

    @Override
    public int compare(Fragment o1, Fragment o2) {
        Map<String, Fragment> allFragments;
        boolean found;
        int result = o1.getImportedFragments().size() == 0 && o2.getImportedFragments().size() == 0 ? 0 : (o1.getImportedFragments().size() == 0 ? -1 : (o2.getImportedFragments().size() == 0 ? 1 : (!(found = this.isDependant(o1, o2, allFragments = this.moduleManagerService.getFragmentsMap())) ? (this.isDependant(o2, o1, allFragments) ? -1 : 0) : 1)));
        return result;
    }

    private Set<String> getAllAncestors(Fragment o1, Map<String, Fragment> allFragments) {
        HashSet<String> result = new HashSet<String>();
        for (String o : o1.getImportedFragments()) {
            result.add(o);
            result.addAll(this.getAllAncestors(allFragments.get(o), allFragments));
        }
        return result;
    }

    private boolean isDependant(Fragment o1, Fragment o2, Map<String, Fragment> allFragments) {
        Stack<String> deps = new Stack<String>();
        deps.addAll(o1.getImportedFragments());
        boolean found = false;
        while (!deps.isEmpty() && !found) {
            String aDep = (String)deps.pop();
            if (aDep.equals(o1.getName())) {
                ModuleManagerService moduleManagerService = this.moduleManagerService;
                moduleManagerService.getClass();
                throw moduleManagerService.new ModuleManagerService.DependencyCycleRuntimeException(String.format("a cycle has been detected for fragment <<%s>> please check the attribute 'importedFragments'", o1.getName()));
            }
            found |= o2 != null && o2.getName().equals(aDep);
            Fragment f = allFragments.get(aDep);
            if (f == null) continue;
            for (String s : f.getImportedFragments()) {
                deps.push(s);
            }
        }
        return found;
    }
}

