/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.EnumerationValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.ParserRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.RuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMatchStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.UserElementAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.UserElementMatcher;
import org.eclipse.ocl.examples.xtext.serializer.UserModelAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.UserSlotAnalysis;

public class DynamicRuleMatch
implements RuleMatch {
    protected final @NonNull UserElementAnalysis elementAnalysis;
    protected final @NonNull SerializationRule serializationRule;
    private final @NonNull Map<@NonNull Integer, @NonNull Integer> variableIndex2value = new HashMap<Integer, Integer>();
    private boolean matchFailed = false;
    private @Nullable EStructuralFeature reasonFeature = null;
    private @Nullable SerializationMatchStep reasonMatchStep = null;
    private @Nullable ParserRuleValue reasonRuleValue = null;
    private @Nullable SerializationStep reasonStep = null;

    public DynamicRuleMatch(@NonNull UserElementAnalysis elementAnalysis, @NonNull SerializationRule serializationRule) {
        this.elementAnalysis = elementAnalysis;
        this.serializationRule = serializationRule;
        elementAnalysis.getModelAnalysis().debugAddDynamicRuleMatch(this);
        EObject eObject = elementAnalysis.getEObject();
    }

    public boolean analyze() {
        SerializationMatchStep[] serializationMatchSteps;
        SerializationMatchStep[] serializationMatchStepArray = serializationMatchSteps = this.serializationRule.getSerializationMatchSteps();
        int n = serializationMatchSteps.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationMatchStep step = serializationMatchStepArray[n2];
            if (!step.execute(this)) {
                assert (this.matchFailed);
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public @Nullable Integer basicGetIntegerSolution(int variableIndex) {
        return this.variableIndex2value.get(variableIndex);
    }

    public @Nullable String basicGetReasonString() {
        EStructuralFeature reasonFeature2 = this.reasonFeature;
        if (reasonFeature2 != null) {
            return "Incompatible/missing '" + reasonFeature2.getEContainingClass().getName() + "::" + reasonFeature2.getName() + "' values.";
        }
        if (this.reasonMatchStep != null) {
            return this.reasonMatchStep.getFailureReason(this);
        }
        if (this.reasonStep != null) {
            return this.reasonStep.getFailureReason(this);
        }
        return null;
    }

    public @Nullable Integer basicGetValue(int variableIndex) {
        assert (variableIndex >= 0);
        return this.variableIndex2value.get(variableIndex);
    }

    public boolean checkNoUnusedFeatureUsage(@NonNull UserElementMatcher matcher) {
        for (EStructuralFeature eStructuralFeature : this.elementAnalysis.getEStructuralFeatures()) {
            SerializationRule.SerializationFeature serializationFeature = this.serializationRule.getSerializationFeature(eStructuralFeature);
            UserSlotAnalysis object = this.elementAnalysis.getSlotAnalysis(eStructuralFeature);
            if (serializationFeature == null) {
                if (object.isCounted() && object.asCounted() == 0) continue;
                this.setFailedMatch(eStructuralFeature);
                matcher.setFailureFeature(eStructuralFeature);
                assert (this.matchFailed);
                return false;
            }
            if (serializationFeature instanceof SerializationRule.SerializationEnumeratedAttribute) {
                SerializationRule.SerializationEnumeratedAttribute serializationEnumeratedAttribute = (SerializationRule.SerializationEnumeratedAttribute)serializationFeature;
                EnumerationValue[] enumerationValueArray = serializationEnumeratedAttribute.getEnumerationValues();
                int n = enumerationValueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EnumerationValue enumerationValue = enumerationValueArray[n2];
                    int available = this.elementAnalysis.getSize((EAttribute)eStructuralFeature, enumerationValue);
                    int consumed = matcher.getSize(eStructuralFeature);
                    if (consumed < available) {
                        this.setFailedMatch(eStructuralFeature);
                        matcher.setFailureFeature(eStructuralFeature);
                        assert (this.matchFailed);
                        return false;
                    }
                    ++n2;
                }
                continue;
            }
            if (serializationFeature instanceof SerializationRule.SerializationReference) {
                int consumed;
                int available;
                SerializationRule.SerializationReference serializationReference = (SerializationRule.SerializationReference)serializationFeature;
                GrammarRuleVector targetGrammarRuleVector = serializationReference.getTargetGrammarRuleVector();
                if (targetGrammarRuleVector != null) {
                    available = this.elementAnalysis.getSize((EReference)eStructuralFeature, targetGrammarRuleVector);
                    consumed = matcher.getSize(eStructuralFeature);
                    if (consumed >= available) continue;
                    this.setFailedMatch(eStructuralFeature);
                    matcher.setFailureFeature(eStructuralFeature);
                    assert (this.matchFailed);
                    return false;
                }
                available = this.elementAnalysis.getSize(eStructuralFeature);
                consumed = matcher.getSize(eStructuralFeature);
                if (consumed >= available) continue;
                this.setFailedMatch(eStructuralFeature);
                matcher.setFailureFeature(eStructuralFeature);
                assert (this.matchFailed);
                return false;
            }
            int available = this.elementAnalysis.getSize(eStructuralFeature);
            int consumed = matcher.getSize(eStructuralFeature);
            if (consumed >= available) continue;
            this.setFailedMatch(eStructuralFeature);
            matcher.setFailureFeature(eStructuralFeature);
            assert (this.matchFailed);
            return false;
        }
        return true;
    }

    public @NonNull UserElementAnalysis getElementAnalysis() {
        return this.elementAnalysis;
    }

    public @NonNull UserModelAnalysis getModelAnalysis() {
        return this.elementAnalysis.getModelAnalysis();
    }

    public @Nullable EStructuralFeature getReasonFeature() {
        return this.reasonFeature;
    }

    public @Nullable SerializationMatchStep getReasonMatchStep() {
        return this.reasonMatchStep;
    }

    public @Nullable ParserRuleValue RuleValue() {
        return this.reasonRuleValue;
    }

    public @Nullable SerializationStep getReasonStep() {
        return this.reasonStep;
    }

    public @NonNull String getReasonString() {
        if (!this.matchFailed) {
            return "OK";
        }
        EStructuralFeature reasonFeature2 = this.reasonFeature;
        if (reasonFeature2 != null) {
            return "Incompatible/missing '" + reasonFeature2.getEContainingClass().getName() + "::" + reasonFeature2.getName() + "' values.";
        }
        if (this.reasonMatchStep != null) {
            return this.reasonMatchStep.getFailureReason(this);
        }
        if (this.reasonRuleValue != null) {
            return "Required '" + this.reasonRuleValue + "'";
        }
        assert (this.reasonStep != null);
        return this.reasonStep.getFailureReason(this);
    }

    public @NonNull SerializationRule getSerializationRule() {
        return this.serializationRule;
    }

    @Override
    public @NonNull Integer getSize(@NonNull EStructuralFeature eStructuralFeature) {
        return this.elementAnalysis.getSize(eStructuralFeature);
    }

    @Override
    public @NonNull Integer getSize(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue) {
        return this.elementAnalysis.getSize(eAttribute, enumerationValue);
    }

    @Override
    public @NonNull Integer getSize(@NonNull EReference eReference, @NonNull GrammarRuleVector grammarRuleVector) {
        return this.elementAnalysis.getSize(eReference, grammarRuleVector);
    }

    public @NonNull Integer getValue(int variableIndex) {
        assert (variableIndex >= 0);
        return SerializationUtils.nonNullState(this.variableIndex2value.get(variableIndex));
    }

    public boolean matchFailed() {
        return this.matchFailed;
    }

    public void putValue(@NonNull Integer variableIndex, @NonNull Integer integerSolution) {
        this.variableIndex2value.put(variableIndex, integerSolution);
    }

    public void setFailedMatch(@NonNull ParserRuleValue reasonRuleValue) {
        assert (!this.matchFailed);
        assert (this.reasonFeature == null);
        assert (this.reasonMatchStep == null);
        assert (this.reasonRuleValue == null);
        assert (this.reasonStep == null);
        this.reasonRuleValue = reasonRuleValue;
        this.setMatchFailed();
    }

    public void setFailedMatch(@NonNull EStructuralFeature reasonFeature) {
        assert (!this.matchFailed);
        assert (this.reasonFeature == null);
        assert (this.reasonMatchStep == null);
        assert (this.reasonRuleValue == null);
        assert (this.reasonStep == null);
        this.reasonFeature = reasonFeature;
        String basicGetReasonString = this.basicGetReasonString();
        assert (basicGetReasonString != null);
        this.setMatchFailed();
    }

    public void setFailedMatch(@NonNull SerializationMatchStep reasonMatchStep) {
        assert (!this.matchFailed);
        assert (this.reasonFeature == null);
        assert (this.reasonMatchStep == null);
        assert (this.reasonRuleValue == null);
        assert (this.reasonStep == null);
        assert (!(reasonMatchStep instanceof SerializationMatchStep.MatchStep_Runtime));
        this.reasonMatchStep = reasonMatchStep;
        this.setMatchFailed();
    }

    public void setFailedMatch(@NonNull SerializationStep reasonStep) {
        assert (!this.matchFailed);
        assert (this.reasonFeature == null);
        assert (this.reasonMatchStep == null);
        assert (this.reasonRuleValue == null);
        assert (this.reasonStep == null);
        this.reasonStep = reasonStep;
        this.setMatchFailed();
    }

    private void setMatchFailed() {
        assert (!this.matchFailed);
        assert (this.reasonFeature != null || this.reasonMatchStep != null || this.reasonRuleValue != null || this.reasonStep != null);
        this.matchFailed = true;
    }

    public @NonNull String toString() {
        DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder s = new DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder(this.elementAnalysis.getModelAnalysis().getSerializationMetaData());
        this.toString(s, 0);
        return s.toString();
    }

    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        this.serializationRule.toString(s, depth);
        ArrayList<@NonNull Integer> variableIndexes = new ArrayList<Integer>(this.variableIndex2value.keySet());
        Collections.sort(variableIndexes);
        for (Integer variableIndex : variableIndexes) {
            Integer value = SerializationUtils.maybeNull(this.variableIndex2value.get(variableIndex));
            s.appendIndentation(depth);
            s.appendVariableName(variableIndex);
            s.append(" = " + value);
        }
        String reasonString = this.basicGetReasonString();
        if (reasonString != null) {
            s.appendIndentation(depth);
            s.append(reasonString);
        }
    }
}

