/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Information about a MSE.
 */
@SuppressWarnings("all")
public class MSEDto {
  /**
   * URI of the caller EObject in the model
   */
  private String callerEObjectURI;
  
  /**
   * ID of the action applied to the EObject. Typically the URI of the EOperation.
   */
  private String actionID;
  
  /**
   * URI of the caller EObject in the model
   */
  @Pure
  public String getCallerEObjectURI() {
    return this.callerEObjectURI;
  }
  
  /**
   * URI of the caller EObject in the model
   */
  public void setCallerEObjectURI(final String callerEObjectURI) {
    this.callerEObjectURI = callerEObjectURI;
  }
  
  /**
   * ID of the action applied to the EObject. Typically the URI of the EOperation.
   */
  @Pure
  public String getActionID() {
    return this.actionID;
  }
  
  /**
   * ID of the action applied to the EObject. Typically the URI of the EOperation.
   */
  public void setActionID(final String actionID) {
    this.actionID = actionID;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("callerEObjectURI", this.callerEObjectURI);
    b.add("actionID", this.actionID);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    MSEDto other = (MSEDto) obj;
    if (this.callerEObjectURI == null) {
      if (other.callerEObjectURI != null)
        return false;
    } else if (!this.callerEObjectURI.equals(other.callerEObjectURI))
      return false;
    if (this.actionID == null) {
      if (other.actionID != null)
        return false;
    } else if (!this.actionID.equals(other.actionID))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.callerEObjectURI== null) ? 0 : this.callerEObjectURI.hashCode());
    return prime * result + ((this.actionID== null) ? 0 : this.actionID.hashCode());
  }
}
