/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.occurrences;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.occurrences.IOccurrenceComputer;
import org.eclipse.xtext.ui.editor.occurrences.Messages;

public class OccurrenceMarker {
    private ISelectionChangedListener selectionListener;
    private boolean isMarkOccurrences;
    private XtextEditor editor;
    @Inject
    private MarkOccurrenceJob markOccurrenceJob;

    public void connect(XtextEditor editor, boolean isMarkOccurrences) {
        this.editor = editor;
        ((IPostSelectionProvider)editor.getSelectionProvider()).addPostSelectionChangedListener(this.getSelectionChangedListener());
        this.isMarkOccurrences = isMarkOccurrences;
    }

    public void disconnect(XtextEditor editor) {
        ((IPostSelectionProvider)editor.getSelectionProvider()).removePostSelectionChangedListener(this.getSelectionChangedListener());
    }

    public void setMarkOccurrences(boolean isMarkOccurrences) {
        this.isMarkOccurrences = isMarkOccurrences;
        this.doMarkOccurrences(this.editor.getSelectionProvider().getSelection());
    }

    protected void doMarkOccurrences(ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.markOccurrenceJob.cancel();
            this.markOccurrenceJob.initialize(this.editor, (ITextSelection)selection, this.isMarkOccurrences);
            if (!this.markOccurrenceJob.isSystem()) {
                this.markOccurrenceJob.setSystem(true);
            }
            this.markOccurrenceJob.setPriority(50);
            this.markOccurrenceJob.schedule();
        }
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionListener == null) {
            this.selectionListener = this.createSelectionChangedListener();
        }
        return this.selectionListener;
    }

    protected ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (OccurrenceMarker.this.isMarkOccurrences) {
                    OccurrenceMarker.this.doMarkOccurrences(event.getSelection());
                }
            }
        };
    }

    public static class MarkOccurrenceJob
    extends Job {
        @Inject
        private IOccurrenceComputer occurrenceComputer;
        private XtextEditor initialEditor;
        private boolean initialIsMarkOccurrences;
        private ITextSelection initialSelection;

        public MarkOccurrenceJob() {
            super(Messages.OccurrenceMarker_MarkOccurrenceJob_title);
        }

        public void initialize(XtextEditor editor, ITextSelection selection, boolean isMarkOccurrences) {
            this.initialEditor = editor;
            this.initialIsMarkOccurrences = isMarkOccurrences;
            this.initialSelection = selection;
        }

        protected IStatus run(IProgressMonitor monitor) {
            final XtextEditor editor = this.initialEditor;
            boolean isMarkOccurrences = this.initialIsMarkOccurrences;
            ITextSelection selection = this.initialSelection;
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            if (!progress.isCanceled()) {
                Map annotations;
                Map<Object, Object> map = annotations = isMarkOccurrences ? this.occurrenceComputer.createAnnotationMap(editor, selection, progress.newChild(1)) : Collections.emptyMap();
                if (!progress.isCanceled()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!progress.isCanceled()) {
                                IAnnotationModel annotationModel = this.getAnnotationModel(editor);
                                if (annotationModel instanceof IAnnotationModelExtension) {
                                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.getExistingOccurrenceAnnotations(annotationModel), annotations);
                                } else if (annotationModel != null) {
                                    throw new IllegalStateException("AnnotationModel does not implement IAnnotationModelExtension");
                                }
                            }
                        }
                    });
                }
            }
            return progress.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        protected IAnnotationModel getAnnotationModel(XtextEditor editor) {
            IDocumentProvider documentProvider;
            IEditorInput editorInput;
            if (editor != null && (editorInput = editor.getEditorInput()) != null && (documentProvider = editor.getDocumentProvider()) != null) {
                return documentProvider.getAnnotationModel((Object)editorInput);
            }
            return null;
        }

        protected Annotation[] getExistingOccurrenceAnnotations(IAnnotationModel annotationModel) {
            HashSet removeSet = Sets.newHashSet();
            Iterator annotationIter = annotationModel.getAnnotationIterator();
            while (annotationIter.hasNext()) {
                Annotation annotation = (Annotation)annotationIter.next();
                if (!this.occurrenceComputer.hasAnnotationType(annotation.getType())) continue;
                removeSet.add(annotation);
            }
            return (Annotation[])Iterables.toArray((Iterable)removeSet, Annotation.class);
        }
    }
}

