/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;
import org.eclipse.xtext.ui.editor.model.DocumentPartitioner;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.testing.MockableSelectionProvider;
import org.eclipse.xtext.ui.testing.MockableTextViewer;
import org.eclipse.xtext.ui.testing.util.LineDelimiters;
import org.eclipse.xtext.ui.testing.util.ResourceLoadHelper;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.junit.Assert;

public class ContentAssistProcessorTestBuilder
implements Cloneable {
    private String model;
    private String suffix;
    private int cursorPosition;
    private Injector injector;
    private boolean announceDirtyState;
    private final ResourceLoadHelper loadHelper;
    @Inject(optional=true)
    private IDirtyStateManager dirtyStateManager;
    private IDirtyResource dirtyResource;

    public ContentAssistProcessorTestBuilder(Injector injector, ResourceLoadHelper helper) throws Exception {
        this.injector = injector;
        this.injector.injectMembers((Object)this);
        this.loadHelper = helper;
    }

    public ContentAssistProcessorTestBuilder reset() throws Exception {
        return this.clone("", 0);
    }

    public ContentAssistProcessorTestBuilder append(String model) throws Exception {
        return this.clone(String.valueOf(this.getModel()) + model, this.cursorPosition + model.length());
    }

    public ContentAssistProcessorTestBuilder appendSuffix(String suffix) throws Exception {
        return this.cloneWithSuffix(this.suffix == null ? suffix : String.valueOf(this.suffix) + suffix);
    }

    public ContentAssistProcessorTestBuilder appendNl(String model) throws Exception {
        return this.append(model).append(Strings.newLine());
    }

    public ContentAssistProcessorTestBuilder insert(String model) throws Exception {
        return this.insert(model, this.getCursorPosition());
    }

    public ContentAssistProcessorTestBuilder insert(String model, int cursorPosition) throws Exception {
        StringBuilder builder = new StringBuilder(this.getModel()).insert(cursorPosition, model);
        return this.clone(builder.toString(), cursorPosition + model.length());
    }

    public ContentAssistProcessorTestBuilder cursorBack(int times) throws Exception {
        return this.clone(this.model, this.cursorPosition -= times);
    }

    public ContentAssistProcessorTestBuilder appendAndApplyProposal(String model) throws Exception {
        return this.appendAndApplyProposal(model, this.cursorPosition);
    }

    public ContentAssistProcessorTestBuilder appendAndApplyProposal(String model, String proposal) throws Exception {
        return this.appendAndApplyProposal(model, this.cursorPosition, proposal);
    }

    public ContentAssistProcessorTestBuilder appendAndApplyProposal(String model, int position) throws Exception {
        return this.appendAndApplyProposal(model, position, null);
    }

    public ContentAssistProcessorTestBuilder appendAndApplyProposal(String model, int position, String proposalString) throws Exception {
        IXtextDocument document = this.getDocument(this.getModel());
        Shell shell = new Shell();
        try {
            XtextSourceViewerConfiguration configuration = this.get(XtextSourceViewerConfiguration.class);
            ISourceViewer sourceViewer = this.getSourceViewer(shell, document, configuration);
            ICompletionProposal[] proposals = this.computeCompletionProposals(document, position, shell);
            ICompletionProposal proposal = this.findProposal(proposalString, proposals);
            ContentAssistProcessorTestBuilder contentAssistProcessorTestBuilder = this.appendAndApplyProposal(proposal, sourceViewer, model, position);
            return contentAssistProcessorTestBuilder;
        }
        finally {
            shell.dispose();
        }
    }

    protected ContentAssistProcessorTestBuilder appendAndApplyProposal(ICompletionProposal proposal, ISourceViewer sourceViewer, String model, int position) throws Exception {
        IDocument document = sourceViewer.getDocument();
        int offset = position;
        if (model != null) {
            document.set(String.valueOf(this.getModel()) + model);
            offset += model.length();
        }
        if (proposal instanceof ICompletionProposalExtension2) {
            ICompletionProposalExtension2 proposalExtension2 = (ICompletionProposalExtension2)proposal;
            proposalExtension2.apply((ITextViewer)sourceViewer, '\u0000', 0, offset);
        } else if (proposal instanceof ICompletionProposalExtension) {
            ICompletionProposalExtension proposalExtension = (ICompletionProposalExtension)proposal;
            proposalExtension.apply(document, '\u0000', offset);
        } else {
            proposal.apply(document);
        }
        return this.reset().append(document.get());
    }

    public ContentAssistProcessorTestBuilder applyProposal() throws Exception {
        return this.applyProposal(this.cursorPosition);
    }

    public ContentAssistProcessorTestBuilder applyProposal(String proposal) throws Exception {
        return this.applyProposal(this.cursorPosition, proposal);
    }

    public ContentAssistProcessorTestBuilder applyProposal(int position) throws Exception {
        return this.applyProposal(position, null);
    }

    public ContentAssistProcessorTestBuilder applyProposal(int position, String proposalString) throws Exception {
        IXtextDocument document = this.getDocument(this.getModel());
        Shell shell = new Shell();
        try {
            ICompletionProposal[] proposals = this.computeCompletionProposals(document, position, shell);
            ICompletionProposal proposal = this.findProposal(proposalString, proposals);
            ContentAssistProcessorTestBuilder contentAssistProcessorTestBuilder = this.applyProposal(proposal, position, document);
            return contentAssistProcessorTestBuilder;
        }
        finally {
            shell.dispose();
        }
    }

    protected ICompletionProposal findProposal(String proposalString, ICompletionProposal[] proposals) {
        if (proposalString != null) {
            String platformDelimitedProposal = LineDelimiters.toPlatform(proposalString);
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal candidate = iCompletionProposalArray[n2];
                if (platformDelimitedProposal.equals(this.getProposedText(candidate))) {
                    return candidate;
                }
                ++n2;
            }
        }
        return proposals[0];
    }

    protected ContentAssistProcessorTestBuilder applyProposal(ICompletionProposal proposal) throws Exception {
        IXtextDocument document = this.getDocument(this.model);
        return this.applyProposal(proposal, document);
    }

    protected ContentAssistProcessorTestBuilder applyProposal(ICompletionProposal proposal, IXtextDocument document) throws Exception {
        return this.applyProposal(proposal, this.cursorPosition, document);
    }

    protected ContentAssistProcessorTestBuilder applyProposal(ICompletionProposal proposal, int position, IXtextDocument document) throws Exception {
        Shell shell = new Shell();
        try {
            XtextSourceViewerConfiguration configuration = this.get(XtextSourceViewerConfiguration.class);
            ISourceViewer sourceViewer = this.getSourceViewer(shell, document, configuration);
            ContentAssistProcessorTestBuilder contentAssistProcessorTestBuilder = this.appendAndApplyProposal(proposal, sourceViewer, this.model, position);
            return contentAssistProcessorTestBuilder;
        }
        finally {
            shell.dispose();
        }
    }

    public ContentAssistProcessorTestBuilder expectContent(String expectation) {
        Assert.assertEquals((Object)expectation, (Object)this.getModel());
        return this;
    }

    public ContentAssistProcessorTestBuilder assertCount(int completionProposalCount) throws Exception {
        return this.assertCountAtCursorPosition(completionProposalCount, this.cursorPosition);
    }

    public ContentAssistProcessorTestBuilder assertText(String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.cursorPosition, expectedText);
    }

    public ProposalTester assertProposalAtCursor(String expectedText) throws Exception {
        ICompletionProposal[] proposals;
        ICompletionProposal[] iCompletionProposalArray = proposals = this.getProposalsAtCursorIndicator();
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (expectedText.equals(this.toString(proposal))) {
                return new ProposalTester(proposal);
            }
            ++n2;
        }
        Assert.fail((String)("No such proposal: " + expectedText + " Found: " + this.toString(proposals)));
        return null;
    }

    public void assertNoProposalAtCursor(String unexpectedText) throws Exception {
        ICompletionProposal[] proposals;
        ICompletionProposal[] iCompletionProposalArray = proposals = this.getProposalsAtCursorIndicator();
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (unexpectedText.equals(this.toString(proposal))) {
                Assert.fail((String)("Unexpected proposal: " + unexpectedText + " Found: " + this.toString(proposals)));
            }
            ++n2;
        }
    }

    public ICompletionProposal[] getProposalsAtCursorIndicator() throws Exception {
        String currentModelToParse = this.getFullTextToBeParsed();
        int idx = currentModelToParse.indexOf("<|>");
        ICompletionProposal[] proposals = this.computeCompletionProposals(currentModelToParse = String.valueOf(currentModelToParse.substring(0, idx)) + currentModelToParse.substring(idx + 3), idx);
        if (proposals == null) {
            proposals = new ICompletionProposal[]{};
        }
        return proposals;
    }

    public ProposalTester assertProposalDisplayedAtCursor(String displayString) throws Exception {
        ICompletionProposal[] proposals;
        ICompletionProposal[] iCompletionProposalArray = proposals = this.getProposalsAtCursorIndicator();
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (displayString.equals(proposal.getDisplayString())) {
                return new ProposalTester(proposal);
            }
            ++n2;
        }
        Assert.fail((String)("No such proposal: " + displayString + " Found: " + this.toDisplayString(proposals)));
        return null;
    }

    public ProposalTester assertProposal(String expectedText) throws Exception {
        String currentModelToParse = this.getFullTextToBeParsed();
        ICompletionProposal[] proposals = this.computeCompletionProposals(currentModelToParse, this.cursorPosition);
        if (proposals == null) {
            proposals = new ICompletionProposal[]{};
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (expectedText.equals(this.toString(proposal))) {
                return new ProposalTester(proposal);
            }
            ++n2;
        }
        Assert.fail((String)("No such proposal: " + expectedText + " Found: " + this.toString(proposals)));
        return null;
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(String cursorPosition, String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.getModel().indexOf(cursorPosition), expectedText);
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(String cursorPosition, int offset, String ... expectedText) throws Exception {
        return this.assertTextAtCursorPosition(this.getModel().indexOf(cursorPosition) + offset, expectedText);
    }

    public ContentAssistProcessorTestBuilder assertTextAtCursorPosition(int cursorPosition, String ... expectations) throws Exception {
        String expectation;
        String currentModelToParse = this.getFullTextToBeParsed();
        ICompletionProposal[] computeCompletionProposals = this.computeCompletionProposals(currentModelToParse, cursorPosition);
        if (computeCompletionProposals == null) {
            computeCompletionProposals = new ICompletionProposal[]{};
        }
        Arrays.sort(expectations);
        ArrayList sortedExpectations = Lists.newArrayList();
        String[] stringArray = expectations;
        int n = expectations.length;
        int n2 = 0;
        while (n2 < n) {
            expectation = stringArray[n2];
            sortedExpectations.add(LineDelimiters.toPlatform(expectation));
            ++n2;
        }
        expectation = LineDelimiters.toPlatform(Strings.concat((String)Strings.newLine(), (List)sortedExpectations));
        String actual = LineDelimiters.toPlatform(Strings.concat((String)Strings.newLine(), this.toString(computeCompletionProposals)));
        Assert.assertEquals((Object)expectation, (Object)actual);
        int i = 0;
        while (i < computeCompletionProposals.length) {
            ICompletionProposal completionProposal = computeCompletionProposals[i];
            String proposedText = LineDelimiters.toPlatform(this.getProposedText(completionProposal));
            Assert.assertTrue((String)("Missing proposal '" + proposedText + "'. Expect completionProposal text '" + expectation + "', but got " + actual), (boolean)sortedExpectations.contains(proposedText));
            ++i;
        }
        return this;
    }

    protected String getProposedText(ICompletionProposal completionProposal) {
        String proposedText = completionProposal.getDisplayString();
        if (completionProposal instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurableProposal = (ConfigurableCompletionProposal)completionProposal;
            proposedText = configurableProposal.getReplacementString();
            if (configurableProposal.getTextApplier() instanceof ReplacementTextApplier) {
                proposedText = ((ReplacementTextApplier)configurableProposal.getTextApplier()).getActualReplacementString(configurableProposal);
            }
        }
        return proposedText;
    }

    public ContentAssistProcessorTestBuilder assertMatchString(String matchString) throws Exception {
        String currentModelToParse = this.getModel();
        XtextResource xtextResource = this.loadHelper.getResourceFor((InputStream)new StringInputStream(currentModelToParse));
        IXtextDocument xtextDocument = this.getDocument(xtextResource, currentModelToParse);
        XtextSourceViewerConfiguration configuration = this.get(XtextSourceViewerConfiguration.class);
        Shell shell = new Shell();
        try {
            ISourceViewer sourceViewer = this.getSourceViewer(shell, xtextDocument, configuration);
            IContentAssistant contentAssistant = configuration.getContentAssistant(sourceViewer);
            String contentType = xtextDocument.getContentType(currentModelToParse.length());
            if (contentAssistant.getContentAssistProcessor(contentType) != null) {
                ContentAssistContext[] contexts;
                ContentAssistContext.Factory factory = this.get(ContentAssistContext.Factory.class);
                ContentAssistContext[] contentAssistContextArray = contexts = factory.create((ITextViewer)sourceViewer, currentModelToParse.length(), xtextResource);
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentAssistContext context = contentAssistContextArray[n2];
                    Assert.assertTrue((String)("matchString = '" + matchString + "', actual: '" + context.getPrefix() + "'"), ("".equals(context.getPrefix()) || matchString.equals(context.getPrefix()) ? 1 : 0) != 0);
                    ++n2;
                }
            } else {
                Assert.fail((String)("No content assistant for content type " + contentType));
            }
            ContentAssistProcessorTestBuilder contentAssistProcessorTestBuilder = this;
            return contentAssistProcessorTestBuilder;
        }
        finally {
            shell.dispose();
        }
    }

    public ContentAssistProcessorTestBuilder assertCursorIsAfter(String text) {
        Assert.assertTrue((String)("cursor should be after '" + text + "' but it's after " + this.model.substring(0, this.getCursorPosition())), (boolean)this.model.substring(this.getCursorPosition() - text.length()).startsWith(text));
        return this;
    }

    public ContentAssistProcessorTestBuilder assertCursorIsBefore(String text) {
        Assert.assertTrue((String)("cursor should be before '" + text + "' but it's before " + this.model.substring(this.getCursorPosition())), (boolean)this.model.substring(this.getCursorPosition()).startsWith(text));
        return this;
    }

    protected String getModel() {
        return this.model == null ? "" : this.model;
    }

    protected String getFullTextToBeParsed() {
        return String.valueOf(this.getModel()) + (this.suffix == null ? "" : this.suffix);
    }

    public List<String> toDisplayString(ICompletionProposal[] proposals) {
        if (proposals == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(proposals.length);
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String proposedText = proposal.getDisplayString();
            res.add(proposedText);
            ++n2;
        }
        Collections.sort(res);
        return res;
    }

    public List<String> toString(ICompletionProposal[] proposals) {
        if (proposals == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(proposals.length);
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String proposedText = this.toString(proposal);
            res.add(proposedText);
            ++n2;
        }
        Collections.sort(res);
        return res;
    }

    protected String toString(ICompletionProposal proposal) {
        return this.getProposedText(proposal);
    }

    public ContentAssistProcessorTestBuilder assertCountAtCursorPosition(int completionProposalCount, int cursorPosition) throws Exception {
        String currentModelToParse = this.getFullTextToBeParsed();
        ICompletionProposal[] computeCompletionProposals = this.computeCompletionProposals(currentModelToParse, cursorPosition);
        StringBuffer computedProposals = new StringBuffer();
        int i = 0;
        while (i < computeCompletionProposals.length) {
            computedProposals.append(computeCompletionProposals[i].getDisplayString());
            if (i < computeCompletionProposals.length - 1) {
                computedProposals.append(",");
            }
            ++i;
        }
        Assert.assertEquals((String)("expect only " + completionProposalCount + " CompletionProposal item for model '" + currentModelToParse + "' but got '" + computedProposals + "'"), (long)completionProposalCount, (long)computeCompletionProposals.length);
        return this;
    }

    public ICompletionProposal[] computeCompletionProposals(String currentModelToParse, int cursorPosition) throws Exception {
        try {
            IXtextDocument xtextDocument = this.getDocument(currentModelToParse);
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals(xtextDocument, cursorPosition);
            return iCompletionProposalArray;
        }
        finally {
            if (this.announceDirtyState) {
                this.dirtyStateManager.discardDirtyState(this.dirtyResource);
            }
        }
    }

    protected ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition) throws BadLocationException {
        Shell shell = new Shell();
        try {
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals(xtextDocument, cursorPosition, shell);
            return iCompletionProposalArray;
        }
        finally {
            shell.dispose();
        }
    }

    protected ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition, Shell shell) throws BadLocationException {
        XtextSourceViewerConfiguration configuration = this.get(XtextSourceViewerConfiguration.class);
        ISourceViewer sourceViewer = this.getSourceViewer(shell, xtextDocument, configuration);
        return this.computeCompletionProposals(xtextDocument, cursorPosition, configuration, sourceViewer);
    }

    protected ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition, XtextSourceViewerConfiguration configuration, ISourceViewer sourceViewer) throws BadLocationException {
        String contentType;
        IContentAssistant contentAssistant = configuration.getContentAssistant(sourceViewer);
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(contentType = xtextDocument.getContentType(cursorPosition));
        if (processor != null) {
            return processor.computeCompletionProposals((ITextViewer)sourceViewer, cursorPosition);
        }
        return new ICompletionProposal[0];
    }

    public ContentAssistProcessorTestBuilder withDirtyState() throws Exception {
        ContentAssistProcessorTestBuilder result = this.clone(this.model, this.cursorPosition);
        result.announceDirtyState = true;
        return result;
    }

    protected IXtextDocument getDocument(final String currentModelToParse) {
        final XtextResource xtextResource = this.loadHelper.getResourceFor((InputStream)new StringInputStream(Strings.emptyIfNull((String)currentModelToParse)));
        if (this.announceDirtyState) {
            this.dirtyResource = new IDirtyResource(){

                public String getContents() {
                    return currentModelToParse;
                }

                public String getActualContents() {
                    return currentModelToParse;
                }

                public IResourceDescription getDescription() {
                    return xtextResource.getResourceServiceProvider().getResourceDescriptionManager().getResourceDescription((Resource)xtextResource);
                }

                public URI getURI() {
                    return xtextResource.getURI();
                }
            };
            this.dirtyStateManager.manageDirtyState(this.dirtyResource);
        }
        return this.getDocument(xtextResource, currentModelToParse);
    }

    protected ISourceViewer getSourceViewer(Shell shell, IXtextDocument xtextDocument, XtextSourceViewerConfiguration configuration) {
        XtextSourceViewer.Factory factory = this.get(XtextSourceViewer.Factory.class);
        XtextSourceViewer sourceViewer = factory.createSourceViewer((Composite)shell, null, null, false, 0);
        sourceViewer.configure((SourceViewerConfiguration)configuration);
        sourceViewer.setDocument((IDocument)xtextDocument);
        return sourceViewer;
    }

    public ICompletionProposal[] computeCompletionProposals(int cursorPosition) throws Exception {
        return this.computeCompletionProposals(this.getFullTextToBeParsed(), cursorPosition);
    }

    public ICompletionProposal[] computeCompletionProposals(String cursorPosition) throws Exception {
        return this.computeCompletionProposals(this.getFullTextToBeParsed(), this.getModel().indexOf(cursorPosition));
    }

    public ICompletionProposal[] computeCompletionProposals() throws Exception {
        return this.computeCompletionProposals(this.getFullTextToBeParsed(), this.cursorPosition);
    }

    public String toString() {
        return String.valueOf(this.getModel()) + "\n length: " + this.getModel().length() + "\n cursor at: " + this.cursorPosition;
    }

    public IXtextDocument getDocument(XtextResource xtextResource, String model) {
        XtextDocument document = this.get(XtextDocument.class);
        document.set(model);
        document.setInput(xtextResource);
        DocumentPartitioner partitioner = this.get(DocumentPartitioner.class);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }

    public ITextViewer getSourceViewer(String currentModelToParse, final IXtextDocument xtextDocument) {
        MockableTextViewer result = new MockableTextViewer(){

            @Override
            public IDocument getDocument() {
                return xtextDocument;
            }

            @Override
            public ISelectionProvider getSelectionProvider() {
                return new MockableSelectionProvider(){

                    @Override
                    public ISelection getSelection() {
                        return TextSelection.emptySelection();
                    }
                };
            }

            @Override
            public StyledText getTextWidget() {
                return null;
            }
        };
        return result;
    }

    protected ContentAssistProcessorTestBuilder clone(String model, int offset) throws Exception {
        ContentAssistProcessorTestBuilder builder = (ContentAssistProcessorTestBuilder)this.clone();
        builder.model = model;
        builder.cursorPosition = offset;
        builder.suffix = this.suffix;
        builder.announceDirtyState = this.announceDirtyState;
        return builder;
    }

    protected ContentAssistProcessorTestBuilder cloneWithSuffix(String postFix) throws Exception {
        ContentAssistProcessorTestBuilder builder = (ContentAssistProcessorTestBuilder)this.clone();
        builder.model = this.model;
        builder.cursorPosition = this.cursorPosition;
        builder.suffix = postFix;
        builder.announceDirtyState = this.announceDirtyState;
        return builder;
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    protected int getCursorPosition() {
        return this.cursorPosition;
    }

    public static class Factory {
        private Injector injector;

        @Inject
        public Factory(Injector injector) {
            this.injector = injector;
        }

        public ContentAssistProcessorTestBuilder create(ResourceLoadHelper resourceLoadHelper) throws Exception {
            return new ContentAssistProcessorTestBuilder(this.injector, resourceLoadHelper);
        }
    }

    public class ProposalTester {
        private ICompletionProposal proposal;

        protected ProposalTester(ICompletionProposal proposal) {
            this.proposal = proposal;
        }

        public ProposalTester withDisplayString(String displayString) {
            Assert.assertEquals((String)"displayString", (Object)displayString, (Object)this.proposal.getDisplayString());
            return this;
        }

        public ContentAssistProcessorTestBuilder apply() throws Exception {
            return ContentAssistProcessorTestBuilder.this.applyProposal(this.proposal);
        }
    }
}

