/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.codemining;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

class CodeMiningProviderDescriptor {
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private static final String ENABLED_WHEN_ATTR = "enabledWhen";
    private IConfigurationElement fConfiguration;
    private String fLabel;
    private String fId;
    private final Expression fEnabledWhen;

    public CodeMiningProviderDescriptor(IConfigurationElement element) throws CoreException {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.fConfiguration = element;
        this.fEnabledWhen = CodeMiningProviderDescriptor.createEnabledWhen(this.fConfiguration, this.getId());
    }

    private static Expression createEnabledWhen(IConfigurationElement configElement, String id) throws CoreException {
        IConfigurationElement[] children = configElement.getChildren(ENABLED_WHEN_ATTR);
        if (children.length > 0) {
            IConfigurationElement[] subChildren = children[0].getChildren();
            if (subChildren.length != 1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.workbench.texteditor", "One <enabledWhen> element is accepted. Disabling " + id));
            }
            ElementHandler elementHandler = ElementHandler.getDefault();
            ExpressionConverter converter = ExpressionConverter.getDefault();
            return elementHandler.create(converter, subChildren[0]);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.workbench.texteditor", "<enabledWhen> element is required. Disabling " + id));
    }

    public String getLabel() {
        if (this.fLabel == null) {
            this.fLabel = this.fConfiguration.getAttribute(LABEL_ATTRIBUTE);
            Assert.isNotNull((Object)this.fLabel);
        }
        return this.fLabel;
    }

    public String getId() {
        if (this.fId == null) {
            this.fId = this.fConfiguration.getAttribute(ID_ATTRIBUTE);
            Assert.isNotNull((Object)this.fId);
        }
        return this.fId;
    }

    protected ICodeMiningProvider createCodeMiningProvider(ITextEditor editor) {
        try {
            Object extension = this.fConfiguration.createExecutableExtension(CLASS_ATTRIBUTE);
            if (extension instanceof ICodeMiningProvider) {
                if (extension instanceof AbstractCodeMiningProvider) {
                    ((AbstractCodeMiningProvider)extension).setContext((IAdaptable)editor);
                }
                return (ICodeMiningProvider)extension;
            }
            String message = "Invalid extension to codeMiningProviders. Must extends ICodeMiningProvider: " + this.getId();
            TextEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.workbench.texteditor", message));
            return null;
        }
        catch (CoreException e) {
            TextEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.workbench.texteditor", "Error while creating codeMiningProvider: " + this.getId(), (Throwable)e));
            return null;
        }
    }

    public boolean matches(ISourceViewer viewer, ITextEditor editor) {
        EvaluationContext context = new EvaluationContext(null, (Object)editor);
        context.setAllowPluginActivation(true);
        context.addVariable("viewer", (Object)viewer);
        context.addVariable("editor", (Object)editor);
        context.addVariable("editorInput", (Object)editor.getEditorInput());
        try {
            return this.fEnabledWhen.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            TextEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.workbench.texteditor", "Error while 'enabledWhen' evaluation", (Throwable)e));
            return false;
        }
    }
}

