/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;
import org.eclipse.sirius.common.tools.api.interpreter.IVariableStatusListener;
import org.eclipse.sirius.common.tools.api.interpreter.TypedValidation;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public abstract class AbstractInterpreter
implements IInterpreter,
TypedValidation,
IInterpreterWithDiagnostic {
    protected static final String SEPARATOR = ".";

    @Override
    public boolean provides(String expression) {
        return expression != null && expression.startsWith(this.getPrefix());
    }

    @Override
    public Collection<EObject> evaluateCollection(EObject context, String expression) throws EvaluationException {
        Object raw = this.evaluate(context, expression);
        Collection<Object> result = raw instanceof Collection ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Collection)raw), EObject.class)) : (raw instanceof EObject ? Collections.singleton((EObject)raw) : (raw != null && raw.getClass().isArray() ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])((Object[])raw)), EObject.class)) : Collections.emptySet()));
        return result;
    }

    @Override
    public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
        String toString;
        Object raw = this.evaluate(context, expression);
        boolean result = raw == null ? false : (raw instanceof Boolean ? (Boolean)raw : ("true".equalsIgnoreCase(toString = raw.toString()) ? true : !"false".equalsIgnoreCase(toString)));
        return result;
    }

    @Override
    public EObject evaluateEObject(EObject context, String expression) throws EvaluationException {
        Object raw = this.evaluate(context, expression);
        if (raw instanceof EObject) {
            return (EObject)raw;
        }
        return null;
    }

    @Override
    public String evaluateString(EObject context, String expression) throws EvaluationException {
        Object raw = this.evaluate(context, expression);
        if (raw != null) {
            return String.valueOf(raw);
        }
        return "";
    }

    @Override
    public Integer evaluateInteger(EObject context, String expression) throws EvaluationException {
        Object raw = this.evaluate(context, expression);
        try {
            return Integer.parseInt(String.valueOf(raw));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public void clearImports() {
    }

    @Override
    public void addImport(String dependency) {
    }

    @Override
    public void setProperty(Object key, Object value) {
    }

    @Override
    public void setVariable(String name, Object value) {
    }

    @Override
    public void unSetVariable(String name) {
    }

    @Override
    public Object getVariable(String name) {
        return null;
    }

    @Override
    public void clearVariables() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addVariableStatusListener(IVariableStatusListener newListener) {
    }

    @Override
    public void removeVariableStatusListener(IVariableStatusListener listener) {
    }

    @Override
    public Map<String, ?> getVariables() {
        return Collections.emptyMap();
    }

    @Override
    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    @Override
    public String getVariablePrefix() {
        return "";
    }

    @Override
    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
    }

    @Override
    public Collection<String> getImports() {
        return Collections.emptySet();
    }

    @Override
    public void removeImport(String dependency) {
    }

    @Override
    public boolean supportsValidation() {
        return false;
    }

    @Override
    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return this.analyzeExpression(context, expression).getStatuses();
    }

    @Override
    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
    }

    @Override
    public IInterpreterWithDiagnostic.IEvaluationResult evaluateExpression(EObject target, String expression) throws EvaluationException {
        final Object result = this.evaluate(target, expression);
        return new IInterpreterWithDiagnostic.IEvaluationResult(){

            @Override
            public Object getValue() {
                return result;
            }

            @Override
            public Diagnostic getDiagnostic() {
                return Diagnostic.OK_INSTANCE;
            }
        };
    }
}

