/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGAssertNonNullExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCastExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCatchExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstant;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGGuardExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqual2Exp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqualExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsInvalidExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsKindOfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsUndefinedExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLocalVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModel;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGString;
import org.eclipse.ocl.examples.codegen.cgmodel.CGThrowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.utilities.CGModelResource;
import org.eclipse.ocl.examples.codegen.utilities.CGModelResourceFactory;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionExcludingOperation;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class CG2StringVisitor
extends AbstractExtendingCGModelVisitor<String, Object> {
    private static final Logger logger = Logger.getLogger(CG2StringVisitor.class);
    private static @NonNull Map<EPackage, Factory> factoryMap = new HashMap<EPackage, Factory>();
    public static @NonNull Factory FACTORY = new MyFactory();
    protected static @NonNull String NULL_PLACEHOLDER = "\"<null>\"";
    protected @NonNull StringBuilder result = new StringBuilder();

    public static synchronized void addFactory(@NonNull Factory factory) {
        factoryMap.put(factory.getEPackage(), factory);
    }

    public static String toString(@NonNull CGElement cgElement) {
        Factory factory;
        block4: {
            try {
                Resource resource = cgElement.eResource();
                if (resource instanceof CGModelResource) {
                    CGModelResourceFactory resourceFactory = ((CGModelResource)resource).getResourceFactory();
                    CG2StringVisitor v = resourceFactory.createToStringVisitor();
                    cgElement.accept(v);
                    return v.toString();
                }
                EPackage ePackage = cgElement.eClass().getEPackage();
                factory = factoryMap.get(ePackage);
                if (factory != null) break block4;
                logger.error((Object)("No CG2StringVisitor Factory registered for " + ePackage.getName()));
                return "null";
            }
            catch (Throwable e) {
                return e.toString();
            }
        }
        CG2StringVisitor v = factory.createToStringVisitor();
        cgElement.accept(v);
        return v.toString();
    }

    public CG2StringVisitor() {
        super(Object.class);
    }

    protected void append(Number number) {
        if (number != null) {
            this.result.append(number.toString());
        } else {
            this.result.append(NULL_PLACEHOLDER);
        }
    }

    protected void append(String string) {
        if (string != null) {
            this.result.append(string);
        } else {
            this.result.append(NULL_PLACEHOLDER);
        }
    }

    protected void appendElementType(@Nullable CGTypedElement cgTypedElement) {
        if (cgTypedElement == null) {
            this.append(NULL_PLACEHOLDER);
        } else {
            this.safeVisit(cgTypedElement.getTypeId());
            if (!cgTypedElement.isRequired()) {
                this.append("[?]");
            }
        }
    }

    protected void appendName(CGNamedElement cgNamedElement) {
        if (cgNamedElement == null) {
            this.result.append(NULL_PLACEHOLDER);
        } else {
            this.result.append(cgNamedElement.getName());
        }
    }

    protected void appendName(NamedElement namedElement) {
        if (namedElement == null) {
            this.result.append(NULL_PLACEHOLDER);
        } else {
            this.result.append(namedElement.getName());
        }
    }

    protected void appendOperationSignature(CGOperation cgOperation) {
        this.appendName(cgOperation);
        this.append("(");
        boolean comma = false;
        for (CGParameter parm : cgOperation.getParameters()) {
            if (comma) {
                this.append(", ");
            } else {
                comma = true;
            }
            this.appendName(parm);
            this.append(" : ");
            if (parm.getTypeId() != null) {
                this.appendElementType(parm);
                continue;
            }
            this.append("OclVoid");
        }
        this.append(") :");
        if (cgOperation.getTypeId() != null) {
            this.append(" ");
            this.appendElementType(cgOperation);
        }
    }

    protected void appendPropertySignature(CGTypedElement cgElement) {
        this.appendName(cgElement);
        if (cgElement.getTypeId() != null) {
            this.append(" : ");
            this.appendElementType(cgElement);
        }
    }

    protected void appendQualifiedName(CGNamedElement parent, String separator, CGNamedElement child) {
        if (parent != null) {
            this.appendQualifiedName(parent);
            this.append(separator);
        }
        this.appendName(child);
    }

    protected void appendQualifiedName(@Nullable CGNamedElement object) {
        if (object == null) {
            this.result.append(NULL_PLACEHOLDER);
        } else {
            EObject container = object.eContainer();
            if (container instanceof CGNamedElement) {
                this.appendQualifiedName((CGNamedElement)container);
                this.append("::");
            }
            this.appendName(object);
        }
    }

    public String toString() {
        return this.result.toString();
    }

    @Override
    public @Nullable String visitCGAssertNonNullExp(@NonNull CGAssertNonNullExp cgAssertNonNullExp) {
        this.append("$ASSERT_NON_NULL(");
        this.safeVisit(cgAssertNonNullExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGBoxExp(@NonNull CGBoxExp cgBoxExp) {
        this.append("$BOX(");
        this.safeVisit(cgBoxExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGBuiltInIterationCallExp(@NonNull CGBuiltInIterationCallExp cgExp) {
        this.safeVisit(cgExp.getSource());
        this.append("->");
        this.appendName((NamedElement)cgExp.getReferredIteration());
        this.append("(");
        boolean isFirst = true;
        for (CGIterator variable : cgExp.getIterators()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(variable);
            isFirst = false;
        }
        CGIterator cgAccumulator = cgExp.getAccumulator();
        if (cgAccumulator != null) {
            this.append("; ");
            this.safeVisit(cgAccumulator);
        }
        this.append(" | ");
        this.safeVisit(cgExp.getBody());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGCastExp(@NonNull CGCastExp cgCastExp) {
        this.append("$CAST(");
        this.safeVisit(cgCastExp.getExecutorType());
        this.append(",");
        this.safeVisit(cgCastExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGCatchExp(@NonNull CGCatchExp cgCatchExp) {
        this.append("$CATCH(");
        this.safeVisit(cgCatchExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public String visitCGClass(@NonNull CGClass cgClass) {
        this.appendQualifiedName(cgClass);
        return null;
    }

    @Override
    public @Nullable String visitCGCollectionExp(@NonNull CGCollectionExp cgCollectionExp) {
        this.append(((CollectionLiteralExp)cgCollectionExp.getAst()).getKind() + "{");
        boolean isFirst = true;
        for (CGCollectionPart cgPart : cgCollectionExp.getParts()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(cgPart);
            isFirst = false;
        }
        this.append("}");
        return null;
    }

    @Override
    public @Nullable String visitCGCollectionPart(@NonNull CGCollectionPart cgCollectionPart) {
        this.safeVisit(cgCollectionPart.getFirst());
        if (cgCollectionPart.isRange()) {
            this.append(" .. ");
            this.safeVisit(cgCollectionPart.getLast());
        }
        return null;
    }

    @Override
    public @Nullable String visitCGConstant(@NonNull CGConstant cgConstant) {
        this.append(cgConstant.getConstantValue().toString());
        return null;
    }

    @Override
    public @Nullable String visitCGConstantExp(@NonNull CGConstantExp cgConstantExp) {
        CGValuedElement referredConstant = cgConstantExp.getReferredConstant();
        if (referredConstant != null) {
            referredConstant.accept(this);
        }
        return null;
    }

    @Override
    public @Nullable String visitCGConstraint(@NonNull CGConstraint cgConstraint) {
        this.appendName(cgConstraint);
        this.append(": ");
        this.safeVisit(cgConstraint.getBody());
        return null;
    }

    @Override
    public @Nullable String visitCGEcoreExp(@NonNull CGEcoreExp cgEcoreExp) {
        Class instanceClass;
        String simpleName = "null";
        EClassifier eClassifier = cgEcoreExp.getEClassifier();
        if (eClassifier != null && (instanceClass = eClassifier.getInstanceClass()) != null) {
            simpleName = instanceClass.getSimpleName();
        }
        this.append("$ECORE(");
        this.append(simpleName);
        this.append(",");
        this.safeVisit(cgEcoreExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGGuardExp(@NonNull CGGuardExp cgGuardExp) {
        this.append("$GUARD(");
        this.safeVisit(cgGuardExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGIfExp(@NonNull CGIfExp cgExp) {
        this.append("if ");
        this.safeVisit(cgExp.getCondition());
        this.append(" then ");
        this.safeVisit(cgExp.getThenExpression());
        this.append(" else ");
        this.safeVisit(cgExp.getElseExpression());
        this.append(" endif");
        return null;
    }

    @Override
    public @Nullable String visitCGInvalid(@NonNull CGInvalid cgInvalid) {
        String messageTemplate = cgInvalid.getMessageTemplate();
        if (messageTemplate != null) {
            this.append("$INVALID(" + messageTemplate + ")");
        } else {
            this.append("invalid");
        }
        return null;
    }

    @Override
    public @Nullable String visitCGIsEqualExp(@NonNull CGIsEqualExp cgIsEqualExp) {
        this.append(cgIsEqualExp.isNotEquals() ? "$isNotEQUAL(" : "$isEQUAL(");
        this.safeVisit(cgIsEqualExp.getSource());
        this.append(",");
        this.safeVisit(cgIsEqualExp.getArgument());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGIsEqual2Exp(@NonNull CGIsEqual2Exp cgIsEqualExp) {
        this.append("$isEQUAL2(");
        this.safeVisit(cgIsEqualExp.getSource());
        this.append(",");
        this.safeVisit(cgIsEqualExp.getArgument());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGIsInvalidExp(@NonNull CGIsInvalidExp cgIsInvalidExp) {
        this.append("$isINVALID(");
        this.safeVisit(cgIsInvalidExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGIsKindOfExp(@NonNull CGIsKindOfExp cgIsKindOfExp) {
        this.append("$isKindOf(");
        this.safeVisit(cgIsKindOfExp.getExecutorType());
        this.append(",");
        this.safeVisit(cgIsKindOfExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGIsUndefinedExp(@NonNull CGIsUndefinedExp cgIsUndefinedExp) {
        this.append("$isUNDEFINED(");
        this.safeVisit(cgIsUndefinedExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGIterationCallExp(@NonNull CGIterationCallExp ic) {
        CGValuedElement source = ic.getSource();
        this.safeVisit(source);
        LoopExp iterationCallExp = (LoopExp)ic.getAst();
        Iteration iter = iterationCallExp.getReferredIteration();
        Type sourceType = source != null ? iterationCallExp.getOwnedSource().getType() : null;
        this.append(PivotUtil.getNavigationOperator((boolean)false, (boolean)PivotUtil.isAggregate((Type)sourceType)));
        this.appendName((NamedElement)iter);
        this.append("(");
        String prefix = "";
        for (CGValuedElement cGValuedElement : ic.getIterators()) {
            this.append(prefix);
            this.safeVisit(cGValuedElement);
            prefix = ", ";
        }
        if (ic instanceof CGLibraryIterateCallExp) {
            this.append("; ");
            this.safeVisit(((CGLibraryIterateCallExp)ic).getResult());
        }
        this.append(" | ");
        this.safeVisit(ic.getBody());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGIterator(@NonNull CGIterator cgElement) {
        CGValuedElement init;
        this.appendName(cgElement);
        CGTypeId type = cgElement.getTypeId();
        if (type != null) {
            this.append(" : ");
            this.appendElementType(cgElement);
        }
        if ((init = cgElement.getInit()) != null) {
            this.append(" = ");
            init.accept(this);
        }
        return null;
    }

    @Override
    public @Nullable String visitCGLetExp(@NonNull CGLetExp cgLetExp) {
        this.append("let ");
        this.safeVisit(cgLetExp.getInit());
        this.append(" in (");
        this.safeVisit(cgLetExp.getIn());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGLibraryOperationCallExp(@NonNull CGLibraryOperationCallExp oc) {
        OperationCallExp operationCallExp = (OperationCallExp)oc.getAst();
        if (operationCallExp == null) {
            LibraryOperation libraryOperation = oc.getLibraryOperation();
            String name = libraryOperation == CollectionExcludingOperation.INSTANCE ? "excluding" : libraryOperation.getClass().getSimpleName();
            CGValuedElement source = oc.getSource();
            this.safeVisit(source);
            this.append(".");
            this.append(name);
            this.append("(");
            String prefix = "";
            for (CGValuedElement argument : oc.getArguments()) {
                this.append(prefix);
                this.safeVisit(argument);
                prefix = ", ";
            }
            this.append(")");
            return null;
        }
        return this.visitCGOperationCallExp(oc);
    }

    @Override
    public @Nullable String visitCGLocalVariable(@NonNull CGLocalVariable cgVariable) {
        CGValuedElement initExpression;
        this.appendName(cgVariable);
        CGTypeId type = cgVariable.getTypeId();
        if (type != null) {
            this.append(" : ");
            this.appendElementType(cgVariable);
        }
        if ((initExpression = cgVariable.getInit()) != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public @Nullable String visitCGMapExp(@NonNull CGMapExp cgMapExp) {
        this.append("Map{");
        boolean isFirst = true;
        for (CGMapPart cgPart : cgMapExp.getParts()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(cgPart);
            isFirst = false;
        }
        this.append("}");
        return null;
    }

    @Override
    public @Nullable String visitCGMapPart(@NonNull CGMapPart cgMapPart) {
        this.safeVisit(cgMapPart.getKey());
        this.append(" <- ");
        this.safeVisit(cgMapPart.getValue());
        return null;
    }

    @Override
    public @Nullable String visitCGModel(@NonNull CGModel cgModel) {
        this.appendName(cgModel);
        return null;
    }

    @Override
    public @Nullable String visitCGOperation(@NonNull CGOperation cgOperation) {
        this.appendQualifiedName(cgOperation.getContainingClass(), ".", cgOperation);
        this.append("(");
        boolean isFirst = true;
        for (CGParameter cgParameter : cgOperation.getParameters()) {
            if (!isFirst) {
                this.append(",");
            }
            this.appendElementType(cgParameter);
            isFirst = false;
        }
        this.append(") : ");
        this.appendElementType(cgOperation);
        return null;
    }

    @Override
    public @Nullable String visitCGOperationCallExp(@NonNull CGOperationCallExp oc) {
        CGValuedElement source = oc.getSource();
        this.safeVisit(source);
        OperationCallExp operationCallExp = (OperationCallExp)oc.getAst();
        Operation oper = operationCallExp.getReferredOperation();
        Type sourceType = operationCallExp.getOwnedSource() != null ? operationCallExp.getOwnedSource().getType() : null;
        this.append(PivotUtil.getNavigationOperator((boolean)false, (boolean)PivotUtil.isAggregate((Type)sourceType)));
        this.appendName((NamedElement)oper);
        this.append("(");
        String prefix = "";
        for (CGValuedElement argument : oc.getArguments()) {
            this.append(prefix);
            this.safeVisit(argument);
            prefix = ", ";
        }
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGOppositePropertyCallExp(@NonNull CGOppositePropertyCallExp pc) {
        CGValuedElement source = pc.getSource();
        this.safeVisit(source);
        OppositePropertyCallExp propertyCallExp = (OppositePropertyCallExp)pc.getAst();
        Property oppositeProperty = propertyCallExp.getReferredProperty();
        Property property = oppositeProperty.getOpposite();
        Type sourceType = source != null ? propertyCallExp.getOwnedSource().getType() : null;
        this.append(PivotUtil.getNavigationOperator((boolean)false, (boolean)PivotUtil.isAggregate((Type)sourceType)));
        this.appendName((NamedElement)property);
        return null;
    }

    @Override
    public @Nullable String visitCGPackage(@NonNull CGPackage cgPackage) {
        this.appendQualifiedName(cgPackage);
        return null;
    }

    @Override
    public @Nullable String visitCGPropertyCallExp(@NonNull CGPropertyCallExp pc) {
        CGValuedElement source = pc.getSource();
        this.safeVisit(source);
        PropertyCallExp propertyCallExp = (PropertyCallExp)pc.getAst();
        if (propertyCallExp != null) {
            Property property = propertyCallExp.getReferredProperty();
            Type sourceType = source != null ? propertyCallExp.getOwnedSource().getType() : null;
            this.append(PivotUtil.getNavigationOperator((boolean)false, (boolean)PivotUtil.isAggregate((Type)sourceType)));
            this.appendName((NamedElement)property);
        } else {
            this.append("\"<.>\"");
            this.appendName((CGNamedElement)null);
        }
        return null;
    }

    @Override
    public @Nullable String visitCGShadowExp(@NonNull CGShadowExp cgShadowExp) {
        this.appendName((NamedElement)((ShadowExp)cgShadowExp.getAst()).getType());
        this.append("{");
        boolean isFirst = true;
        for (CGShadowPart cgPart : cgShadowExp.getParts()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(cgPart);
            isFirst = false;
        }
        this.append("}");
        return null;
    }

    @Override
    public @Nullable String visitCGShadowPart(@NonNull CGShadowPart cgShadowPart) {
        this.appendName((NamedElement)((ShadowPart)cgShadowPart.getAst()).getReferredProperty());
        this.append(" <- ");
        this.safeVisit(cgShadowPart.getInit());
        return null;
    }

    @Override
    public @Nullable String visitCGString(@NonNull CGString cgString) {
        this.append("'");
        this.append(cgString.getStringValue());
        this.append("'");
        return null;
    }

    @Override
    public @Nullable String visitCGThrowExp(@NonNull CGThrowExp cgThrowExp) {
        this.append("$THROW(");
        this.safeVisit(cgThrowExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGTupleExp(@NonNull CGTupleExp cgTupleExp) {
        this.append("Tuple{");
        String prefix = "";
        for (CGTuplePart part : cgTupleExp.getParts()) {
            this.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.append("}");
        return null;
    }

    @Override
    public @Nullable String visitCGTuplePart(@NonNull CGTuplePart cgTuplePart) {
        CGValuedElement initExpression;
        this.appendName(cgTuplePart);
        CGTypeId type = cgTuplePart.getTypeId();
        if (type != null) {
            this.append(" : ");
            this.appendElementType(cgTuplePart);
        }
        if ((initExpression = cgTuplePart.getInit()) != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public @Nullable String visitCGUnboxExp(@NonNull CGUnboxExp cgUnboxExp) {
        this.append("$UNBOX(");
        this.safeVisit(cgUnboxExp.getSource());
        this.append(")");
        return null;
    }

    @Override
    public @Nullable String visitCGValuedElement(@NonNull CGValuedElement cgElement) {
        this.appendName(cgElement);
        return null;
    }

    @Override
    public @Nullable String visitCGVariable(@NonNull CGVariable cgElement) {
        this.appendName(cgElement);
        CGValuedElement init = cgElement.getInit();
        if (init != null) {
            this.append(" = ");
            init.accept(this);
        } else {
            CGTypeId type = cgElement.getTypeId();
            if (type != null) {
                this.append(" : ");
                this.appendElementType(cgElement);
            }
        }
        return null;
    }

    @Override
    public @Nullable String visitCGVariableExp(@NonNull CGVariableExp cgVariableExp) {
        this.appendName(cgVariableExp.getReferredVariable());
        return null;
    }

    @Override
    public @Nullable String visiting(@NonNull CGElement visitable) {
        this.append(visitable.getClass().getName());
        return null;
    }

    protected static abstract class AbstractFactory
    extends AdapterImpl
    implements Factory {
        protected AbstractFactory() {
        }

        public boolean isAdapterForType(Object type) {
            return type == Factory.class;
        }
    }

    public static interface Factory
    extends Adapter {
        public @NonNull CG2StringVisitor createToStringVisitor();

        public @NonNull EPackage getEPackage();
    }

    private static final class MyFactory
    extends AbstractFactory {
        private MyFactory() {
            CG2StringVisitor.addFactory(this);
        }

        @Override
        public @NonNull CG2StringVisitor createToStringVisitor() {
            return new CG2StringVisitor();
        }

        @Override
        public @NonNull EPackage getEPackage() {
            CGModelPackage eInstance = CGModelPackage.eINSTANCE;
            assert (eInstance != null);
            return eInstance;
        }
    }
}

