/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse;

import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.TraceFactory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLSolver;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ISolver;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ModelSpecificEvent;

public class DefaultMSEStateController
implements IMoccmlMSEStateController {
    private Map<ModelSpecificEvent, Boolean> _mseNextStates = new HashMap<ModelSpecificEvent, Boolean>();

    private void applyForcePresence(ICCSLSolver solver, EventOccurrence eventOccurrence) {
        solver.forceEventOccurrence(eventOccurrence);
    }

    private void applyForceAbsence(ICCSLSolver solver, EventOccurrence eventOccurrence) {
        solver.forbidEventOccurrence(eventOccurrence);
    }

    private EventOccurrence createEventoccurence(ModelSpecificEvent mse) {
        EventOccurrence eo = TraceFactory.eINSTANCE.createEventOccurrence();
        ModelElementReference mer = TraceFactory.eINSTANCE.createModelElementReference();
        mer.getElementRef().add((Object)mse.getSolverEvent().eContainer().eContainer());
        mer.getElementRef().add((Object)mse.getSolverEvent().eContainer());
        mer.getElementRef().add((Object)mse.getSolverEvent());
        eo.setReferedElement((Reference)mer);
        return eo;
    }

    public void applyMSEFutureStates(ICCSLSolver solver) {
        for (Map.Entry<ModelSpecificEvent, Boolean> entry : this._mseNextStates.entrySet()) {
            EventOccurrence eo = this.createEventoccurence(entry.getKey());
            if (entry.getValue().booleanValue()) {
                this.applyForcePresence(solver, eo);
                continue;
            }
            this.applyForceAbsence(solver, eo);
        }
    }

    public void forcePresenceInTheFuture(ModelSpecificEvent mse) {
        this.setFutureClockState(mse, true);
    }

    public void forceAbsenceTickInTheFuture(ModelSpecificEvent mse) {
        this.setFutureClockState(mse, false);
    }

    private void setFutureClockState(ModelSpecificEvent mse, Boolean willTick) {
        this._mseNextStates.put(mse, willTick);
    }

    public void freeInTheFuture(ModelSpecificEvent mse) {
        this._mseNextStates.remove(mse);
    }

    public void applyMSEFutureStates(ISolver solver) {
        if (solver instanceof ICCSLSolver) {
            this.applyMSEFutureStates((ICCSLSolver)solver);
        }
    }
}

