/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.ICodeExecutor;

public abstract class AbstractAspectsCodeExecutor
implements ICodeExecutor {
    protected abstract Set<Class<?>> getStaticHelperClasses(Object var1);

    public List<Method> findCompatibleMethodsWithAnnotation(Object caller, List<Object> parameters, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        ArrayList<Object> staticParameters = new ArrayList<Object>();
        staticParameters.add(caller);
        staticParameters.addAll(parameters);
        Set<Class<?>> staticHelperClasses = this.getStaticHelperClasses(caller);
        if (staticHelperClasses == null || staticHelperClasses.isEmpty()) {
            return result;
        }
        for (Class<?> c : staticHelperClasses) {
            result.addAll(this.getApplicableMethodsWithAnnotation(c, staticParameters, annotationClass));
        }
        return result;
    }

    protected List<Method> getApplicableMethodsWithAnnotation(Class<?> staticHelperClass, List<Object> parameters, Class<? extends Annotation> annotationClass) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methodArray = methods = staticHelperClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?>[] evaluatedMethodParamTypes = method.getParameterTypes();
            if (method.isAnnotationPresent(annotationClass) && evaluatedMethodParamTypes.length == parameters.size()) {
                boolean isAllParamCompatible = true;
                int i = 0;
                while (i < evaluatedMethodParamTypes.length) {
                    Object p = parameters.get(i);
                    if (evaluatedMethodParamTypes[i].isPrimitive()) {
                        if (evaluatedMethodParamTypes[i].equals(Integer.TYPE) && !Integer.class.isInstance(p)) {
                            isAllParamCompatible = false;
                            break;
                        }
                        if (evaluatedMethodParamTypes[i].equals(Boolean.TYPE) && !Boolean.class.isInstance(p)) {
                            isAllParamCompatible = false;
                            break;
                        }
                    } else if (!evaluatedMethodParamTypes[i].isInstance(p)) {
                        isAllParamCompatible = false;
                        break;
                    }
                    ++i;
                }
                if (isAllParamCompatible) {
                    result.add(method);
                }
            }
            ++n2;
        }
        Class<?> superClass = staticHelperClass.getSuperclass();
        if (superClass != null) {
            result.addAll(this.getApplicableMethodsWithAnnotation(superClass, parameters, annotationClass));
        }
        return result;
    }
}

