/**
 * generated by Xtext 2.10.0
 */
package org.eclipse.gemoc.ui.contentassist;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.ui.contentassist.AbstractDslProposalProvider;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.LanguageComponentHelper;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class DslProposalProvider extends AbstractDslProposalProvider {
  private final LanguageComponentHelper approachHelper = new LanguageComponentHelper();
  
  private final IConfigurationElement[] metaprogApproach = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.gemoc_language_workbench.metaprog");
  
  @Override
  public void completeEntry_Value(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeEntry_Value(model, assignment, context, acceptor);
    if ((model instanceof Entry)) {
      boolean _equals = "metaprog".equals(((Entry)model).getKey());
      if (_equals) {
        for (final IConfigurationElement approach : this.metaprogApproach) {
          {
            String name = approach.getAttribute("name");
            acceptor.accept(this.createCompletionProposal(name, context));
          }
        }
      }
    }
  }
  
  @Override
  public void complete_SPACE(final EObject model, final RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_SPACE(model, ruleCall, context, acceptor);
    String metaprog = null;
    ArrayList<IConfigurationElement> keys = new ArrayList<IConfigurationElement>();
    ArrayList<String> dslKeys = new ArrayList<String>();
    if ((model instanceof Dsl)) {
      EList<Entry> _entries = ((Dsl)model).getEntries();
      for (final Entry entry : _entries) {
        {
          dslKeys.add(entry.getKey());
          boolean _equals = "metaprog".equals(entry.getKey());
          if (_equals) {
            metaprog = entry.getValue();
          }
        }
      }
      boolean _contains = dslKeys.contains("name");
      boolean _not = (!_contains);
      if (_not) {
        String displayString = "name - name of the DSL";
        acceptor.accept(this.createCompletionProposal("name", displayString, null, context));
      }
      boolean _contains_1 = dslKeys.contains("metaprog");
      boolean _not_1 = (!_contains_1);
      if (_not_1) {
        String displayString_1 = "metaprog - metaprogramming approach used";
        acceptor.accept(this.createCompletionProposal("metaprog", displayString_1, null, context));
      }
      keys = this.approachHelper.getFullApproachKeys(metaprog);
      for (final IConfigurationElement key : keys) {
        {
          String name = key.getAttribute("name");
          String optional = key.getAttribute("optional");
          String displayString_2 = (name + " - ");
          boolean _equals = "true".equals(optional);
          if (_equals) {
            displayString_2 = (displayString_2 + "(optional) ");
          }
          String _attribute = key.getAttribute("description");
          String _plus = (displayString_2 + _attribute);
          displayString_2 = _plus;
          boolean _contains_2 = dslKeys.contains(name);
          boolean _not_2 = (!_contains_2);
          if (_not_2) {
            acceptor.accept(this.createCompletionProposal(name, displayString_2, null, context));
          }
        }
      }
    }
  }
}
