/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecoretools.ale.ide.WorkbenchDsl;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;

public class Helper {
    public static org.eclipse.emf.ecoretools.ale.core.parser.Dsl gemocDslToAleDsl(Dsl language) {
        List<String> ecoreUris = Helper.getEcoreUris(language);
        List<String> aleUris = Helper.getAleUris(language);
        List ecoreFileUris = ecoreUris.stream().map(elem -> URI.createFileURI((String)WorkbenchDsl.convertToFile((String)elem)).toString()).collect(Collectors.toList());
        WorkbenchDsl res = new WorkbenchDsl(new ArrayList(), new ArrayList());
        try {
            res = new WorkbenchDsl(ecoreFileUris, aleUris);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static List<String> validate(Dsl language) {
        ArrayList<String> errors = new ArrayList<String>();
        List<String> ecoreUris = Helper.getEcoreUris(language);
        List<String> aleUris = Helper.getAleUris(language);
        for (String uri : ecoreUris) {
            if (Helper.checkExistURI(uri)) continue;
            errors.add("Can't find: " + uri + " (declared in the language '" + language.getName() + "'");
        }
        for (String uri : aleUris) {
            if (Helper.checkExistURI(uri)) continue;
            errors.add("Can't find: " + uri + " (declared in the language '" + language.getName() + "'");
        }
        return errors;
    }

    public static boolean checkExistURI(String uriString) {
        IResource file;
        URI uri = URI.createURI((String)uriString);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (ws != null && (file = ws.getRoot().findMember(uri.toPlatformString(true))) != null) {
            return true;
        }
        boolean isPresent = false;
        try {
            isPresent = Files.exists(Paths.get(URI.createFileURI((String)WorkbenchDsl.convertToFile((String)uriString)).toString(), new String[0]), new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isPresent;
    }

    public static List<String> getEcoreUris(Dsl language) {
        ArrayList<String> ecoreUris = new ArrayList<String>();
        Optional<Entry> ecoreEntry = language.getEntries().stream().filter(entry -> entry.getKey().equals("ecore")).findFirst();
        if (ecoreEntry.isPresent()) {
            String[] uris;
            String[] stringArray = uris = ecoreEntry.get().getValue().split(",");
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                ecoreUris.add(uri.trim());
                ++n2;
            }
        }
        return ecoreUris;
    }

    public static List<String> getAleUris(Dsl language) {
        ArrayList<String> aleUris = new ArrayList<String>();
        Optional<Entry> aleEntry = language.getEntries().stream().filter(entry -> entry.getKey().equals("ale")).findFirst();
        if (aleEntry.isPresent()) {
            String[] uris;
            String[] stringArray = uris = aleEntry.get().getValue().split(",");
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                aleUris.add(uri.trim());
                ++n2;
            }
        }
        return aleUris;
    }
}

