/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser.visitor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.acceleo.query.ast.AstFactory;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.impl.CollectionTypeLiteralImpl;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.Case;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExpressionStatement;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeaturePut;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationFactory;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.Switch;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class ModelBuilder {
    public static ModelBuilder singleton;
    public static final String PARSER_SOURCE = "http://org/eclipse/emf/ecoretools/ale/parser/metadata";
    public static final String PARSER_EXTENDS_KEY = "extends";
    public static final String PARSER_OPPOSITE_KEY = "opposite";
    public static final String RUNTIME_ALE_NSURI = "http://ale/runtime/";
    public static final String PARSER_ID = "org.eclipse.emf.ecoretools.ale";
    IQueryEnvironment qryEnv;
    QueryBuilderEngine builder;
    QueryEvaluationEngine aqlEngine;
    ImplementationFactory implemFactory;
    EcoreFactory ecoreFactory;
    AstFactory aqlFactory;

    public static ModelBuilder createSingleton(IQueryEnvironment qryEnv) {
        singleton = new ModelBuilder(qryEnv);
        return singleton;
    }

    public ModelBuilder(IQueryEnvironment qryEnv) {
        this.qryEnv = qryEnv;
        this.builder = new QueryBuilderEngine((IReadOnlyQueryEnvironment)qryEnv);
        this.aqlEngine = new QueryEvaluationEngine(qryEnv);
        this.ecoreFactory = (EcoreFactory)((EPackage)qryEnv.getEPackageProvider().getEPackage("ecore").iterator().next()).getEFactoryInstance();
        this.implemFactory = (ImplementationFactory)((EPackage)qryEnv.getEPackageProvider().getEPackage("implementation").iterator().next()).getEFactoryInstance();
        this.aqlFactory = (AstFactory)((EPackage)qryEnv.getEPackageProvider().getEPackage("ast").iterator().next()).getEFactoryInstance();
    }

    public Method buildMethod(EClass fragment, String name, List<Parameter> params, ALEParser.RTypeContext returnType, Block body, List<String> tags) {
        EOperation operation = this.ecoreFactory.createEOperation();
        operation.setName(name);
        params.stream().forEach(p -> {
            EParameter opParam = this.ecoreFactory.createEParameter();
            opParam.setName(p.getName());
            opParam.setEType(p.getType());
            operation.getEParameters().add((Object)opParam);
        });
        EClassifier type = this.resolve(returnType);
        operation.setEType(type);
        fragment.getEOperations().add((Object)operation);
        return this.buildMethod(operation, body, tags);
    }

    public Method buildMethod(EOperation operation, Block body, List<String> tags) {
        Method newMethod = this.implemFactory.createMethod();
        newMethod.setOperationRef(operation);
        newMethod.setBody(body);
        newMethod.getTags().addAll(tags);
        return newMethod;
    }

    public Method buildImplementation(String containingClass, String name, List<Parameter> params, ALEParser.RTypeContext returnType, Block body, List<String> tags) {
        Optional<EOperation> existingOperation = this.resolve(containingClass, name, params.size(), returnType);
        if (!existingOperation.isPresent()) {
            return this.buildMethod(null, body, tags);
        }
        return this.buildMethod(existingOperation.get(), body, tags);
    }

    public Parameter buildParameter(ALEParser.RTypeContext type, String name) {
        return new Parameter(name, this.resolve(type));
    }

    public Attribute buildAttribute(EClass fragment, String name, ALEParser.RExpressionContext exp, ALEParser.RTypeContext type, int lowerBound, int upperBound, boolean isContainment, boolean isUnique, String opposite, ParseResult<ModelUnit> parseRes) {
        EReference feature;
        Attribute attribute = this.implemFactory.createAttribute();
        EClassifier featureType = this.resolve(type);
        if (featureType instanceof EClass) {
            feature = this.ecoreFactory.createEReference();
            feature.setContainment(isContainment);
        } else {
            feature = this.ecoreFactory.createEAttribute();
        }
        feature.setName(name);
        feature.setEType(featureType);
        attribute.setFeatureRef((EStructuralFeature)feature);
        if (exp != null) {
            attribute.setInitialValue(this.parseExp(exp, parseRes));
        }
        if (opposite != null) {
            EAnnotation annot = this.ecoreFactory.createEAnnotation();
            annot.setSource(PARSER_SOURCE);
            annot.getDetails().put((Object)PARSER_OPPOSITE_KEY, (Object)opposite);
            attribute.getEAnnotations().add((Object)annot);
        }
        fragment.getEStructuralFeatures().add((Object)feature);
        feature.setLowerBound(lowerBound);
        feature.setUpperBound(upperBound);
        feature.setUnique(isUnique);
        return attribute;
    }

    public VariableDeclaration buildVariableDecl(String name, ALEParser.RExpressionContext exp, ALEParser.RTypeContext type, ParseResult<ModelUnit> parseRes) {
        VariableDeclaration varDecl = this.implemFactory.createVariableDeclaration();
        varDecl.setName(name);
        if (exp != null) {
            varDecl.setInitialValue(this.parseExp(exp, parseRes));
        }
        EClassifier declaredType = this.resolve(type);
        varDecl.setType(declaredType);
        if (declaredType == EcorePackage.eINSTANCE.getEEList()) {
            EClassifier parameterType = this.resolveParameterType(type);
            varDecl.setTypeParameter(parameterType);
        }
        return varDecl;
    }

    public VariableAssignment buildVariableAssignement(String name, ALEParser.RExpressionContext exp, ParseResult<ModelUnit> parseRes) {
        VariableAssignment varAssign = this.implemFactory.createVariableAssignment();
        varAssign.setName(name);
        varAssign.setValue(this.parseExp(exp, parseRes));
        return varAssign;
    }

    public If buildIf(List<ConditionalBlock> cBlocks, Block elseBlock, ParseResult<ModelUnit> parseRes) {
        If ifStmt = this.implemFactory.createIf();
        ifStmt.getBlocks().addAll(cBlocks);
        ifStmt.setElse(elseBlock);
        return ifStmt;
    }

    public ConditionalBlock buildConditionalBlock(ALEParser.RExpressionContext condition, Block block, ParseResult<ModelUnit> parseRes) {
        ConditionalBlock cBlock = this.implemFactory.createConditionalBlock();
        cBlock.setCondition(this.parseExp(condition, parseRes));
        cBlock.setBlock(block);
        return cBlock;
    }

    public Block buildBlock(List<Statement> statements) {
        Block block = this.implemFactory.createBlock();
        block.getStatements().addAll(statements);
        return block;
    }

    public ExpressionStatement buildExpressionStatement(ALEParser.RExpressionContext value, ParseResult<ModelUnit> parseRes) {
        ExpressionStatement exp = this.implemFactory.createExpressionStatement();
        exp.setExpression(this.parseExp(value, parseRes));
        return exp;
    }

    public ForEach buildForEach(String variable, ALEParser.RExpressionContext expression, Block body, ParseResult<ModelUnit> parseRes) {
        ForEach loop = this.implemFactory.createForEach();
        loop.setVariable(variable);
        loop.setCollectionExpression(this.parseExp(expression, parseRes));
        loop.setBody(body);
        return loop;
    }

    public ForEach buildForEach(String variable, SequenceInExtensionLiteral expression, Block body) {
        ForEach loop = this.implemFactory.createForEach();
        loop.setVariable(variable);
        loop.setCollectionExpression((Expression)expression);
        loop.setBody(body);
        return loop;
    }

    public While buildWhile(ALEParser.RExpressionContext expression, Block body, ParseResult<ModelUnit> parseRes) {
        While loop = this.implemFactory.createWhile();
        loop.setCondition(this.parseExp(expression, parseRes));
        loop.setBody(body);
        return loop;
    }

    public VariableInsert buildVariableInsert(String name, ALEParser.RExpressionContext exp, ParseResult<ModelUnit> parseRes) {
        VariableInsert varInsert = this.implemFactory.createVariableInsert();
        varInsert.setName(name);
        varInsert.setValue(this.parseExp(exp, parseRes));
        return varInsert;
    }

    public VariableRemove buildVariableRemove(String name, ALEParser.RExpressionContext exp, ParseResult<ModelUnit> parseRes) {
        VariableRemove varRemove = this.implemFactory.createVariableRemove();
        varRemove.setName(name);
        varRemove.setValue(this.parseExp(exp, parseRes));
        return varRemove;
    }

    public FeatureAssignment buildFeatureAssign(ALEParser.ExpressionContext target, String feature, ALEParser.RExpressionContext valueExp, ParseResult<ModelUnit> parseRes) {
        FeatureAssignment featSetting = this.implemFactory.createFeatureAssignment();
        featSetting.setTarget(this.parseAQL(target, parseRes));
        featSetting.setTargetFeature(feature);
        featSetting.setValue(this.parseExp(valueExp, parseRes));
        return featSetting;
    }

    public FeatureInsert buildFeatureInsert(ALEParser.ExpressionContext target, String feature, ALEParser.ExpressionContext valueExp, ParseResult<ModelUnit> parseRes) {
        FeatureInsert featSetting = this.implemFactory.createFeatureInsert();
        featSetting.setTarget(this.parseAQL(target, parseRes));
        featSetting.setTargetFeature(feature);
        featSetting.setValue(this.parseAQL(valueExp, parseRes));
        return featSetting;
    }

    public FeatureRemove buildFeatureRemove(ALEParser.ExpressionContext target, String feature, ALEParser.ExpressionContext valueExp, ParseResult<ModelUnit> parseRes) {
        FeatureRemove featSetting = this.implemFactory.createFeatureRemove();
        featSetting.setTarget(this.parseAQL(target, parseRes));
        featSetting.setTargetFeature(feature);
        featSetting.setValue(this.parseAQL(valueExp, parseRes));
        return featSetting;
    }

    public FeaturePut buildFeaturePut(ALEParser.ExpressionContext target, String feature, ALEParser.ExpressionContext keyExp, ALEParser.ExpressionContext valueExp, ParseResult<ModelUnit> parseRes) {
        FeaturePut featSetting = this.implemFactory.createFeaturePut();
        featSetting.setTarget(this.parseAQL(target, parseRes));
        featSetting.setTargetFeature(feature);
        featSetting.setKey(this.parseAQL(keyExp, parseRes));
        featSetting.setValue(this.parseAQL(valueExp, parseRes));
        return featSetting;
    }

    public ExtendedClass buildExtendedClass(String baseCls, List<Attribute> attributes, List<Method> operations, List<String> extendedCls) {
        ExtendedClass cls = this.implemFactory.createExtendedClass();
        EClassifier resolvedType = this.resolve(baseCls);
        if (resolvedType instanceof EClass) {
            cls.setBaseClass((EClass)resolvedType);
        }
        cls.getMethods().addAll(operations);
        cls.getAttributes().addAll(attributes);
        cls.setName(baseCls);
        extendedCls.stream().forEach(xtd -> {
            EAnnotation annot = this.ecoreFactory.createEAnnotation();
            annot.setSource(PARSER_SOURCE);
            annot.getDetails().put((Object)PARSER_EXTENDS_KEY, xtd);
            cls.getEAnnotations().add((Object)annot);
        });
        return cls;
    }

    public RuntimeClass buildRuntimeClass(String name, List<Attribute> attributes, List<Method> operations) {
        RuntimeClass cls = this.implemFactory.createRuntimeClass();
        cls.setName(name);
        cls.getMethods().addAll(operations);
        cls.getAttributes().addAll(attributes);
        return cls;
    }

    public SequenceInExtensionLiteral buildIntSequence(String left, String right) {
        SequenceInExtensionLiteral seq = this.aqlFactory.createSequenceInExtensionLiteral();
        try {
            int min = Integer.parseInt(left);
            int max = Integer.parseInt(right);
            if (min <= max) {
                int i = min;
                while (i <= max) {
                    IntegerLiteral item = this.aqlFactory.createIntegerLiteral();
                    item.setValue(i);
                    seq.getValues().add((Object)item);
                    ++i;
                }
            } else {
                int i = min;
                while (i >= max) {
                    IntegerLiteral item = this.aqlFactory.createIntegerLiteral();
                    item.setValue(i);
                    seq.getValues().add((Object)item);
                    --i;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return seq;
    }

    public EPackage buildEPackage(String qualifiedName) {
        EClass ePkgClass = EcorePackage.eINSTANCE.getEPackage();
        EPackage newPkg = (EPackage)EcoreUtil.create((EClass)ePkgClass);
        String[] segments = qualifiedName.split("\\.");
        newPkg.setName(segments[0]);
        newPkg.setNsPrefix(segments[0]);
        newPkg.setNsURI(RUNTIME_ALE_NSURI + segments[0]);
        int i = 1;
        EPackage parent = newPkg;
        while (i < segments.length) {
            String segment = segments[i];
            EPackage subPkg = (EPackage)EcoreUtil.create((EClass)ePkgClass);
            subPkg.setName(segment);
            parent.getESubpackages().add((Object)subPkg);
            subPkg.setNsPrefix(segment);
            subPkg.setNsURI(String.valueOf(parent.getNsURI()) + "/" + segment);
            parent = subPkg;
            ++i;
        }
        return parent;
    }

    public EClass buildEClass(String name) {
        EClass eClsClass = EcorePackage.eINSTANCE.getEClass();
        EClass cls = (EClass)EcoreUtil.create((EClass)eClsClass);
        cls.setName(name);
        return cls;
    }

    public void updateEClass(EClass cls, RuntimeClass clsDef) {
        EClass eRefClass = EcorePackage.eINSTANCE.getEReference();
        EClass eAttClass = EcorePackage.eINSTANCE.getEAttribute();
        clsDef.getAttributes().stream().forEach(attr -> {
            String name = attr.getFeatureRef().getName();
            EStructuralFeature featureCopy = (EStructuralFeature)EcoreUtil.copy((EObject)attr.getFeatureRef());
            cls.getEStructuralFeatures().add((Object)featureCopy);
            attr.setFeatureRef(featureCopy);
        });
        clsDef.getMethods().stream().forEach(mtd -> {
            if (mtd.getOperationRef() != null) {
                EOperation newOp = (EOperation)EcoreUtil.copy((EObject)mtd.getOperationRef());
                cls.getEOperations().add((Object)newOp);
                mtd.setOperationRef(newOp);
            }
        });
    }

    public Optional<EOperation> resolve(String className, String methodName, int nbArgs, ALEParser.RTypeContext returnType) {
        EClassifier type = this.resolve(returnType);
        Optional<EOperation> eOperation = this.qryEnv.getEPackageProvider().getEClassifiers().stream().filter(cls -> cls instanceof EClass).filter(cls -> cls.getName().equals(className)).flatMap(cls -> ((EClass)cls).getEOperations().stream()).filter(op -> op.getName().equals(methodName) && op.getEParameters().size() == nbArgs && op.getEType() == type).findFirst();
        return eOperation;
    }

    public EClassifier resolve(String typeName) {
        Optional<EClassifier> candidate;
        String className = typeName.replaceAll("::", ".");
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex != -1 && lastDotIndex < className.length()) {
            String simpleName = className.substring(lastDotIndex + 1);
            Collection clsCandidates = this.qryEnv.getEPackageProvider().getTypes(simpleName);
            Optional<EClassifier> foundCls = clsCandidates.stream().filter(c -> ModelBuilder.getQualifiedName(c).equals(className)).findFirst();
            if (foundCls.isPresent()) {
                return foundCls.get();
            }
        }
        if ((candidate = this.qryEnv.getEPackageProvider().getEClassifiers().stream().filter(cls -> !cls.getEPackage().getName().equals("implementation")).filter(cls -> cls.getName().equals(className)).findFirst()).isPresent()) {
            return candidate.get();
        }
        switch (className) {
            case "String": {
                return EcorePackage.eINSTANCE.getEString();
            }
            case "boolean": {
                return EcorePackage.eINSTANCE.getEBoolean();
            }
            case "byte": {
                return EcorePackage.eINSTANCE.getEByte();
            }
            case "char": {
                return EcorePackage.eINSTANCE.getEChar();
            }
            case "short": {
                return EcorePackage.eINSTANCE.getEShort();
            }
            case "int": {
                return EcorePackage.eINSTANCE.getEInt();
            }
            case "long": {
                return EcorePackage.eINSTANCE.getELong();
            }
            case "float": {
                return EcorePackage.eINSTANCE.getEFloat();
            }
            case "double": {
                return EcorePackage.eINSTANCE.getEDouble();
            }
            case "void": {
                return null;
            }
        }
        return ImplementationPackage.eINSTANCE.getUnresolvedEClassifier();
    }

    public EClassifier resolve(ALEParser.RTypeContext type) {
        ALEParser.TypeLiteralContext typeLit = type.typeLiteral();
        if (typeLit != null) {
            IQueryBuilderEngine.AstResult astResult = this.builder.build(type.getText());
            EvaluationResult evaluationResult = this.aqlEngine.eval(astResult, (Map)Maps.newHashMap());
            Object result = evaluationResult.getResult();
            if (result == String.class) {
                return EcorePackage.eINSTANCE.getEString();
            }
            if (result == Integer.class) {
                return EcorePackage.eINSTANCE.getEInt();
            }
            if (result == Double.class) {
                return EcorePackage.eINSTANCE.getEDouble();
            }
            if (result == Boolean.class) {
                return EcorePackage.eINSTANCE.getEBoolean();
            }
            if (result == List.class) {
                return EcorePackage.eINSTANCE.getEEList();
            }
            if (result == Set.class) {
                return EcorePackage.eINSTANCE.getEEList();
            }
            if (result instanceof EClassifier) {
                return (EClassifier)result;
            }
        }
        return this.resolve(type.getText());
    }

    public EClassifier resolveParameterType(ALEParser.RTypeContext type) {
        IQueryBuilderEngine.AstResult astResult = this.builder.build(type.getText());
        if (astResult.getAst() instanceof CollectionTypeLiteralImpl) {
            CollectionTypeLiteralImpl collectionType = (CollectionTypeLiteralImpl)astResult.getAst();
            TypeLiteral paramTypeLiteral = collectionType.getElementType();
            Object paramType = paramTypeLiteral.getValue();
            if (paramType == String.class) {
                return EcorePackage.eINSTANCE.getEString();
            }
            if (paramType == Integer.class) {
                return EcorePackage.eINSTANCE.getEInt();
            }
            if (paramType == Double.class) {
                return EcorePackage.eINSTANCE.getEDouble();
            }
            if (paramType == Boolean.class) {
                return EcorePackage.eINSTANCE.getEBoolean();
            }
            if (paramType == List.class) {
                return EcorePackage.eINSTANCE.getEEList();
            }
            if (paramType == Set.class) {
                return EcorePackage.eINSTANCE.getEEList();
            }
            if (paramType instanceof EClassifier) {
                return (EClassifier)paramType;
            }
        }
        return null;
    }

    public static String getQualifiedName(EClassifier cls) {
        ArrayList<String> fullName = new ArrayList<String>();
        fullName.add(cls.getName());
        EPackage current = cls.getEPackage();
        fullName.add(current.getName());
        while (current.getESuperPackage() != null) {
            current = current.getESuperPackage();
            fullName.add(current.getName());
        }
        return String.join((CharSequence)".", Lists.reverse(fullName));
    }

    public Expression parseExp(ALEParser.RExpressionContext ctx, ParseResult<ModelUnit> parseRes) {
        if (ctx.rSwitch() != null) {
            return this.parseSwitch(ctx.rSwitch(), parseRes);
        }
        return this.parseAQL(ctx.expression(), parseRes);
    }

    public Expression parseSwitch(ALEParser.RSwitchContext ctx, ParseResult<ModelUnit> parseRes) {
        Switch switchExp = this.implemFactory.createSwitch();
        ALEParser.RExpressionContext paramVal = ctx.paramVal;
        List<ALEParser.RCaseContext> cases = ctx.cases;
        ALEParser.RExpressionContext defaultExp = ctx.other;
        switchExp.setParam(this.parseExp(paramVal, parseRes));
        switchExp.setDefault(this.parseExp(defaultExp, parseRes));
        cases.forEach(caseCtx -> {
            Case newCase = this.implemFactory.createCase();
            if (caseCtx.guard != null) {
                newCase.setGuard(this.resolve(caseCtx.guard));
            }
            if (caseCtx.match != null) {
                newCase.setMatch(this.parseExp(caseCtx.match, parseRes));
            }
            newCase.setValue(this.parseExp(caseCtx.value, parseRes));
            switchExp.getCases().add((Object)newCase);
        });
        if (ctx.paramName != null) {
            String paramName = ctx.paramName.getText();
            Let let = this.aqlFactory.createLet();
            Binding binding = this.aqlFactory.createBinding();
            binding.setName(paramName);
            binding.setValue(switchExp.getParam());
            let.getBindings().add((Object)binding);
            let.setBody((Expression)switchExp);
            IQueryBuilderEngine.AstResult astRes = this.builder.build(paramName);
            Expression param = astRes.getAst();
            switchExp.setParam(param);
            return let;
        }
        return switchExp;
    }

    public Expression parseAQL(ALEParser.ExpressionContext ctx, ParseResult<ModelUnit> parseRes) {
        String text = ModelBuilder.safeGetText(ctx);
        IQueryBuilderEngine.AstResult astRes = this.builder.build(text);
        Expression res = astRes.getAst();
        parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
        parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
        int startOffset = ctx.start.getStartIndex();
        TreeIterator allSubExp = res.eAllContents();
        allSubExp.forEachRemaining(subExp -> {
            if (subExp instanceof Expression) {
                int relativeStart = astRes.getStartPosition((Expression)subExp);
                int relativeEnd = astRes.getEndPosition((Expression)subExp);
                if (relativeStart != -1 && relativeEnd != -1) {
                    parseRes.getStartPositions().put(subExp, relativeStart + startOffset);
                    parseRes.getEndPositions().put(subExp, relativeEnd + startOffset);
                }
            }
        });
        return res;
    }

    public static String safeGetText(ALEParser.ExpressionContext exp) {
        Interval interval = new Interval(exp.start.getStartIndex(), exp.stop.getStopIndex());
        return exp.start.getInputStream().getText(interval);
    }

    public static class Parameter {
        String name;
        EClassifier type;

        public Parameter(String name, EClassifier type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public EClassifier getType() {
            return this.type;
        }
    }
}

