/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.ale.core.parser.ALELexer;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.AstVisitors;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ModelBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;

public class AstBuilder {
    IQueryEnvironment qryEnv;

    public AstBuilder(IQueryEnvironment qryEnv) {
        this.qryEnv = qryEnv;
        ModelBuilder.createSingleton(qryEnv);
    }

    public List<ParseResult<ModelUnit>> parseFromInputStreams(List<InputStream> inputs) {
        ArrayList<ALEParser.RRootContext> parses = new ArrayList<ALEParser.RRootContext>();
        inputs.stream().forEach(f -> {
            try {
                ALEParser.RRootContext parseRes = this.doParse((InputStream)f);
                parses.add(parseRes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return this.makeModel(parses, new HashMap<ALEParser.RRootContext, String>());
    }

    public List<ParseResult<ModelUnit>> parseFromFiles(List<String> files) {
        ArrayList<ALEParser.RRootContext> parses = new ArrayList<ALEParser.RRootContext>();
        HashMap<ALEParser.RRootContext, String> sourceFiles = new HashMap<ALEParser.RRootContext, String>();
        files.stream().forEach(f -> {
            try {
                ALEParser.RRootContext parseRes = this.doParse((String)f);
                parses.add(parseRes);
                sourceFiles.put(parseRes, (String)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return this.makeModel(parses, sourceFiles);
    }

    private List<ParseResult<ModelUnit>> makeModel(List<ALEParser.RRootContext> rawParses, Map<ALEParser.RRootContext, String> sourceFiles) {
        ArrayList<ParseResult<ModelUnit>> build = new ArrayList<ParseResult<ModelUnit>>();
        HashMap allNewClasses = new HashMap();
        rawParses.stream().forEach(implemParse -> {
            List<EClass> newOnes = AstVisitors.preVisit(implemParse);
            EPackage candidatePkg = null;
            Collection pkgs = this.qryEnv.getEPackageProvider().getEPackage(implemParse.rQualified().getText());
            candidatePkg = pkgs != null && !pkgs.isEmpty() ? (EPackage)pkgs.iterator().next() : ModelBuilder.singleton.buildEPackage(implemParse.rQualified().getText());
            candidatePkg.getEClassifiers().addAll(newOnes);
            allNewClasses.put(implemParse.rQualified().getText(), newOnes);
            EPackage topPkg = candidatePkg;
            while (topPkg.getESuperPackage() != null) {
                topPkg = topPkg.getESuperPackage();
            }
            this.qryEnv.registerEPackage(topPkg);
        });
        rawParses.stream().forEach(p -> {
            ParseResult<ModelUnit> parseRes = AstVisitors.visit(p);
            parseRes.setSourceFile((String)sourceFiles.get(p));
            build.add(parseRes);
        });
        build.stream().map(m -> (ModelUnit)m.getRoot()).filter(m -> m != null).forEach(implemModel -> {
            List newClasses = (List)allNewClasses.get(implemModel.getName());
            if (newClasses != null) {
                implemModel.getClassDefinitions().stream().forEach(clsDef -> {
                    Optional<EClass> cls = newClasses.stream().filter(c -> c.getName().equals(clsDef.getName())).findFirst();
                    if (cls.isPresent()) {
                        ModelBuilder.singleton.updateEClass(cls.get(), (RuntimeClass)clsDef);
                    }
                });
            }
        });
        HashMap behaviorToClass = new HashMap();
        ArrayList allExtensions = new ArrayList();
        build.stream().forEach(sem -> {
            ModelUnit root = (ModelUnit)sem.getRoot();
            if (root != null) {
                List xtdCls = root.getClassExtensions().stream().collect(Collectors.toList());
                behaviorToClass.put(root.getName(), xtdCls);
                allExtensions.addAll(xtdCls);
            }
        });
        allExtensions.stream().forEach(cls -> {
            List toResolve = cls.getEAnnotations().stream().filter(a -> a.getSource().equals("http://org/eclipse/emf/ecoretools/ale/parser/metadata")).filter(a -> a.getDetails().get((Object)"extends") != null).collect(Collectors.toList());
            toResolve.stream().forEach(annot -> {
                Optional<ExtendedClass> searchRes;
                int lastDot;
                String xtd = (String)annot.getDetails().get((Object)"extends");
                String qualifying = ((ModelUnit)cls.eContainer()).getName();
                String name = xtd;
                if (AstVisitors.isQualified(xtd) && (lastDot = xtd.lastIndexOf(".")) < xtd.length()) {
                    qualifying = xtd.substring(0, lastDot);
                    name = xtd.substring(lastDot + 1);
                }
                String finalName = name;
                List candidates = (List)behaviorToClass.get(qualifying);
                if (candidates != null && (searchRes = candidates.stream().filter(c -> c.getBaseClass().getName().equals(finalName)).findFirst()).isPresent()) {
                    cls.getExtends().add((Object)searchRes.get());
                    cls.getEAnnotations().remove(annot);
                }
            });
        });
        ArrayList allAttributes = new ArrayList();
        build.stream().forEach(sem -> {
            ModelUnit root = (ModelUnit)sem.getRoot();
            if (root != null) {
                root.getClassExtensions().stream().forEach(cls -> allAttributes.addAll(cls.getAttributes()));
                root.getClassDefinitions().stream().forEach(cls -> allAttributes.addAll(cls.getAttributes()));
            }
        });
        allAttributes.stream().filter(attr -> attr.getEAnnotation("http://org/eclipse/emf/ecoretools/ale/parser/metadata") != null).forEach(attr -> {
            EAnnotation annot = attr.getEAnnotation("http://org/eclipse/emf/ecoretools/ale/parser/metadata");
            String opposite = (String)annot.getDetails().get((Object)"opposite");
            EClassifier oppositeType = attr.getFeatureRef().getEType();
            if (oppositeType instanceof EClass) {
                Optional<Attribute> candidate;
                EClass oppositeClass = (EClass)oppositeType;
                EStructuralFeature oppositeFeature = oppositeClass.getEStructuralFeature(opposite);
                if (oppositeFeature == null && (candidate = allExtensions.stream().filter(xtd -> xtd.getBaseClass() == oppositeType).flatMap(xtd -> xtd.getAttributes().stream()).filter(a -> a.getFeatureRef().getName().equals(opposite)).findFirst()).isPresent()) {
                    oppositeFeature = candidate.get().getFeatureRef();
                }
                if (oppositeFeature instanceof EReference) {
                    ((EReference)attr.getFeatureRef()).setEOpposite((EReference)oppositeFeature);
                    attr.getEAnnotations().remove((Object)annot);
                }
            }
        });
        return build;
    }

    private ALEParser.RRootContext doParse(InputStream fileContent) throws IOException {
        ANTLRInputStream input = new ANTLRInputStream(fileContent);
        ALELexer lexer = new ALELexer((CharStream)input);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ALEParser parser = new ALEParser((TokenStream)tokens);
        return parser.rRoot();
    }

    private ALEParser.RRootContext doParse(String fileName) throws IOException {
        ANTLRFileStream input = new ANTLRFileStream(fileName);
        ALELexer lexer = new ALELexer((CharStream)input);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ALEParser parser = new ALEParser((TokenStream)tokens);
        return parser.rRoot();
    }

    public ParseResult<ModelUnit> parse(String fileName) throws IOException {
        ANTLRFileStream input = new ANTLRFileStream(fileName);
        ALELexer lexer = new ALELexer((CharStream)input);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ALEParser parser = new ALEParser((TokenStream)tokens);
        ALEParser.RRootContext rootCtx = parser.rRoot();
        return AstVisitors.visit(rootCtx);
    }

    public ParseResult<ModelUnit> parseFromFile(String filePath) throws IOException {
        ParseResult<ModelUnit> parseRes = this.parse(filePath);
        parseRes.setSourceFile(filePath);
        return parseRes;
    }
}

