/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.markerImpl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.resources.VisualiserImages;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.markerImpl.MarkerMarkupProvider;
import org.eclipse.contribution.visualiser.markerImpl.ResourceMember;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleContentProvider;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleGroup;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class ResourceContentProvider
extends SimpleContentProvider
implements ISelectionListener {
    IResource selectedResource;
    private boolean updateNeeded;

    public void initialise() {
        if (VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
            VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        }
    }

    public List getAllMembers() {
        if (this.updateNeeded) {
            this.updateData();
            IMarkupProvider mProv = ProviderManager.getMarkupProvider();
            if (mProv instanceof MarkerMarkupProvider) {
                ((MarkerMarkupProvider)mProv).updateMarkups(super.getAllGroups());
            }
        }
        return super.getAllMembers();
    }

    public List getAllGroups() {
        if (this.updateNeeded) {
            this.updateData();
            IMarkupProvider mProv = ProviderManager.getMarkupProvider();
            if (mProv instanceof MarkerMarkupProvider) {
                ((MarkerMarkupProvider)mProv).updateMarkups(super.getAllGroups());
            }
        }
        return super.getAllGroups();
    }

    public List getAllMembers(IGroup group) {
        if (this.updateNeeded) {
            this.updateData();
            IMarkupProvider mProv = ProviderManager.getMarkupProvider();
            if (mProv instanceof MarkerMarkupProvider) {
                ((MarkerMarkupProvider)mProv).updateMarkups(super.getAllGroups());
            }
        }
        return super.getAllMembers(group);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object o;
        if (!ProviderManager.getContentProvider().equals(this)) {
            return;
        }
        boolean updateRequired = false;
        if (selection instanceof IStructuredSelection && (o = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
            if (o instanceof IResource) {
                IResource r = (IResource)o;
                if (this.selectedResource != r) {
                    this.selectedResource = r;
                    updateRequired = true;
                }
            } else if (o instanceof IJavaElement) {
                try {
                    IResource r = ((IJavaElement)o).getCorrespondingResource();
                    if (this.selectedResource != r) {
                        this.selectedResource = r;
                        updateRequired = true;
                    }
                }
                catch (JavaModelException jme) {
                    jme.printStackTrace();
                }
            }
        }
        if (updateRequired && this.selectedResource != null) {
            this.updateNeeded = true;
            VisualiserPlugin.refresh();
        }
    }

    private void updateData() {
        if (this.selectedResource instanceof IContainer) {
            this.resetModel();
            try {
                IResource[] children = ((IContainer)this.selectedResource).members();
                boolean membersAreContainers = false;
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IContainer) {
                        membersAreContainers = true;
                    }
                    ++i;
                }
                if (!membersAreContainers) {
                    SimpleGroup group = new SimpleGroup(this.selectedResource.getName());
                    int i2 = 0;
                    while (i2 < children.length) {
                        IResource resource = children[i2];
                        this.createNewMember(group, resource);
                        ++i2;
                    }
                    this.addGroup(group);
                } else {
                    i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IContainer) {
                            SimpleGroup group = new SimpleGroup(children[i].getName());
                            this.addChildrenRecursively(group, (IContainer)children[i]);
                            this.addGroup(group);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (this.selectedResource instanceof IFile) {
            try {
                this.resetModel();
                SimpleGroup group = new SimpleGroup(this.selectedResource.getParent().getName());
                this.createNewMember(group, this.selectedResource);
                this.addGroup(group);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        this.updateNeeded = false;
    }

    private void addChildrenRecursively(IGroup group, IContainer container) {
        try {
            IResource[] children = container.members();
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile) {
                    this.createNewMember(group, resource);
                } else if (resource instanceof IContainer) {
                    this.addChildrenRecursively(group, (IContainer)resource);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createNewMember(IGroup group, IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            int length = 0;
            ResourceMember member = new ResourceMember(resource.getName(), resource);
            BufferedReader in = new BufferedReader(new InputStreamReader(((IFile)resource).getContents()));
            try {
                while (in.readLine() != null) {
                    ++length;
                }
                member.setSize(length);
                group.add(member);
                in.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean processMouseclick(IMember member, boolean markupWasClicked, int buttonClicked) {
        if (buttonClicked == 1 && !markupWasClicked && member instanceof ResourceMember) {
            JDTUtils.openInEditor(((ResourceMember)member).getResource(), 0);
            return false;
        }
        return true;
    }

    public ImageDescriptor getMemberViewIcon() {
        return VisualiserImages.FILE_VIEW;
    }

    public ImageDescriptor getGroupViewIcon() {
        return VisualiserImages.FOLDER_VIEW;
    }
}

