/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.aspectj.internal.lang.reflect.PointcutExpressionImpl;
import org.aspectj.lang.annotation.AdviceName;
import org.aspectj.lang.reflect.Advice;
import org.aspectj.lang.reflect.AdviceKind;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PointcutExpression;

public class AdviceImpl
implements Advice {
    private static final String AJC_INTERNAL = "org.aspectj.runtime.internal";
    private final AdviceKind kind;
    private final Method adviceMethod;
    private PointcutExpression pointcutExpression;
    private boolean hasExtraParam = false;
    private Type[] genericParameterTypes;
    private AjType[] parameterTypes;
    private AjType[] exceptionTypes;

    protected AdviceImpl(Method method, String pointcut, AdviceKind type) {
        this.kind = type;
        this.adviceMethod = method;
        this.pointcutExpression = new PointcutExpressionImpl(pointcut);
    }

    protected AdviceImpl(Method method, String pointcut, AdviceKind type, String extraParamName) {
        this(method, pointcut, type);
        this.hasExtraParam = true;
    }

    @Override
    public AjType getDeclaringType() {
        return AjTypeSystem.getAjType(this.adviceMethod.getDeclaringClass());
    }

    @Override
    public Type[] getGenericParameterTypes() {
        if (this.genericParameterTypes == null) {
            Type[] genTypes = this.adviceMethod.getGenericParameterTypes();
            int syntheticCount = 0;
            Type[] typeArray = genTypes;
            int n = genTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                if (t instanceof Class && ((Class)t).getPackage().getName().equals(AJC_INTERNAL)) {
                    ++syntheticCount;
                }
                ++n2;
            }
            this.genericParameterTypes = new Type[genTypes.length - syntheticCount];
            int i = 0;
            while (i < this.genericParameterTypes.length) {
                this.genericParameterTypes[i] = genTypes[i] instanceof Class ? AjTypeSystem.getAjType((Class)genTypes[i]) : genTypes[i];
                ++i;
            }
        }
        return this.genericParameterTypes;
    }

    @Override
    public AjType<?>[] getParameterTypes() {
        if (this.parameterTypes == null) {
            Class<?>[] ptypes = this.adviceMethod.getParameterTypes();
            int syntheticCount = 0;
            Class<?>[] classArray = ptypes;
            int n = ptypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                if (c.getPackage().getName().equals(AJC_INTERNAL)) {
                    ++syntheticCount;
                }
                ++n2;
            }
            this.parameterTypes = new AjType[ptypes.length - syntheticCount];
            int i = 0;
            while (i < this.parameterTypes.length) {
                this.parameterTypes[i] = AjTypeSystem.getAjType(ptypes[i]);
                ++i;
            }
        }
        return this.parameterTypes;
    }

    @Override
    public AjType<?>[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            Class<?>[] exTypes = this.adviceMethod.getExceptionTypes();
            this.exceptionTypes = new AjType[exTypes.length];
            int i = 0;
            while (i < exTypes.length) {
                this.exceptionTypes[i] = AjTypeSystem.getAjType(exTypes[i]);
                ++i;
            }
        }
        return this.exceptionTypes;
    }

    @Override
    public AdviceKind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        String adviceName = this.adviceMethod.getName();
        if (adviceName.startsWith("ajc$")) {
            adviceName = "";
            AdviceName name = this.adviceMethod.getAnnotation(AdviceName.class);
            if (name != null) {
                adviceName = name.value();
            }
        }
        return adviceName;
    }

    @Override
    public PointcutExpression getPointcutExpression() {
        return this.pointcutExpression;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getName().length() > 0) {
            sb.append("@AdviceName(\"");
            sb.append(this.getName());
            sb.append("\") ");
        }
        if (this.getKind() == AdviceKind.AROUND) {
            sb.append(this.adviceMethod.getGenericReturnType().toString());
            sb.append(" ");
        }
        switch (this.getKind()) {
            case AFTER: {
                sb.append("after(");
                break;
            }
            case AFTER_RETURNING: {
                sb.append("after(");
                break;
            }
            case AFTER_THROWING: {
                sb.append("after(");
                break;
            }
            case AROUND: {
                sb.append("around(");
                break;
            }
            case BEFORE: {
                sb.append("before(");
            }
        }
        AjType<?>[] ptypes = this.getParameterTypes();
        int len = ptypes.length;
        if (this.hasExtraParam) {
            --len;
        }
        int i = 0;
        while (i < len) {
            sb.append(ptypes[i].getName());
            if (i + 1 < len) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(") ");
        switch (this.getKind()) {
            case AFTER_RETURNING: {
                sb.append("returning");
                if (this.hasExtraParam) {
                    sb.append("(");
                    sb.append(ptypes[len - 1].getName());
                    sb.append(") ");
                }
            }
            case AFTER_THROWING: {
                sb.append("throwing");
                if (!this.hasExtraParam) break;
                sb.append("(");
                sb.append(ptypes[len - 1].getName());
                sb.append(") ");
            }
        }
        AjType<?>[] exTypes = this.getExceptionTypes();
        if (exTypes.length > 0) {
            sb.append("throws ");
            int i2 = 0;
            while (i2 < exTypes.length) {
                sb.append(exTypes[i2].getName());
                if (i2 + 1 < exTypes.length) {
                    sb.append(",");
                }
                ++i2;
            }
            sb.append(" ");
        }
        sb.append(": ");
        sb.append(this.getPointcutExpression().asString());
        return sb.toString();
    }
}

