/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.gui;

import fr.inria.aoste.timesquare.backend.codeexecution.gui.CodeSelectionAdapter;
import fr.inria.aoste.timesquare.backend.codeexecution.manager.CodeExecutionManager;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.Variable;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockActivationState;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManagerGUI;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.GUIHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.node.Node;
import fr.inria.aoste.timesquare.utils.ui.widgets.FileSelectionControl;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CodeExecutionGUI
extends BehaviorManagerGUI {
    public static final String WIDGET_CODEEXECUTOR_SELECT_RELATION = "codeexecutor.select.relation";
    public static final String WIDGET_CODEEXECUTOR_SELECT_CLOCK_ACTIVATION_STATE = "codeexecutor.select.clockActivationState";
    public static final String WIDGET_CODEEXECUTOR_SELECT_ASSERT = "codeexecutor.select.assert";
    public static final String WIDGET_CODEEXECUTOR_SELECT_CLOCK = "codeexecutor.select.clock";
    public static final String WIDGET_CODEEXECUTOR_SELECT_CLOCK_TO_FORCE = "codeexecutor.select.clocksToForce";
    Composite _composite = null;
    private IMethod _method = null;
    private ClockActivationState _clockActivationState = null;
    private Tree _treeClock = null;
    private Tree _treeClockToForce = null;
    private boolean[] _assertState = null;
    private Combo _comboAssert = null;
    private Composite _compositeVariableMethod = null;
    private Composite _compositeClock = null;
    private Composite _compositeAssert = null;
    private Composite _compositeRelation = null;
    private Composite _compositeModel = null;
    private Tree _treeRelation = null;
    private Combo c = null;
    private IStatus fCurrStatus = Status.OK_STATUS;
    private Button ok;
    private Combo comboVariable;
    private Label label;
    private Combo comboMethod;
    private FileSelectionControl codeexecModelBrowser;
    private Variable var = null;

    public Control createDialogArea(Composite composite) {
        if (composite == null) {
            return null;
        }
        this._composite = new Composite(composite, 20);
        composite.setLayout((Layout)new GridLayout());
        this._composite.setLayoutData((Object)new GridData(1808));
        this._composite.setLayout((Layout)new FormLayout());
        this.c = new Combo(this._composite, 10);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 6);
        layoutData.right = new FormAttachment(100, -6);
        layoutData.top = new FormAttachment(0, 6);
        this.c.setLayoutData((Object)layoutData);
        this.c.setLayout((Layout)new RowLayout());
        this.c.add("Clock Behavior");
        this.c.add("Relation Behavior");
        this.c.add("Assert Behavior");
        this.c.add("Load from Model");
        this.c.select(0);
        this.displayCodeExecModelChoice(this._composite);
        Group group2 = new Group(this._composite, 6);
        group2.setLayout((Layout)new FormLayout());
        FormData layoutData2 = new FormData();
        layoutData2.left = new FormAttachment(0, 6);
        layoutData2.right = new FormAttachment(100, -6);
        layoutData2.top = new FormAttachment((Control)this.c, 6);
        group2.setLayoutData((Object)layoutData2);
        this.label = new Label((Composite)group2, 0);
        FormData fd_label = new FormData();
        fd_label.top = new FormAttachment(0, 3);
        fd_label.left = new FormAttachment(0, 3);
        this.label.setLayoutData((Object)fd_label);
        this.label.setText("Variable:");
        this.label.pack();
        this.comboVariable = new Combo((Composite)group2, 0);
        this.updateVariable();
        this.comboVariable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CodeExecutionGUI.this.updateMethods();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CodeExecutionGUI.this.updateMethods();
            }
        });
        this.ok = new Button((Composite)group2, 0);
        this.ok.setText("Add Var");
        this.ok.addSelectionListener((SelectionListener)new CodeSelectionAdapter(this));
        Label lblNewLabel = new Label((Composite)group2, 0);
        lblNewLabel.setText("Method:");
        this.comboMethod = new Combo((Composite)group2, 0);
        this.updateMethods();
        this.comboMethod.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CodeExecutionGUI.this.selectMethod();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CodeExecutionGUI.this.selectMethod();
            }
        });
        FormData fd_combo_1 = new FormData();
        fd_combo_1.top = new FormAttachment(0, 3);
        fd_combo_1.left = new FormAttachment(0, 70);
        fd_combo_1.right = new FormAttachment((Control)this.ok, -6);
        this.comboVariable.setLayoutData((Object)fd_combo_1);
        FormData fd_ok = new FormData();
        fd_ok.right = new FormAttachment(100, -10);
        fd_ok.width = 100;
        fd_ok.top = new FormAttachment(0, 3);
        this.ok.setLayoutData((Object)fd_ok);
        FormData fd_lblNewLabel = new FormData();
        fd_lblNewLabel.bottom = new FormAttachment(100, -4);
        fd_lblNewLabel.top = new FormAttachment((Control)this.label, 18);
        fd_lblNewLabel.left = new FormAttachment((Control)this.label, 0, 16384);
        lblNewLabel.setLayoutData((Object)fd_lblNewLabel);
        FormData fd_combo = new FormData();
        fd_combo.right = new FormAttachment((Control)this.ok, -6);
        fd_combo.left = new FormAttachment((Control)this.comboVariable, 0, 16384);
        fd_combo.top = new FormAttachment((Control)this.label, 18);
        fd_combo.bottom = new FormAttachment(100, -4);
        this.comboMethod.setLayoutData((Object)fd_combo);
        this._compositeVariableMethod = group2;
        Group group3 = new Group(this._composite, 6);
        group3.setLayout((Layout)new FormLayout());
        FormData layoutData3 = new FormData();
        layoutData3.top = new FormAttachment((Control)group2, 7);
        layoutData3.bottom = new FormAttachment(100, -6);
        layoutData3.left = new FormAttachment(0, 6);
        layoutData3.right = new FormAttachment(100, -6);
        group3.setLayoutData((Object)layoutData3);
        this.displayRelationChoice((Composite)group3);
        this.displayClockChoice((Composite)group3);
        this.displayAssertChoice((Composite)group3);
        group3.setSize(400, 350);
        this.c.addSelectionListener((SelectionListener)new ComboTypeSelectionAdapter());
        this._compositeVariableMethod.setVisible(true);
        this._compositeClock.setVisible(true);
        this._compositeRelation.setVisible(false);
        this._compositeAssert.setVisible(false);
        this._compositeModel.setVisible(false);
        return composite;
    }

    public void okPressed() {
        if (this._compositeClock.isVisible()) {
            this.addClockBehavior();
            return;
        }
        if (this._compositeRelation.isVisible()) {
            this.addRelationBehavior();
            return;
        }
        if (this._compositeAssert.isVisible()) {
            this.addAssertBehavior();
        }
        if (this._compositeModel.isVisible()) {
            this.addBehaviorsFromModel();
        }
    }

    public void addClockBehavior() {
        ClockEntity ce = null;
        if (this._treeClock != null) {
            ce = (ClockEntity)((Node)this._treeClock.getData(GUIHelper.COMBOSELECTION)).getValue();
        }
        TreeItem[] treeItemClocksToForce = null;
        ArrayList<ClockEntity> clocksToForce = new ArrayList<ClockEntity>();
        if (this._treeClockToForce != null) {
            treeItemClocksToForce = this._treeClockToForce.getSelection();
        }
        int i = 0;
        while (i < treeItemClocksToForce.length) {
            clocksToForce.add((ClockEntity)((Node)treeItemClocksToForce[i].getData()).getValue());
            ++i;
        }
        if (this._method != null && ce != null && this._clockActivationState != null) {
            this.getBehaviorManager().addBehavior(this.var, this._method, ce, this._clockActivationState, clocksToForce);
        }
    }

    public void addRelationBehavior() {
        RelationEntity ce = null;
        if (this._treeRelation != null) {
            ce = (RelationEntity)((Node)this._treeRelation.getData(GUIHelper.COMBOSELECTION)).getValue();
        }
        if (this._method != null && ce != null) {
            this.getBehaviorManager().addBehavior(this.var, this._method, ce);
        }
    }

    public void addAssertBehavior() {
        ClockEntity ae = null;
        if (this._comboAssert != null) {
            ae = (ClockEntity)this._comboAssert.getData(GUIHelper.COMBOSELECTION);
        }
        if (this._method != null && this._assertState != null) {
            this.getBehaviorManager().addBehavior(this.var, this._method, ae, this._assertState);
        }
    }

    public void addBehaviorsFromModel() {
        if (this.codeexecModelBrowser != null) {
            this.getBehaviorManager().addBehaviorsFromModel(this.codeexecModelBrowser.getSelectedFile());
        }
    }

    protected CodeExecutionManager getBehaviorManager() {
        return (CodeExecutionManager)super.getBehaviorManager();
    }

    public void setBehaviorManager(BehaviorManager behaviorManager) {
        if (behaviorManager instanceof CodeExecutionManager) {
            super.setBehaviorManager(behaviorManager);
        }
    }

    public void cancelPressed() {
    }

    private Composite displayCodeExecModelChoice(Composite parent) {
        Group group1 = new Group(parent, 6);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 6);
        layoutData.right = new FormAttachment(100, -6);
        layoutData.top = new FormAttachment((Control)this.c, 6);
        group1.setLayoutData((Object)layoutData);
        group1.setLayout((Layout)new GridLayout(1, true));
        String[] extensions = new String[]{"codeexecution"};
        this.codeexecModelBrowser = new FileSelectionControl((Composite)group1, "Code Execution Model", extensions);
        String modelFile = this.getBehaviorManager().getCodeExecModelFilename();
        if (modelFile != null) {
            this.codeexecModelBrowser.setSelectedFile(modelFile);
        }
        this._compositeModel = group1;
        return group1;
    }

    private void displayClockChoice(Composite composite) {
        this._compositeClock = new Composite(composite, 18);
        this._compositeClock.setLocation(10, 10);
        this._compositeClock.setLayout((Layout)new FormLayout());
        this._treeClock = this.getGUIHelper().displayTreeClock(this._compositeClock, WIDGET_CODEEXECUTOR_SELECT_CLOCK, 4).getTree();
        FormData datatree = new FormData();
        datatree.top = new FormAttachment(0, 3);
        datatree.left = new FormAttachment(0, 3);
        datatree.right = new FormAttachment(100, -800);
        datatree.bottom = new FormAttachment(100, -6);
        this._treeClock.setLayoutData((Object)datatree);
        this._treeClockToForce = this.getGUIHelper().displayTreeClock(this._compositeClock, WIDGET_CODEEXECUTOR_SELECT_CLOCK_TO_FORCE, 2).getTree();
        FormData datatreeToForce = new FormData();
        datatreeToForce.top = new FormAttachment(0, 3);
        datatreeToForce.left = new FormAttachment(0, 550);
        datatreeToForce.right = new FormAttachment(100, -300);
        datatreeToForce.bottom = new FormAttachment(100, -6);
        this._treeClockToForce.setLayoutData((Object)datatreeToForce);
        FormData data = new FormData();
        this._clockActivationState = this.getGUIHelper().displayClockState(this._compositeClock, (Object)data, WIDGET_CODEEXECUTOR_SELECT_CLOCK_ACTIVATION_STATE);
        data.top = new FormAttachment(0, 3);
        data.right = new FormAttachment(100, -3);
        data.left = new FormAttachment(100, -290);
        data.bottom = new FormAttachment(100, -6);
        data.height = 250;
        FormData layoutData = new FormData();
        layoutData.bottom = new FormAttachment(100, -6);
        layoutData.left = new FormAttachment(0, 6);
        layoutData.right = new FormAttachment(100, -6);
        layoutData.top = new FormAttachment(0, 6);
        this._compositeClock.setLayoutData((Object)layoutData);
        this._compositeClock.pack();
    }

    private void displayAssertChoice(Composite composite) {
        this._compositeAssert = new Composite(composite, 18);
        this._compositeAssert.setLocation(10, 10);
        this._compositeAssert.setLayout((Layout)new GridLayout(1, true));
        this._comboAssert = this.getGUIHelper().displayList(this._compositeAssert, this.getConfigurationHelper().getAssert(), WIDGET_CODEEXECUTOR_SELECT_ASSERT);
        this._comboAssert.setLayoutData((Object)new GridData(4, 0, true, false));
        this._assertState = this.getGUIHelper().displayAssertStateCheckBox(this._compositeAssert, (Object)new GridData(4, 0, true, false));
        FormData layoutData = new FormData();
        layoutData.bottom = new FormAttachment(100, -6);
        layoutData.left = new FormAttachment(0, 6);
        layoutData.right = new FormAttachment(100, -6);
        layoutData.top = new FormAttachment(0, 6);
        this._compositeAssert.setLayoutData((Object)layoutData);
        this._compositeAssert.pack();
    }

    private void displayRelationChoice(Composite composite) {
        this._compositeRelation = new Composite(composite, 18);
        this._compositeRelation.setLocation(10, 10);
        this._compositeRelation.setLayout((Layout)new FormLayout());
        this._treeRelation = this.getGUIHelper().displayTreeRelation(this._compositeRelation, WIDGET_CODEEXECUTOR_SELECT_RELATION).getTree();
        FormData _layoutData = new FormData();
        _layoutData.bottom = new FormAttachment(100, -6);
        _layoutData.left = new FormAttachment(0, 6);
        _layoutData.right = new FormAttachment(100, -6);
        _layoutData.top = new FormAttachment(0, 6);
        _layoutData.height = 250;
        this._treeRelation.setLayoutData((Object)_layoutData);
        this._treeRelation.pack();
        FormData layoutData = new FormData();
        layoutData.bottom = new FormAttachment(100, -6);
        layoutData.left = new FormAttachment(0, 6);
        layoutData.right = new FormAttachment(100, -6);
        layoutData.top = new FormAttachment(0, 6);
        this._compositeRelation.setLayoutData((Object)layoutData);
        this._compositeRelation.pack();
    }

    public Point getMinimumSize() {
        return new Point(450, 350);
    }

    public void updateOKStatus() {
        try {
            this.fCurrStatus = Status.OK_STATUS;
            if (this._compositeModel.isVisible()) {
                return;
            }
            if (this._method == null) {
                this.fCurrStatus = new Status(4, "fr.inria.aoste.timesquare.backend.codeexecution", 4, "no code", null);
                return;
            }
            if (this._compositeClock.isVisible()) {
                if (!(this._treeClock.getData(GUIHelper.COMBOSELECTION) instanceof Node)) {
                    this.fCurrStatus = new Status(4, "fr.inria.aoste.timesquare.backend.codeexecution", 4, "no clock Selected", null);
                    return;
                }
                if (((Node)this._treeClock.getData(GUIHelper.COMBOSELECTION)).getValue() == null) {
                    this.fCurrStatus = new Status(4, "fr.inria.aoste.timesquare.backend.codeexecution", 4, "no clock Selected", null);
                }
                return;
            }
            if (this._compositeRelation.isVisible()) {
                if (!(this._treeRelation.getData(GUIHelper.COMBOSELECTION) instanceof Node)) {
                    this.fCurrStatus = new Status(4, "fr.inria.aoste.timesquare.backend.codeexecution", 4, "no relation Selected", null);
                    return;
                }
                if (((Node)this._treeRelation.getData(GUIHelper.COMBOSELECTION)).getValue() == null) {
                    this.fCurrStatus = new Status(4, "fr.inria.aoste.timesquare.backend.codeexecution", 4, "no relation selected", null);
                }
                return;
            }
            if (this._compositeAssert.isVisible()) {
                return;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            this.fCurrStatus = new Status(4, "fr.inria.aoste.timesquare.backend.codeexecution", 4, "updateOKStatus() fail:" + e.getMessage(), null);
        }
        finally {
            if (this.dialog != null) {
                this.dialog.updateStatus(this.fCurrStatus);
            }
        }
    }

    public void updateVariable() {
        this.comboVariable.removeAll();
        for (Variable v : this.getBehaviorManager().getListVariable()) {
            this.comboVariable.add(String.valueOf(v.name) + " [" + v.getTypeName() + "]");
        }
    }

    public void updateMethods() {
        this.comboMethod.removeAll();
        int i = this.comboVariable.getSelectionIndex();
        this.var = i == -1 ? null : this.getBehaviorManager().getListVariable().get(i);
        if (this.var != null) {
            for (IMethod v : this.var.getIMethods()) {
                try {
                    String name = v.getElementName();
                    this.comboMethod.add(name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        } else {
            this._method = null;
        }
    }

    public void selectMethod() {
        try {
            int i = this.comboMethod.getSelectionIndex();
            this._method = i == -1 && this.var != null ? null : this.var.getIMethods().get(i);
        }
        catch (Exception e) {
            this._method = null;
        }
    }

    public void selectVariable(Variable v) {
        int n = this.getBehaviorManager().getListVariable().indexOf(v);
        if (n != -1) {
            this.comboVariable.select(n);
        }
    }

    private final class ComboTypeSelectionAdapter
    extends SelectionAdapter {
        private ComboTypeSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            int s = CodeExecutionGUI.this.c.getSelectionIndex();
            if (s == 0) {
                CodeExecutionGUI.this._compositeVariableMethod.setVisible(true);
                CodeExecutionGUI.this._compositeClock.setVisible(true);
                CodeExecutionGUI.this._compositeRelation.setVisible(false);
                CodeExecutionGUI.this._compositeAssert.setVisible(false);
                CodeExecutionGUI.this._compositeModel.setVisible(false);
            } else if (s == 1) {
                CodeExecutionGUI.this._compositeVariableMethod.setVisible(true);
                CodeExecutionGUI.this._compositeClock.setVisible(false);
                CodeExecutionGUI.this._compositeRelation.setVisible(true);
                CodeExecutionGUI.this._compositeAssert.setVisible(false);
                CodeExecutionGUI.this._compositeModel.setVisible(false);
            } else if (s == 2) {
                CodeExecutionGUI.this._compositeVariableMethod.setVisible(true);
                CodeExecutionGUI.this._compositeClock.setVisible(false);
                CodeExecutionGUI.this._compositeRelation.setVisible(false);
                CodeExecutionGUI.this._compositeAssert.setVisible(true);
                CodeExecutionGUI.this._compositeModel.setVisible(false);
            } else if (s == 3) {
                CodeExecutionGUI.this._compositeVariableMethod.setVisible(false);
                CodeExecutionGUI.this._compositeClock.setVisible(false);
                CodeExecutionGUI.this._compositeRelation.setVisible(false);
                CodeExecutionGUI.this._compositeAssert.setVisible(false);
                CodeExecutionGUI.this._compositeModel.setVisible(true);
            }
            CodeExecutionGUI.this.updateOKStatus();
        }
    }
}

