/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.NatureToggling;
import org.eclipse.gemoc.commons.eclipse.jdt.JavaProject;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.ui.PluginConverter;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.BundleException;

public class ToggleNatureAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.toggleNature(project);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void toggleNature(IProject project) {
        try {
            NatureToggling result = null;
            if (!project.hasNature("org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.gemocLanguageDesignerNature")) {
                IProjectUtils.addNature((IProject)project, (String)"org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.gemocLanguageDesignerNature");
                result = NatureToggling.Added;
            } else {
                result = NatureToggling.Removed;
            }
            switch (result) {
                case Added: {
                    JavaProject.create((IProject)project);
                    this.addPluginNature(project);
                    this.addGemocNature(project);
                    this.updateManifestFile(project);
                    break;
                }
                case Removed: {
                    ToggleNatureAction.removeNature(project, "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.gemocLanguageDesignerNature", null);
                    break;
                }
            }
        }
        catch (IOException | CoreException e) {
            Activator.error("Problem while adding Gemoc Language nature to project. " + e.getMessage(), e);
        }
    }

    public static void addNature(IProject project, String natureID, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature(natureID)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = natureID;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public static void removeNature(IProject project, String natureID, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (project.hasNature(natureID)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length - 1];
            int i = 0;
            String[] stringArray = natures;
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (n3.compareTo(natureID) != 0) {
                    newNatures[i++] = n3;
                }
                ++n2;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    private void addPluginNature(IProject project) throws CoreException {
        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
            try {
                PluginXMLHelper.createEmptyTemplateFile((IFile)project.getFile("plugin.xml"), (boolean)false);
                PluginConverter.convert((IProject)project);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Activator.error("cannot add org.eclipse.pde.PluginNature nature to project due to " + e.getMessage(), e);
            }
        }
    }

    private void updateManifestFile(IProject project) {
        ManifestChanger changer = new ManifestChanger(project);
        try {
            changer.addPluginDependency("org.eclipse.gemoc.xdsmlframework.api", "0.1.0", true, true);
            changer.addPluginDependency("org.eclipse.emf.ecore.xmi", "2.8.0", true, true);
            changer.addPluginDependency("org.eclipse.gemoc.xdsmlframework.api");
            changer.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api");
            changer.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaengine");
            changer.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3");
            changer.addPluginDependency("org.eclipse.gemoc.executionframework.engine");
            changer.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.timesquare");
            changer.commit();
        }
        catch (IOException | CoreException | BundleException e) {
            e.printStackTrace();
        }
    }

    private void addGemocNature(IProject project) throws CoreException {
        ToggleNatureAction.addAsMainNature(project, "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.gemocLanguageDesignerNature", null);
        this.addMissingResourcesToNature(project);
        this.addGemocResourcesToBuildProperties(project);
        this.addSourceFolder(project, "xdsml-java-gen/");
    }

    public static void addAsMainNature(IProject project, String natureID, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature(natureID)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = natureID;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public void addSourceFolder(IProject project, String folder) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            IPath srcPath = javaProject.getPath().append(folder);
            IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcPath, null);
            boolean entryfound = false;
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.equals(srcEntry)) {
                    entryfound = true;
                }
                ++n2;
            }
            if (!entryfound) {
                newEntries[entries.length] = JavaCore.newSourceEntry((IPath)srcEntry.getPath());
                javaProject.setRawClasspath(newEntries, null);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void addMissingResourcesToNature(IProject project) {
    }

    private void addGemocResourcesToBuildProperties(IProject project) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = project.getFile("build.properties").getContents();
            properties.load(inputStream);
            String binIncludes = properties.getProperty("bin.includes");
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            properties.store(out, "");
            out.close();
            project.getFile("build.properties").setContents((InputStream)in, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            Activator.error(e1.getMessage(), e1);
        }
        catch (IOException e) {
            Activator.error(e.getMessage(), e);
        }
    }
}

