/*******************************************************************************
 * Copyright (c) 2009, 2016 Willink Transformations and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.types.operations;

import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.types.TypeType;

/**
 * <!-- begin-user-doc -->
 * A static utility class that provides operations related to '<em><b>Template Parameter Type</b></em>' model objects.
 * @since 3.0
 * <!-- end-user-doc -->
 *
 * <p>
 * The following operations are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.ocl.utilities.PredefinedType#getName() <em>Get Name</em>}</li>
 *   <li>{@link org.eclipse.ocl.utilities.PredefinedType#oclOperations() <em>Ocl Operations</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TemplateParameterTypeOperations {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateParameterTypeOperations() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public static <C, O> String getName(TypeType<C, O> typeType) {
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public static <C, O> EList<O> oclOperations(TypeType<C, O> typeType) {
		throw new UnsupportedOperationException();
	}

} // TemplateParameterTypeOperations