/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.io.PathReference;

final class DirTransformer {
    private static final String MANIFEST_VERSION_HEADER = "Manifest-Version: 1.0";
    private final DirTransformerCallback callback;

    DirTransformer(DirTransformerCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback must not be null");
        }
        this.callback = callback;
    }

    void transform(URL url, URL transformedUrl) throws IOException {
        this.transform(url, transformedUrl, false);
    }

    void transform(URL url, URL transformedUrl, boolean ensureManifestIsPresent) throws IOException {
        PathReference fromDirectory = new PathReference(url.getPath());
        PathReference toDirectory = new PathReference(transformedUrl.getPath());
        this.transformDir(fromDirectory, toDirectory);
        PathReference manifest = fromDirectory.newChild("META-INF/MANIFEST.MF");
        if (ensureManifestIsPresent && !manifest.exists()) {
            InputStream defaultManifestStream = this.getDefaultManifestStream();
            PathReference toFile = toDirectory.newChild("META-INF/MANIFEST.MF");
            toFile.getParent().createDirectory();
            try {
                this.callback.transformFile(defaultManifestStream, toFile);
            }
            finally {
                IOUtils.closeQuietly((Closeable)defaultManifestStream);
            }
        }
    }

    private void transformDir(PathReference fromDirectory, PathReference toDirectory) throws IOException {
        File[] fileList = fromDirectory.toFile().listFiles();
        PathReference fromFile = null;
        int i = 0;
        while (fileList != null && i < fileList.length) {
            fromFile = new PathReference(fileList[i]);
            PathReference toFile = toDirectory.newChild(fromFile.getName());
            if (!fromFile.isDirectory()) {
                this.transformFile(fromFile, toFile);
            } else {
                this.transformDir(fromFile, toFile);
            }
            ++i;
        }
    }

    private void transformFile(PathReference fromFile, PathReference toFile) throws IOException {
        FileInputStream fis = new FileInputStream(fromFile.toFile());
        boolean transformed = false;
        try {
            transformed = this.callback.transformFile(fis, toFile);
        }
        finally {
            IOUtils.closeQuietly((Closeable)fis);
        }
        if (!transformed) {
            toFile.getParent().createDirectory();
            fromFile.copy(toFile);
        }
    }

    private InputStream getDefaultManifestStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        writer.println(MANIFEST_VERSION_HEADER);
        writer.println();
        writer.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    static interface DirTransformerCallback {
        public boolean transformFile(InputStream var1, PathReference var2) throws IOException;
    }
}

