/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class Initialization {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers typeHelpers;
    @Inject
    @Extension
    private JavaExtensions languageExt;
    @Inject
    @Extension
    private ProcedureHelpers procedureHelpers;

    public CharSequence attributeInitialization(List<Attribute> attribs, EObject roomClass, boolean useClassDefaultsOnly) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("// initialize attributes");
        stringConcatenation.newLine();
        for (Attribute a : attribs) {
            CharSequence charSequence = this.attributeClassInit(a, roomClass, useClassDefaultsOnly);
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.newLineIfNotEmpty();
            boolean bl = this.typeHelpers.isDataClass(a.getType().getType());
            if (bl) {
                CharSequence charSequence2 = this.attributeInitPrimitiveRec(this._roomExtensions.union(new ArrayList(), (Object)a), roomClass);
                stringConcatenation.append((Object)charSequence2);
            }
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation;
    }

    private CharSequence attributeClassInit(Attribute a, EObject roomClass, boolean useClassDefaultsOnly) {
        String value;
        CharSequence charSequence;
        CharSequence charSequence2;
        CharSequence charSequence3 = null;
        DataType aType = a.getType().getType();
        CharSequence charSequence4 = null;
        boolean bl = false;
        boolean bl2 = a.getType().isRef();
        if (bl2) {
            boolean bl3;
            bl = true;
            charSequence2 = null;
            String string = a.getDefaultValueLiteral();
            boolean bl4 = bl3 = string != null;
            if (bl3) {
                charSequence2 = this.attributeInit(a, a.getDefaultValueLiteral());
            } else {
                charSequence = null;
                boolean bl5 = this.languageExt.needsInitialization(a);
                if (bl5) {
                    charSequence = this.attributeInit(a, this.languageExt.nullPointer());
                }
                charSequence2 = charSequence;
            }
            charSequence4 = charSequence2;
        }
        if (!bl && aType instanceof PrimitiveType) {
            bl = true;
            charSequence2 = null;
            value = this.getDataConfigValue(this._roomExtensions.union(new ArrayList(), (Object)a), roomClass);
            if (value == null) {
                value = a.getDefaultValueLiteral();
            }
            CharSequence charSequence5 = null;
            if (value != null) {
                charSequence5 = this.attributeInit(a, this.languageExt.toValueLiteral((PrimitiveType)aType, value));
            } else {
                charSequence = null;
                if (!useClassDefaultsOnly || this.languageExt.needsInitialization(a)) {
                    charSequence = this.attributeInit(a, this.languageExt.defaultValue(aType));
                }
                charSequence5 = charSequence;
            }
            charSequence4 = charSequence2 = charSequence5;
        }
        if (!bl && aType instanceof EnumerationType) {
            bl = true;
            charSequence2 = null;
            value = this.getDataConfigValue(this._roomExtensions.union(new ArrayList(), (Object)a), roomClass);
            if (value == null) {
                value = a.getDefaultValueLiteral();
            }
            CharSequence charSequence6 = null;
            if (value != null) {
                charSequence6 = this.attributeInit(a, this.languageExt.toEnumLiteral((EnumerationType)aType, value));
            } else {
                charSequence = null;
                if (!useClassDefaultsOnly || this.languageExt.needsInitialization(a)) {
                    charSequence = this.attributeInit(a, this.languageExt.defaultValue(aType));
                }
                charSequence6 = charSequence;
            }
            charSequence4 = charSequence2 = charSequence6;
        }
        if (!bl) {
            charSequence4 = this.attributeInit(a, this.languageExt.defaultValue(aType));
        }
        charSequence3 = charSequence4;
        return charSequence3;
    }

    private CharSequence attributeInitPrimitiveRec(List<Attribute> path, EObject roomClass) {
        Attribute a = (Attribute)IterableExtensions.lastOrNull(path);
        DataType aType = a.getType().getType();
        boolean bl = false;
        if (aType instanceof DataClass) {
            bl = true;
            StringConcatenation stringConcatenation = new StringConcatenation();
            List list = this._roomHelpers.getAllAttributes((DataClass)aType);
            for (Attribute e : list) {
                CharSequence charSequence = this.attributeInitPrimitiveRec(this._roomExtensions.union(path, (Object)e), roomClass);
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.newLineIfNotEmpty();
            }
            return stringConcatenation;
        }
        if (!bl && aType instanceof PrimitiveType) {
            bl = true;
            String value = this.getDataConfigValue(path, roomClass);
            CharSequence charSequence = null;
            if (value != null) {
                charSequence = this.attributeInit(path, this.languageExt.toValueLiteral((PrimitiveType)aType, value));
            }
            return charSequence;
        }
        if (!bl && aType instanceof EnumerationType) {
            bl = true;
            String value = this.getDataConfigValue(path, roomClass);
            CharSequence charSequence = null;
            if (value != null) {
                charSequence = this.attributeInit(path, this.languageExt.toEnumLiteral((EnumerationType)aType, value));
            }
            return charSequence;
        }
        return null;
    }

    private CharSequence attributeInit(Attribute a, String value) {
        return this.attributeInit(this._roomExtensions.union(new ArrayList(), (Object)a), value);
    }

    private CharSequence attributeInit(List<Attribute> path, String value) {
        boolean bl;
        String string = null;
        int n = path.size();
        boolean bl2 = bl = n == 1;
        if (bl) {
            string = "this";
        } else {
            int n2 = path.size();
            int n3 = n2 - 1;
            string = this.procedureHelpers.invokeGetters(IterableExtensions.take(path, (int)n3), null).toString();
        }
        String getter = string;
        return this.genAttributeInitializer((Attribute)IterableExtensions.lastOrNull(path), value, getter);
    }

    public CharSequence genAttributeInitializer(Attribute a, String value, String invokes) {
        StringConcatenation stringConcatenation = null;
        DataType aType = a.getType().getType();
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        if (a.getSize() == 0 || a.getSize() > 0 && "char".equals(this.typeHelpers.typeName(aType)) && !value.matches("'.'|\\(char\\).*")) {
            stringConcatenation2.append(invokes);
            stringConcatenation2.append(".");
            CharSequence charSequence = this.procedureHelpers.invokeSetter(a.getName(), null, value);
            stringConcatenation2.append((Object)charSequence);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        } else if (!value.trim().startsWith("{") || "char".equals(this.typeHelpers.typeName(aType))) {
            boolean bl;
            stringConcatenation2.append("{");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            String string = this.typeHelpers.typeName(aType);
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.append("[] array = new ");
            String string2 = this.typeHelpers.typeName(aType);
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append("[");
            int n = a.getSize();
            stringConcatenation2.append((Object)n, "\t");
            stringConcatenation2.append("];");
            stringConcatenation2.newLineIfNotEmpty();
            boolean bl2 = bl = !a.getType().isRef() || !this.typeHelpers.isPrimitive(aType);
            if (bl) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (int i=0;i<");
                int n2 = a.getSize();
                stringConcatenation2.append((Object)n2, "\t");
                stringConcatenation2.append(";i++){");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("array[i] = ");
                stringConcatenation2.append(value, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append(invokes, "\t");
            stringConcatenation2.append(".");
            CharSequence charSequence = this.procedureHelpers.invokeSetter(a.getName(), null, "array");
            stringConcatenation2.append((Object)charSequence, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        } else {
            stringConcatenation2.append(invokes);
            stringConcatenation2.append(".");
            String string = a.getName();
            StringConcatenation stringConcatenation3 = new StringConcatenation();
            stringConcatenation3.append("new ");
            String string3 = this.typeHelpers.typeName(aType);
            stringConcatenation3.append(string3);
            stringConcatenation3.append("[] ");
            stringConcatenation3.append(value);
            CharSequence charSequence = this.procedureHelpers.invokeSetter(string, null, stringConcatenation3.toString());
            stringConcatenation2.append((Object)charSequence);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String getDataConfigValue(List<Attribute> path, EObject roomClass) {
        String string = null;
        boolean bl = false;
        if (roomClass instanceof ActorClass) {
            bl = true;
            string = this.typeHelpers.getAttrClassConfigValue(path, (ActorClass)roomClass, false);
        }
        if (!bl && roomClass instanceof PortClass) {
            bl = true;
            string = this.typeHelpers.getAttrClassConfigValue(path, (PortClass)roomClass);
        }
        if (!bl && roomClass instanceof DataClass) {
            bl = true;
            string = null;
        }
        return string;
    }
}

