/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.types;

import java.util.List;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcEnumLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PlcEnumType
extends PlcDerivedType {
    public final List<PlcEnumLiteral> literals;

    public PlcEnumType(String typeName, List<String> literalNames) {
        super(typeName);
        this.literals = (List)literalNames.stream().map(name -> new PlcEnumLiteral((String)name, this)).collect(Lists.toList());
    }

    @Override
    public boolean equals(Object other) {
        PlcEnumType enumType;
        block5: {
            block4: {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PlcEnumType)) break block4;
                enumType = (PlcEnumType)other;
                if (this.typeName.equals(enumType.typeName)) break block5;
            }
            return false;
        }
        Assert.areEqual(this.literals, enumType.literals, (Object)"Enum types with the same name must have the same literal values.");
        return true;
    }

    @Override
    public int hashCode() {
        return this.typeName.hashCode();
    }

    @Override
    public String toString() {
        return "PlcEnumType(\"" + this.typeName + "\")";
    }

    public PlcExpression getLiteral(int literalIndex) {
        return this.literals.get(literalIndex);
    }
}

