/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.tooldef.runtime.ToolDefEqWrap;

public class ToolDefSet<E>
implements Set<E> {
    private final Set<ToolDefEqWrap<E>> storage;

    public ToolDefSet() {
        this.storage = Sets.set();
    }

    public ToolDefSet(int initialCapacity) {
        this.storage = Sets.setc((int)initialCapacity);
    }

    public ToolDefSet(Collection<? extends E> collection) {
        this.storage = Sets.setc((int)collection.size());
        for (E elem : collection) {
            this.storage.add(ToolDefEqWrap.wrap(elem));
        }
    }

    private ToolDefSet(Set<ToolDefEqWrap<E>> set) {
        this.storage = set;
    }

    public static <T> ToolDefSet<T> wrap(Set<ToolDefEqWrap<T>> set) {
        return new ToolDefSet(set);
    }

    @Override
    public boolean add(E elem) {
        ToolDefEqWrap<E> wrappedElem = ToolDefEqWrap.wrap(elem);
        return this.storage.add(wrappedElem);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean rslt = false;
        for (E elem : c) {
            rslt |= this.add(elem);
        }
        return rslt;
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public boolean contains(Object elem) {
        ToolDefEqWrap<Object> wrappedElem = ToolDefEqWrap.wrap(elem);
        return this.storage.contains(wrappedElem);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object elem : c) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolDefSet)) {
            return false;
        }
        ToolDefSet other = (ToolDefSet)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return this.containsAll(other);
    }

    @Override
    public int hashCode() {
        int rslt = ToolDefSet.class.hashCode();
        for (ToolDefEqWrap<E> wrap : this.storage) {
            rslt = 31 * rslt + wrap.hashCode();
        }
        return rslt;
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<ToolDefEqWrap<E>> iter;
            {
                this.iter = ToolDefSet.this.storage.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                return this.iter.next().value;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public boolean remove(Object elem) {
        ToolDefEqWrap<Object> wrappedElem = ToolDefEqWrap.wrap(elem);
        return this.storage.remove(wrappedElem);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean rslt = false;
        for (Object elem : c) {
            rslt |= this.remove(elem);
        }
        return rslt;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ToolDefSet wrappedC = new ToolDefSet(c.size());
        for (Object elem : c) {
            wrappedC.add(ToolDefEqWrap.wrap(elem));
        }
        return this.storage.retainAll(wrappedC);
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        txt.append("{");
        for (ToolDefEqWrap<E> elem : this.storage) {
            if (txt.length() > 1) {
                txt.append(", ");
            }
            txt.append(elem.toString());
        }
        txt.append("}");
        return txt.toString();
    }
}

