/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck.symbols;

import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.Position;

public abstract class SymbolEntry {
    public boolean isUsed;
    protected TypeCheckState checkState;
    protected CheckContext ctxt;

    public SymbolEntry(boolean mustBeUsed, CheckContext ctxt) {
        this(mustBeUsed, TypeCheckState.NOT_STARTED, ctxt);
    }

    public SymbolEntry(boolean mustBeUsed, TypeCheckState checkState, CheckContext ctxt) {
        this.isUsed = !mustBeUsed;
        this.checkState = checkState;
        this.ctxt = ctxt;
    }

    protected void declareBusy() {
        Assert.check((this.checkState != TypeCheckState.FULL_CHECK_DONE ? 1 : 0) != 0);
        this.ctxt.declareBusy(this, this.checkState == TypeCheckState.DOING_FULL_CHECK);
        this.checkState = TypeCheckState.DOING_FULL_CHECK;
    }

    protected void declareFinished() {
        this.ctxt.declareFinished(this);
        this.checkState = TypeCheckState.FULL_CHECK_DONE;
    }

    public void setUsed() {
        this.isUsed = true;
    }

    public abstract String getName();

    public abstract Position getPosition();

    public abstract void typeCheckForUse();

    public abstract void fullTypeCheck();

    public abstract void checkUsage(CheckContext var1);

    public boolean useCheckDone() {
        return this.checkState != TypeCheckState.NOT_STARTED;
    }

    protected static enum TypeCheckState {
        NOT_STARTED,
        USE_CHECK_DONE,
        DOING_FULL_CHECK,
        FULL_CHECK_DONE;

    }
}

