/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class XmlSupport {
    private XmlSupport() {
    }

    public static void writeFile(Document doc, String typeName, String absPath) {
        Transformer xmlTrans;
        TransformerFactory xmlTransFactory = TransformerFactory.newInstance();
        try {
            xmlTrans = xmlTransFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        xmlTrans.setOutputProperty("indent", "yes");
        xmlTrans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DocumentType docType = doc.getDoctype();
        if (docType != null) {
            xmlTrans.setOutputProperty("doctype-public", docType.getPublicId());
            xmlTrans.setOutputProperty("doctype-system", docType.getSystemId());
        }
        DOMSource source = new DOMSource(doc);
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (BufferedOutputStream xmlStream = new BufferedOutputStream(new FileOutputStream(absPath));){
                StreamResult result = new StreamResult(xmlStream);
                try {
                    xmlTrans.transform(source, result);
                }
                catch (TransformerException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to write the %s file to \"%s\".", (Object[])new Object[]{typeName, absPath});
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }
}

