/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.DoubleDistribution;
import org.eclipse.escet.chi.runtime.data.random.GammaDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class ErlangDistribution
extends DoubleDistribution {
    private RandomGenerator randGen1;
    private RandomGenerator randGen2;
    private double m;
    private int k;

    public ErlangDistribution(ChiCoordinator chiCoordinator, double m, int k) {
        super(chiCoordinator);
        if (m <= 0.0) {
            String msg = Strings.fmt((String)"The Erlang distribution expects the m parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{m});
            throw new ChiSimulatorException(msg);
        }
        if ((double)k <= 0.0) {
            String msg = Strings.fmt((String)"The Erlang distribution expects the k parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{k});
            throw new ChiSimulatorException(msg);
        }
        this.m = m;
        this.k = k;
        this.randGen1 = chiCoordinator.getFreshGenerator();
        this.randGen2 = chiCoordinator.getFreshGenerator();
    }

    @Override
    public double sample() {
        return ErlangDistribution.drawErlang(this.randGen1, this.randGen2, this.k, this.m);
    }

    public static double drawErlang(RandomGenerator randGen1, RandomGenerator randGen2, int k, double m) {
        return GammaDistribution.drawGamma(randGen1, randGen2, k, m / (double)k);
    }
}

