/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data;

import java.util.Iterator;
import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.IoFunctions;
import org.eclipse.escet.chi.runtime.data.IndexableDeque;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.chi.runtime.data.io.ChiWriteMemoryFile;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class ChiMatrix {
    public final int numRows;
    public final int numColumns;
    private double[] data;

    public ChiMatrix(int numRows, int numColumns) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        Assert.check((this.numRows > 0 ? 1 : 0) != 0);
        Assert.check((this.numColumns > 0 ? 1 : 0) != 0);
        this.data = new double[numRows * numColumns];
    }

    public ChiMatrix(ChiMatrix orig, boolean deepCopy) {
        this.numRows = orig.numRows;
        this.numColumns = orig.numColumns;
        this.data = new double[orig.data.length];
        System.arraycopy(orig.data, 0, this.data, 0, orig.data.length);
    }

    public double get(int r, int c) {
        Assert.check((r >= 0 && r < this.numRows ? 1 : 0) != 0);
        Assert.check((c >= 0 && c < this.numColumns ? 1 : 0) != 0);
        return this.data[c + r * this.numColumns];
    }

    public void set(int r, int c, double val) {
        Assert.check((r >= 0 && r < this.numRows ? 1 : 0) != 0);
        Assert.check((c >= 0 && c < this.numColumns ? 1 : 0) != 0);
        this.data[c + r * this.numColumns] = val;
    }

    public void loadList(IndexableDeque<Double> src) {
        if (this.numRows != 1) {
            String msg = Strings.fmt((String)"Cannot cast to a matrix with %d rows (only 1 row is supported).", (Object[])new Object[]{this.numRows});
            throw new ChiSimulatorException(msg);
        }
        if (this.numColumns != src.size()) {
            String msg = Strings.fmt((String)"Cannot cast a list with %d values to a matrix with %d columns.", (Object[])new Object[]{src.size(), this.numColumns});
            throw new ChiSimulatorException(msg);
        }
        Iterator<Double> iter = src.iterator();
        int c = 0;
        while (c < this.numColumns) {
            this.set(0, c, iter.next());
            ++c;
        }
    }

    public static ChiMatrix read(ChiCoordinator coord, int numRows, int numColumns, ChiFileHandle stream) {
        ChiMatrix mat = new ChiMatrix(numRows, numColumns);
        stream.expectCharacter(91);
        int r = 0;
        while (r < numRows) {
            int c = 0;
            while (c < numColumns) {
                mat.set(r, c, IoFunctions.readReal(stream));
                if (c + 1 < numColumns) {
                    stream.expectCharacter(44);
                }
                ++c;
            }
            if (r + 1 < numRows) {
                stream.expectCharacter(59);
            }
            ++r;
        }
        stream.expectCharacter(93);
        return mat;
    }

    public void write(ChiFileHandle stream) {
        stream.write("[");
        int r = 0;
        while (r < this.numRows) {
            int c = 0;
            while (c < this.numColumns) {
                IoFunctions.writeReal(stream, this.get(r, c));
                if (c + 1 < this.numColumns) {
                    stream.write(", ");
                }
                ++c;
            }
            if (r + 1 < this.numRows) {
                stream.write("; ");
            }
            ++r;
        }
        stream.write("]");
    }

    public String toString() {
        ChiWriteMemoryFile mem = new ChiWriteMemoryFile();
        this.write(mem);
        return mem.getData();
    }

    public int hashCode() {
        int hash = 67 + this.numRows * 13 + this.numColumns * 23;
        int i = 0;
        while (i < this.data.length) {
            hash = (int)((long)hash + Double.doubleToLongBits(this.data[i]) * (long)(i % 16));
            ++i;
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChiMatrix)) {
            return false;
        }
        ChiMatrix cm = (ChiMatrix)other;
        if (cm.numRows != this.numRows || cm.numColumns != this.numColumns) {
            return false;
        }
        int i = 0;
        while (i < this.data.length) {
            if (cm.data[i] != this.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

