/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.spec;

import com.github.javabdd.BDDVarSet;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.BddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.SignedBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedBddBitVector;
import org.eclipse.escet.cif.bdd.spec.CifBddDomain;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class CifBddVariable {
    public final String name;
    public final String rawName;
    public int group = -1;
    public final int count;
    public final int lower;
    public final int upper;
    public CifBddDomain domain;
    public CifBddDomain domainNew;
    public CifBddDomain[] domainsExtra;

    public CifBddVariable(PositionObject obj, int lower, int upper) {
        Assert.check((lower <= upper ? 1 : 0) != 0);
        long count = (long)upper - (long)lower + 1L;
        Assert.check((count > 0L ? 1 : 0) != 0);
        Assert.check((count <= Integer.MAX_VALUE ? 1 : 0) != 0);
        this.name = CifTextUtils.getAbsName((PositionObject)obj);
        this.rawName = CifTextUtils.getAbsName((PositionObject)obj, (boolean)false);
        this.count = (int)count;
        this.lower = lower;
        this.upper = upper;
    }

    public BigInteger getBddDomainSize() {
        return BigInteger.ONE.shiftLeft(this.getBddVarCount());
    }

    public int getBddVarCount() {
        if (this.domain != null) {
            return this.domain.getVarCount();
        }
        if (this.lower < 0) {
            return Math.max(SignedBddBitVector.getMinimumLength(this.lower), SignedBddBitVector.getMinimumLength(this.upper));
        }
        return UnsignedBddBitVector.getMinimumLength(this.upper);
    }

    public BDDVarSet getSupport(boolean includeExtraDomains) {
        BDDVarSet support = this.domain.makeVarSet().unionWith(this.domainNew.makeVarSet());
        if (includeExtraDomains) {
            CifBddDomain[] cifBddDomainArray = this.domainsExtra;
            int n = this.domainsExtra.length;
            int n2 = 0;
            while (n2 < n) {
                CifBddDomain domainExtra = cifBddDomainArray[n2];
                support = support.unionWith(domainExtra.makeVarSet());
                ++n2;
            }
        }
        return support;
    }

    public BddBitVector<?, ?> createBitVector(boolean newDomain) {
        CifBddDomain domain;
        CifBddDomain cifBddDomain = domain = newDomain ? this.domainNew : this.domain;
        if (this.lower < 0) {
            return SignedBddBitVector.createFromDomain(domain);
        }
        return UnsignedBddBitVector.createFromDomain(domain);
    }

    public BddBitVector<?, ?> createBitVectorExtraDomain(int extraDomainIdx) {
        if (this.lower < 0) {
            return SignedBddBitVector.createFromDomain(this.domainsExtra[extraDomainIdx]);
        }
        return UnsignedBddBitVector.createFromDomain(this.domainsExtra[extraDomainIdx]);
    }

    public String toString() {
        return this.toString("Variable: ");
    }

    public abstract String getKindText();

    public abstract String getTypeText();

    public String toString(String prefix) {
        String domainsExtraTxt = this.domainsExtra.length == 0 ? "" : "+" + Arrays.stream(this.domainsExtra).map(d -> Strings.fmt((String)"%,d", (Object[])new Object[]{d.getIndex()})).collect(Collectors.joining("+"));
        return Strings.fmt((String)"%s%s (group: %,d, domain: %,d+%,d%s, BDD variables: %,d, CIF/BDD values: %,d/%,d)", (Object[])new Object[]{prefix, this.toStringInternal(), this.group, this.domain.getIndex(), this.domainNew.getIndex(), domainsExtraTxt, this.domain.getVarCount(), this.count, this.getBddDomainSize()});
    }

    protected abstract String toStringInternal();
}

