/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;

public class ElimTypeDecls
extends CifWalker
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating type declarations from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        EList decls = comp.getDeclarations();
        Iterator declIter = decls.iterator();
        while (declIter.hasNext()) {
            Declaration decl = (Declaration)declIter.next();
            if (!(decl instanceof TypeDecl)) continue;
            declIter.remove();
        }
    }

    protected void postprocessTypeRef(TypeRef typeRef) {
        CifType type = typeRef.getType().getType();
        CifType ntype = CifTypeUtils.normalizeTypeRecursive((CifType)type);
        EMFHelper.updateParentContainment((EObject)typeRef, (EObject)EMFHelper.deepclone((EObject)ntype));
    }
}

