/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.multivaluetrees;

import java.util.TreeSet;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.multivaluetrees.VarInfo;
import org.eclipse.escet.common.multivaluetrees.VarInfoBuilder;
import org.eclipse.escet.common.multivaluetrees.VariableReplacement;

public class VariableReplacementsBuilder<V> {
    public VarInfoBuilder<V> varInfoBuilder;
    private TreeSet<VariableReplacement> replacements;

    public VariableReplacementsBuilder(VarInfoBuilder<V> varInfoBuilder) {
        this.varInfoBuilder = varInfoBuilder;
        this.replacements = new TreeSet();
    }

    public void clear() {
        this.replacements.clear();
    }

    public int size() {
        return this.replacements.size();
    }

    public void addReplacement(V var, int oldUse, int newUse) {
        VarInfo[] varInfos = this.varInfoBuilder.getVarInfos(var);
        Assert.notNull((Object)varInfos[oldUse]);
        Assert.notNull((Object)varInfos[newUse]);
        this.addReplacement(varInfos[oldUse], varInfos[newUse]);
    }

    public void addReplacement(V oldVar, int oldUse, V newVar, int newUse) {
        VarInfo oldInfo = this.varInfoBuilder.getVarInfo(oldVar, oldUse);
        VarInfo newInfo = this.varInfoBuilder.getVarInfo(newVar, newUse);
        this.addReplacement(oldInfo, newInfo);
    }

    public void addReplacement(VarInfo oldInfo, VarInfo newInfo) {
        this.addReplacement(new VariableReplacement(oldInfo, newInfo));
    }

    public void addReplacement(VariableReplacement varRepl) {
        this.replacements.add(varRepl);
    }

    public VariableReplacement[] getReplacements() {
        VariableReplacement[] varRepls = new VariableReplacement[this.replacements.size()];
        varRepls = this.replacements.toArray(varRepls);
        this.clear();
        return varRepls;
    }
}

