/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.chartpart.PlotContent_XY;
import org.knowm.xchart.internal.series.MarkerSeries;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.XYStyler;

public class Cursor
extends MouseAdapter
implements ChartPart {
    private static final int LINE_SPACING = 5;
    private static final int MOUSE_SPACING = 15;
    private final List<DataPoint> dataPointList = new ArrayList<DataPoint>();
    private final List<DataPoint> matchingDataPointList = new ArrayList<DataPoint>();
    private final Chart chart;
    private final XYStyler styler;
    private final Map<String, Series> seriesMap;
    private double mouseX;
    private double mouseY;
    private double startX;
    private double startY;
    private double textHeight;

    public Cursor(Chart chart) {
        this.chart = chart;
        this.styler = (XYStyler)chart.getStyler();
        PlotContent_XY plotContent_xy = (PlotContent_XY)chart.plot.plotContent;
        plotContent_xy.setCursor(this);
        this.dataPointList.clear();
        this.seriesMap = chart.getSeriesMap();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (this.isMouseOutOfPlotContent()) {
            if (this.matchingDataPointList.size() > 0) {
                this.matchingDataPointList.clear();
                e.getComponent().repaint();
            }
            return;
        }
        this.calculateMatchingDataPoints();
        e.getComponent().repaint();
    }

    private boolean isMouseOutOfPlotContent() {
        boolean isMouseOut = false;
        if (!this.chart.plot.plotContent.getBounds().contains(this.mouseX, this.mouseY)) {
            isMouseOut = true;
        }
        return isMouseOut;
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.matchingDataPointList.size() > 0) {
            DataPoint firstDataPoint = this.matchingDataPointList.get(0);
            TextLayout xValueTextLayout = new TextLayout(firstDataPoint.xValue, this.styler.getCursorFont(), new FontRenderContext(null, true, false));
            this.textHeight = xValueTextLayout.getBounds().getHeight();
            this.paintVerticalLine(g, firstDataPoint);
            this.paintBackGround(g, xValueTextLayout);
            this.paintDataPointInfo(g, xValueTextLayout);
        }
    }

    private void paintVerticalLine(Graphics2D g, DataPoint dataPoint) {
        BasicStroke stroke = new BasicStroke(this.styler.getCursorLineWidth(), 0, 0);
        g.setStroke(stroke);
        g.setColor(this.styler.getCursorColor());
        Line2D.Double line = new Line2D.Double();
        line.setLine(dataPoint.x, this.chart.plot.plotContent.getBounds().getY(), dataPoint.x, this.chart.plot.plotContent.getBounds().getY() + this.chart.plot.plotContent.getBounds().getHeight());
        g.draw(line);
    }

    private void paintBackGround(Graphics2D g, TextLayout xValueTextLayout) {
        double maxLinewidth = xValueTextLayout.getBounds().getWidth();
        TextLayout dataPointTextLayout = null;
        Rectangle2D dataPointRectangle = null;
        for (DataPoint dataPoint : this.matchingDataPointList) {
            dataPointTextLayout = new TextLayout(dataPoint.seriesName + ": " + dataPoint.yValue, this.styler.getCursorFont(), new FontRenderContext(null, true, false));
            dataPointRectangle = dataPointTextLayout.getBounds();
            if (!(maxLinewidth < dataPointRectangle.getWidth())) continue;
            maxLinewidth = dataPointRectangle.getWidth();
        }
        double backgroundWidth = (double)this.styler.getCursorFont().getSize() + maxLinewidth + 15.0;
        double backgroundHeight = this.textHeight * (double)(1 + this.matchingDataPointList.size()) + (double)((2 + this.matchingDataPointList.size()) * 5);
        this.startX = this.mouseX;
        this.startY = this.mouseY;
        if (this.mouseX + 15.0 + backgroundWidth > this.chart.plot.plotContent.getBounds().getX() + this.chart.plot.plotContent.getBounds().getWidth()) {
            this.startX = this.mouseX - backgroundWidth - 15.0;
        }
        if (this.mouseY + 15.0 + backgroundHeight > this.chart.plot.plotContent.getBounds().getY() + this.chart.plot.plotContent.getBounds().getHeight()) {
            this.startY = this.mouseY - backgroundHeight - 15.0;
        }
        g.setColor(this.styler.getCursorBackgroundColor());
        g.fillRect((int)this.startX + 15, (int)this.startY + 15, (int)backgroundWidth, (int)backgroundHeight);
    }

    private void paintDataPointInfo(Graphics2D g, TextLayout xValueTextLayout) {
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(this.startX + 15.0 + 5.0, this.startY + this.textHeight + 15.0 + 5.0);
        g.transform(at);
        g.setColor(this.styler.getCursorFontColor());
        g.fill(xValueTextLayout.getOutline(null));
        MarkerSeries series = null;
        TextLayout dataPointTextLayout = null;
        Ellipse2D.Double circle = null;
        for (DataPoint dataPoint : this.matchingDataPointList) {
            at = new AffineTransform();
            at.translate(0.0, this.textHeight + 5.0);
            g.transform(at);
            series = (MarkerSeries)this.seriesMap.get(dataPoint.seriesName);
            if (series == null) continue;
            g.setColor(series.getMarkerColor());
            circle = new Ellipse2D.Double(0.0, -this.textHeight, this.textHeight, this.textHeight);
            g.fill(circle);
            at = new AffineTransform();
            at.translate(this.textHeight + 5.0, 0.0);
            g.transform(at);
            g.setColor(this.styler.getCursorFontColor());
            dataPointTextLayout = new TextLayout(dataPoint.seriesName + ": " + dataPoint.yValue, this.styler.getCursorFont(), new FontRenderContext(null, true, false));
            g.fill(dataPointTextLayout.getOutline(null));
            at = new AffineTransform();
            at.translate(-this.textHeight - 5.0, 0.0);
            g.transform(at);
        }
        g.setTransform(orig);
    }

    void addData(double xOffset, double yOffset, String xValue, String yValue, String seriesName) {
        DataPoint dataPoint = new DataPoint(xOffset, yOffset, xValue, yValue, seriesName);
        this.dataPointList.add(dataPoint);
    }

    private void calculateMatchingDataPoints() {
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        for (DataPoint dataPoint : this.dataPointList) {
            if (!dataPoint.shape.contains(this.mouseX, dataPoint.shape.getBounds().getCenterY()) || !(this.chart.plot.plotContent.getBounds().getY() < this.mouseY) || !(this.chart.plot.plotContent.getBounds().getY() + this.chart.plot.plotContent.getBounds().getHeight() > this.mouseY)) continue;
            dataPoints.add(dataPoint);
        }
        if (dataPoints.size() > 0) {
            HashMap<String, DataPoint> map = new HashMap<String, DataPoint>();
            String seriesName = "";
            for (DataPoint dataPoint : dataPoints) {
                seriesName = dataPoint.seriesName;
                if (map.containsKey(seriesName)) {
                    if (!(Math.abs(dataPoint.x - this.mouseX) < Math.abs(((DataPoint)map.get((Object)seriesName)).x - this.mouseX))) continue;
                    map.put(seriesName, dataPoint);
                    continue;
                }
                map.put(seriesName, dataPoint);
            }
            this.matchingDataPointList.clear();
            this.matchingDataPointList.addAll(map.values());
        }
    }

    private static class DataPoint {
        private static final int MARGIN = 5;
        final Shape shape;
        final double x;
        final double y;
        final String xValue;
        final String yValue;
        final String seriesName;

        public DataPoint(double x, double y, String xValue, String yValue, String seriesName) {
            double halfSize = 7.5;
            double markerSize = 15.0;
            this.x = x;
            this.y = y;
            this.shape = new Ellipse2D.Double(this.x - halfSize, this.y - halfSize, markerSize, markerSize);
            this.xValue = xValue;
            this.yValue = yValue;
            this.seriesName = seriesName;
        }
    }
}

