/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.builders;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.exceptions.ApplicationException;

public class LocationExplorer<V>
implements Iterable<Location> {
    public final Automaton autom;
    private Map<Location, V> destLocs = Maps.map();
    protected Queue<Location> unfinished = new ArrayDeque<Location>();

    public LocationExplorer(Automaton autom) {
        this.autom = autom;
    }

    public void addInitialLocation(V value) {
        if (this.autom.initial != null) {
            this.destLocs.put(this.autom.initial, value);
            this.unfinished.add(this.autom.initial);
        }
    }

    public void addMarkedLocations(V value) {
        for (Location loc : this.autom) {
            if (!loc.marked) continue;
            this.destLocs.put(loc, value);
            this.unfinished.add(loc);
        }
    }

    public void addValue(Location loc, V value, boolean checkNew) {
        V old = this.destLocs.put(loc, value);
        this.unfinished.add(loc);
        if (!checkNew || old != null) {
            return;
        }
        throw new ApplicationException("Double assignment to a location.");
    }

    public boolean locationHasValue(Location loc) {
        return this.destLocs.containsKey(loc);
    }

    public V getValue(Location loc) {
        return this.destLocs.get(loc);
    }

    @Override
    public Iterator<Location> iterator() {
        return new UnfinishedIterator();
    }

    final class UnfinishedIterator
    implements Iterator<Location> {
        UnfinishedIterator() {
        }

        @Override
        public boolean hasNext() {
            return !LocationExplorer.this.unfinished.isEmpty();
        }

        @Override
        public Location next() {
            return LocationExplorer.this.unfinished.remove();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

