/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.updates.tree;

import org.eclipse.escet.cif.codegen.updates.tree.LhsProjection;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class LhsTupleProjection
extends LhsProjection {
    public final TupleType tupleType;
    public final int fieldNumber;

    public LhsTupleProjection(TupleType tupleType, Expression index) {
        this.tupleType = tupleType;
        this.fieldNumber = LhsTupleProjection.getTupleFieldIndex(index);
    }

    @Override
    public CifType getContainerType() {
        return this.tupleType;
    }

    @Override
    public CifType getPartType() {
        return ((Field)this.tupleType.getFields().get(this.fieldNumber)).getType();
    }

    public String getSelectedFieldName() {
        return ((Field)this.tupleType.getFields().get(this.fieldNumber)).getName();
    }

    private static int getTupleFieldIndex(Expression indexExpr) {
        int idx;
        if (indexExpr instanceof FieldExpression) {
            FieldExpression fieldExpr = (FieldExpression)indexExpr;
            Field field = fieldExpr.getField();
            TupleType tupleType = (TupleType)field.eContainer();
            int idx2 = tupleType.getFields().indexOf((Object)field);
            Assert.check((idx2 >= 0 ? 1 : 0) != 0);
            return idx2;
        }
        try {
            idx = (Integer)CifEvalUtils.eval((Expression)indexExpr, (boolean)false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
        Assert.check((idx >= 0 ? 1 : 0) != 0);
        return idx;
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"TupleProject(field#%d)", (Object[])new Object[]{this.fieldNumber});
    }
}

