/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks.invcheck;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.PlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.SubSetRelation;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DisallowedInvariantsSubset {
    private final NoInvariantSupKind noSupKind;
    private final NoInvariantKind noInvKind;
    private final NoInvariantPlaceKind noPlaceKind;

    public DisallowedInvariantsSubset(NoInvariantSupKind noSupKind, NoInvariantKind noInvKind, NoInvariantPlaceKind noPlaceKind) {
        this.noSupKind = noSupKind;
        this.noInvKind = noInvKind;
        this.noPlaceKind = noPlaceKind;
    }

    public boolean isDisallowed(SupKind supKind, InvKind invKind, PlaceKind placeKind) {
        return this.noSupKind.isDisallowed(supKind) && this.noInvKind.isDisallowed(invKind) && this.noPlaceKind.isDisallowed(placeKind);
    }

    public void addViolation(Invariant inv, CifCheckViolations violations) {
        List texts = Lists.list();
        if (this.noSupKind.getReportText() != null) {
            texts.add(this.noSupKind.getReportText());
        }
        if (this.noInvKind.getReportText() != null) {
            texts.add(this.noInvKind.getReportText());
        }
        texts.add("invariant");
        if (this.noPlaceKind.getReportText() != null) {
            texts.add(this.noPlaceKind.getReportText());
        }
        if (texts.size() == 1) {
            violations.add((PositionObject)inv, "An invariant is used", new Object[0]);
        } else {
            String article = this.noSupKind.getReportText() == null && this.noInvKind.getReportText() == null ? "an" : "a";
            violations.add((PositionObject)inv, Strings.fmt((String)"Invariant is %s %s", (Object[])new Object[]{article, texts.stream().collect(Collectors.joining(" "))}), new Object[0]);
        }
    }

    public SubSetRelation compareSubset(DisallowedInvariantsSubset right) {
        SubSetRelation noSupKindRelation = this.noSupKind.compareSubset(right.noSupKind);
        SubSetRelation noInvKindRelation = this.noInvKind.compareSubset(right.noInvKind);
        SubSetRelation noPlaceKindRelation = this.noPlaceKind.compareSubset(right.noPlaceKind);
        return SubSetRelation.getRelation(noSupKindRelation.leftLarger || noInvKindRelation.leftLarger || noPlaceKindRelation.leftLarger, noSupKindRelation.rightLarger || noInvKindRelation.rightLarger || noPlaceKindRelation.rightLarger);
    }
}

