/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.BitSet;
import java.util.List;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.checkers.checks.invcheck.DisallowedInvariantsSubset;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.PlaceKind;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class InvNoSpecificInvsCheck
extends CifCheck {
    private List<List<DisallowedInvariantsSubset>> disallowedSubsets;
    private boolean ignoreNeverBlockingInvariants = false;

    public InvNoSpecificInvsCheck() {
        int numEntries = NoInvariantSupKind.NUMBER_OF_VALUES * NoInvariantKind.NUMBER_OF_VALUES * NoInvariantPlaceKind.NUMBER_OF_VALUES;
        this.disallowedSubsets = Lists.listc((int)numEntries);
        int i = 0;
        while (i < numEntries) {
            this.disallowedSubsets.add(null);
            ++i;
        }
    }

    public InvNoSpecificInvsCheck disallow(NoInvariantSupKind noSupKind, NoInvariantKind noInvKind, NoInvariantPlaceKind noPlaceKind) {
        DisallowedInvariantsSubset disallowedInvs = new DisallowedInvariantsSubset(noSupKind, noInvKind, noPlaceKind);
        SupKind[] supKindArray = SupKind.values();
        int n = supKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            SupKind supKind = supKindArray[n2];
            if (noSupKind.isDisallowed(supKind)) {
                InvKind[] invKindArray = InvKind.values();
                int n3 = invKindArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InvKind invKind = invKindArray[n4];
                    if (noInvKind.isDisallowed(invKind)) {
                        PlaceKind[] placeKindArray = PlaceKind.values();
                        int n5 = placeKindArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            PlaceKind placeKind = placeKindArray[n6];
                            if (noPlaceKind.isDisallowed(placeKind)) {
                                int index = this.computeIndex(supKind, invKind, placeKind);
                                List<DisallowedInvariantsSubset> currentReports = this.disallowedSubsets.get(index);
                                if (currentReports == null) {
                                    this.disallowedSubsets.set(index, Lists.list((Object)disallowedInvs));
                                } else {
                                    this.updateDisallowedSets(currentReports, disallowedInvs);
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return this;
    }

    private void updateDisallowedSets(List<DisallowedInvariantsSubset> currentSets, DisallowedInvariantsSubset newSet) {
        Assert.check((!currentSets.isEmpty() ? 1 : 0) != 0);
        BitSet keepExistingIndices = new BitSet(currentSets.size());
        int index = 0;
        for (DisallowedInvariantsSubset right : currentSets) {
            switch (newSet.compareSubset(right)) {
                case EQUAL: {
                    return;
                }
                case RIGHT_LARGER: {
                    return;
                }
                case LEFT_LARGER: {
                    break;
                }
                case BOTH_LARGER: {
                    keepExistingIndices.set(index);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected comparison result found.");
                }
            }
            ++index;
        }
        int freeIndex = 0;
        index = 0;
        while (index < currentSets.size()) {
            if (keepExistingIndices.get(index)) {
                if (freeIndex < index) {
                    currentSets.set(freeIndex, currentSets.get(index));
                }
                ++freeIndex;
            }
            ++index;
        }
        if (freeIndex == currentSets.size()) {
            currentSets.add(newSet);
        } else {
            currentSets.set(freeIndex, newSet);
            ++freeIndex;
            int currentSize = currentSets.size();
            while (freeIndex < currentSize) {
                currentSets.remove(--currentSize);
            }
        }
    }

    public InvNoSpecificInvsCheck ignoreNeverBlockingInvariants() {
        return this.ignoreNeverBlockingInvariants(true);
    }

    public InvNoSpecificInvsCheck ignoreNeverBlockingInvariants(boolean ignore) {
        this.ignoreNeverBlockingInvariants = ignore;
        return this;
    }

    protected void preprocessInvariant(Invariant inv, CifCheckViolations violations) {
        int index;
        List<DisallowedInvariantsSubset> subsets;
        PlaceKind placeKind;
        SupKind supKind = inv.getSupKind();
        InvKind invKind = inv.getInvKind();
        PlaceKind placeKind2 = placeKind = inv.eContainer() instanceof Location ? PlaceKind.LOCATION : PlaceKind.COMPONENT;
        if (this.ignoreNeverBlockingInvariants) {
            switch (invKind) {
                case EVENT_DISABLES: {
                    if (!CifValueUtils.isTriviallyFalse((Expression)inv.getPredicate(), (boolean)false, (boolean)true)) break;
                    return;
                }
                case STATE: 
                case EVENT_NEEDS: {
                    if (!CifValueUtils.isTriviallyTrue((Expression)inv.getPredicate(), (boolean)false, (boolean)true)) break;
                    return;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected invariant kind found.");
                }
            }
        }
        if ((subsets = this.disallowedSubsets.get(index = this.computeIndex(supKind, invKind, placeKind))) != null) {
            for (DisallowedInvariantsSubset subset : subsets) {
                subset.addViolation(inv, violations);
            }
        }
    }

    private int computeIndex(SupKind supKind, InvKind invKind, PlaceKind placeKind) {
        return placeKind.ordinal() + NoInvariantPlaceKind.NUMBER_OF_VALUES * (invKind.ordinal() + NoInvariantKind.NUMBER_OF_VALUES * supKind.ordinal());
    }
}

