/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FuncNoSpecificStdLibCheck
extends CifCheck {
    private final EnumSet<NoSpecificStdLib> disalloweds;
    private boolean ignoreAnnotations;

    public FuncNoSpecificStdLibCheck(EnumSet<NoSpecificStdLib> disalloweds) {
        this.disalloweds = disalloweds;
    }

    public FuncNoSpecificStdLibCheck(NoSpecificStdLib ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public FuncNoSpecificStdLibCheck ignoreAnnotations() {
        return this.ignoreAnnotations(true);
    }

    public FuncNoSpecificStdLibCheck ignoreAnnotations(boolean ignore) {
        this.ignoreAnnotations = ignore;
        return this;
    }

    protected void preprocessStdLibFunctionExpression(StdLibFunctionExpression stdLibRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)stdLibRef)) {
            return;
        }
        StdLibFunction func = stdLibRef.getFunction();
        FunctionCallExpression funcCallExpr = (FunctionCallExpression)stdLibRef.eContainer();
        List<CifType> argTypes = funcCallExpr.getArguments().stream().map(arg -> CifTypeUtils.normalizeType((CifType)arg.getType())).toList();
        switch (func) {
            case ABS: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS_INT)) {
                        if (argTypes.get(0) instanceof IntType) {
                            this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                        }
                    } else {
                        IntType itype;
                        CifType cifType;
                        IntType itype2;
                        CifType cifType2;
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS_INT_RANGED) && (cifType2 = argTypes.get(0)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype2 = (IntType)cifType2))) {
                            this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS_INT_RANGELESS) && (cifType = argTypes.get(0)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype = (IntType)cifType))) {
                            this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS_REAL) && argTypes.get(0) instanceof RealType) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case ACOS: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ACOS)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case ACOSH: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ACOSH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case ASIN: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ASIN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case ASINH: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ASINH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case ATAN: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ATAN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case ATANH: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ATANH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case BERNOULLI: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.BERNOULLI)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case BETA: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.BETA)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case BINOMIAL: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.BINOMIAL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case CBRT: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.CBRT)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case CEIL: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.CEIL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case CONSTANT: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.CONSTANT)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.CONSTANT_BOOL) && argTypes.get(0) instanceof BoolType) {
                        this.addExprViolationArgument(stdLibRef, "a boolean typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.CONSTANT_INT) && argTypes.get(0) instanceof IntType) {
                        this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.CONSTANT_REAL) && argTypes.get(0) instanceof RealType) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case COS: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.COS)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case COSH: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.COSH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case DELETE: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    IntType itype;
                    CifType cifType;
                    IntType itype3;
                    CifType cifType3;
                    ListType ltype;
                    CifType cifType4;
                    ListType ltype2;
                    CifType cifType5;
                    Assert.areEqual((Object)argTypes.size(), (Object)2);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE_LIST_ARRAY) && (cifType5 = argTypes.get(0)) instanceof ListType && CifTypeUtils.isArrayType((ListType)(ltype2 = (ListType)cifType5))) {
                        this.addExprViolationArgument(stdLibRef, "an array list typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE_LIST_NON_ARRAY) && (cifType4 = argTypes.get(0)) instanceof ListType && !CifTypeUtils.isArrayType((ListType)(ltype = (ListType)cifType4))) {
                        this.addExprViolationArgument(stdLibRef, "a non-array list typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE_INT_RANGED) && (cifType3 = argTypes.get(1)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype3 = (IntType)cifType3))) {
                        this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE_INT_RANGELESS) && (cifType = argTypes.get(1)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype = (IntType)cifType))) {
                        this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                    }
                }
                return;
            }
            case EMPTY: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_LIST)) {
                        if (argTypes.get(0) instanceof ListType) {
                            this.addExprViolationArgument(stdLibRef, "a list typed", violations);
                        }
                    } else {
                        ListType ltype;
                        CifType cifType;
                        ListType ltype3;
                        CifType cifType6;
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_LIST_ARRAY) && (cifType6 = argTypes.get(0)) instanceof ListType && CifTypeUtils.isArrayType((ListType)(ltype3 = (ListType)cifType6))) {
                            this.addExprViolationArgument(stdLibRef, "an array list typed", violations);
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_LIST_NON_ARRAY) && (cifType = argTypes.get(0)) instanceof ListType && !CifTypeUtils.isArrayType((ListType)(ltype = (ListType)cifType))) {
                            this.addExprViolationArgument(stdLibRef, "a non-array list typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_SET) && argTypes.get(0) instanceof SetType) {
                        this.addExprViolationArgument(stdLibRef, "a set typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_DICT) && argTypes.get(0) instanceof DictType) {
                        this.addExprViolationArgument(stdLibRef, "a dictionary typed", violations);
                    }
                }
                return;
            }
            case ERLANG: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.ERLANG)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case EXP: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.EXP)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case EXPONENTIAL: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.EXPONENTIAL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case FLOOR: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.FLOOR)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case FORMAT: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.FORMAT)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case GAMMA: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.GAMMA)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case GEOMETRIC: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.GEOMETRIC)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case LN: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.LN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case LOG: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.LOG)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case LOG_NORMAL: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.LOG_NORMAL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case MAXIMUM: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)2);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM_INT)) {
                        if (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType) {
                            this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                        }
                    } else {
                        IntType itype2;
                        CifType cifType;
                        IntType itype1;
                        CifType cifType7;
                        IntType itype22;
                        CifType cifType8;
                        IntType itype12;
                        CifType cifType9;
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM_INT_RANGED) && ((cifType9 = argTypes.get(0)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype12 = (IntType)cifType9)) || (cifType8 = argTypes.get(1)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype22 = (IntType)cifType8)))) {
                            this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM_INT_RANGELESS) && ((cifType7 = argTypes.get(0)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype1 = (IntType)cifType7)) || (cifType = argTypes.get(1)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype2 = (IntType)cifType)))) {
                            this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType)) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case MINIMUM: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)2);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM_INT)) {
                        if (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType) {
                            this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                        }
                    } else {
                        IntType itype2;
                        CifType cifType;
                        IntType itype1;
                        CifType cifType10;
                        IntType itype23;
                        CifType cifType11;
                        IntType itype13;
                        CifType cifType12;
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM_INT_RANGED) && ((cifType12 = argTypes.get(0)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype13 = (IntType)cifType12)) || (cifType11 = argTypes.get(1)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype23 = (IntType)cifType11)))) {
                            this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM_INT_RANGELESS) && ((cifType10 = argTypes.get(0)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype1 = (IntType)cifType10)) || (cifType = argTypes.get(1)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype2 = (IntType)cifType)))) {
                            this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType)) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case NORMAL: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.NORMAL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case POISSON: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.POISSON)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case POP: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.POP)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    ListType ltype;
                    CifType cifType;
                    ListType ltype4;
                    CifType cifType13;
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.POP_ARRAY) && (cifType13 = argTypes.get(0)) instanceof ListType && CifTypeUtils.isArrayType((ListType)(ltype4 = (ListType)cifType13))) {
                        this.addExprViolationArgument(stdLibRef, "an array list typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.POP_NON_ARRAY) && (cifType = argTypes.get(0)) instanceof ListType && !CifTypeUtils.isArrayType((ListType)(ltype = (ListType)cifType))) {
                        this.addExprViolationArgument(stdLibRef, "a non-array list typed", violations);
                    }
                }
                return;
            }
            case POWER: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.POWER)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)2);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.POWER_INT)) {
                        if (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType) {
                            this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                        }
                    } else {
                        IntType itype2;
                        CifType cifType;
                        IntType itype1;
                        CifType cifType14;
                        IntType itype24;
                        CifType cifType15;
                        IntType itype14;
                        CifType cifType16;
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.POWER_INT_RANGED) && ((cifType16 = argTypes.get(0)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype14 = (IntType)cifType16)) || (cifType15 = argTypes.get(1)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype24 = (IntType)cifType15)))) {
                            this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.POWER_INT_RANGELESS) && ((cifType14 = argTypes.get(0)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype1 = (IntType)cifType14)) || (cifType = argTypes.get(1)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype2 = (IntType)cifType)))) {
                            this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.POWER_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType)) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case RANDOM: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.RANDOM)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case ROUND: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ROUND)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case SCALE: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.SCALE)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)5);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SCALE_INT)) {
                        if (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType || argTypes.get(2) instanceof IntType || argTypes.get(3) instanceof IntType || argTypes.get(4) instanceof IntType) {
                            this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                        }
                    } else {
                        IntType itype4;
                        CifType cifType;
                        IntType itype3;
                        CifType cifType17;
                        IntType itype2;
                        CifType cifType18;
                        IntType itype1;
                        CifType cifType19;
                        IntType itype0;
                        CifType cifType20;
                        IntType itype42;
                        CifType cifType21;
                        IntType itype32;
                        CifType cifType22;
                        IntType itype25;
                        CifType cifType23;
                        IntType itype15;
                        CifType cifType24;
                        IntType itype02;
                        CifType cifType25;
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SCALE_INT_RANGED) && ((cifType25 = argTypes.get(0)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype02 = (IntType)cifType25)) || (cifType24 = argTypes.get(1)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype15 = (IntType)cifType24)) || (cifType23 = argTypes.get(2)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype25 = (IntType)cifType23)) || (cifType22 = argTypes.get(3)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype32 = (IntType)cifType22)) || (cifType21 = argTypes.get(4)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype42 = (IntType)cifType21)))) {
                            this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SCALE_INT_RANGELESS) && ((cifType20 = argTypes.get(0)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype0 = (IntType)cifType20)) || (cifType19 = argTypes.get(1)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype1 = (IntType)cifType19)) || (cifType18 = argTypes.get(2)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype2 = (IntType)cifType18)) || (cifType17 = argTypes.get(3)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype3 = (IntType)cifType17)) || (cifType = argTypes.get(4)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype4 = (IntType)cifType)))) {
                            this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SCALE_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType || argTypes.get(2) instanceof RealType || argTypes.get(3) instanceof RealType || argTypes.get(4) instanceof RealType)) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case SIGN: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN_INT)) {
                        if (argTypes.get(0) instanceof IntType) {
                            this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                        }
                    } else {
                        IntType itype;
                        CifType cifType;
                        IntType itype4;
                        CifType cifType26;
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN_INT_RANGED) && (cifType26 = argTypes.get(0)) instanceof IntType && !CifTypeUtils.isRangeless((IntType)(itype4 = (IntType)cifType26))) {
                            this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN_INT_RANGELESS) && (cifType = argTypes.get(0)) instanceof IntType && CifTypeUtils.isRangeless((IntType)(itype = (IntType)cifType))) {
                            this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN_REAL) && argTypes.get(0) instanceof RealType) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case SIN: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.SIN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case SINH: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.SINH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case SIZE: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_STRING) && argTypes.get(0) instanceof StringType) {
                        this.addExprViolationArgument(stdLibRef, "a string typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_LIST)) {
                        if (argTypes.get(0) instanceof ListType) {
                            this.addExprViolationArgument(stdLibRef, "a list typed", violations);
                        }
                    } else {
                        ListType ltype;
                        CifType cifType;
                        ListType ltype5;
                        CifType cifType27;
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_LIST_ARRAY) && (cifType27 = argTypes.get(0)) instanceof ListType && CifTypeUtils.isArrayType((ListType)(ltype5 = (ListType)cifType27))) {
                            this.addExprViolationArgument(stdLibRef, "an array list typed", violations);
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_LIST_NON_ARRAY) && (cifType = argTypes.get(0)) instanceof ListType && !CifTypeUtils.isArrayType((ListType)(ltype = (ListType)cifType))) {
                            this.addExprViolationArgument(stdLibRef, "a non-array list typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_SET) && argTypes.get(0) instanceof SetType) {
                        this.addExprViolationArgument(stdLibRef, "a set typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_DICT) && argTypes.get(0) instanceof DictType) {
                        this.addExprViolationArgument(stdLibRef, "a dictionary typed", violations);
                    }
                }
                return;
            }
            case SQRT: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.SQRT)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case TAN: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.TAN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case TANH: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.TANH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case TRIANGLE: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.TRIANGLE)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case UNIFORM: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.UNIFORM)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)2);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.UNIFORM_INT) && (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType)) {
                        this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.UNIFORM_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType)) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case WEIBULL: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.WEIBULL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
        }
        throw new AssertionError((Object)("Unknown std lib function: " + String.valueOf(func)));
    }

    private void addExprViolationFunction(StdLibFunctionExpression stdLibExpr, CifCheckViolations violations) {
        violations.add((PositionObject)stdLibExpr, "Standard library function \"%s\" is used", CifTextUtils.functionToStr((StdLibFunction)stdLibExpr.getFunction()));
    }

    private void addExprViolationArgument(StdLibFunctionExpression stdLibExpr, String argTxt, CifCheckViolations violations) {
        violations.add((PositionObject)stdLibExpr, "Standard library function \"%s\" is used on %s argument", CifTextUtils.functionToStr((StdLibFunction)stdLibExpr.getFunction()), argTxt);
    }

    public static enum NoSpecificStdLib {
        ALL_TRIGONOMETRY,
        ALL_STOCHASTIC,
        ABS,
        ABS_INT,
        ABS_INT_RANGED,
        ABS_INT_RANGELESS,
        ABS_REAL,
        ACOS,
        ACOSH,
        ASIN,
        ASINH,
        ATAN,
        ATANH,
        BERNOULLI,
        BETA,
        BINOMIAL,
        CBRT,
        CEIL,
        CONSTANT,
        CONSTANT_BOOL,
        CONSTANT_INT,
        CONSTANT_REAL,
        COS,
        COSH,
        DELETE,
        DELETE_LIST_ARRAY,
        DELETE_LIST_NON_ARRAY,
        DELETE_INT_RANGED,
        DELETE_INT_RANGELESS,
        EMPTY,
        EMPTY_LIST,
        EMPTY_LIST_ARRAY,
        EMPTY_LIST_NON_ARRAY,
        EMPTY_SET,
        EMPTY_DICT,
        ERLANG,
        EXP,
        EXPONENTIAL,
        FLOOR,
        FORMAT,
        GAMMA,
        GEOMETRIC,
        LN,
        LOG,
        LOG_NORMAL,
        MAXIMUM,
        MAXIMUM_INT,
        MAXIMUM_INT_RANGED,
        MAXIMUM_INT_RANGELESS,
        MAXIMUM_REAL,
        MINIMUM,
        MINIMUM_INT,
        MINIMUM_INT_RANGED,
        MINIMUM_INT_RANGELESS,
        MINIMUM_REAL,
        NORMAL,
        POISSON,
        POP,
        POP_ARRAY,
        POP_NON_ARRAY,
        POWER,
        POWER_INT,
        POWER_INT_RANGED,
        POWER_INT_RANGELESS,
        POWER_REAL,
        RANDOM,
        ROUND,
        SCALE,
        SCALE_INT,
        SCALE_INT_RANGED,
        SCALE_INT_RANGELESS,
        SCALE_REAL,
        SIGN,
        SIGN_INT,
        SIGN_INT_RANGED,
        SIGN_INT_RANGELESS,
        SIGN_REAL,
        SIN,
        SINH,
        SIZE,
        SIZE_STRING,
        SIZE_LIST,
        SIZE_LIST_ARRAY,
        SIZE_LIST_NON_ARRAY,
        SIZE_SET,
        SIZE_DICT,
        SQRT,
        TAN,
        TANH,
        TRIANGLE,
        UNIFORM,
        UNIFORM_INT,
        UNIFORM_REAL,
        WEIBULL;

    }
}

