/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class UniformRealDistribution
extends RealDistribution {
    private final CifRandomGenerator randGen;
    private final double lower;
    private final double upper;

    public UniformRealDistribution(CifRandomGenerator randGen, double lower, double upper) {
        this.randGen = randGen;
        this.lower = lower;
        this.upper = upper;
        if (lower >= upper) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The lower bound (the first parameter) is not smaller than the upper bound (the second parameter).";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private UniformRealDistribution(UniformRealDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.lower = distribution.lower;
        this.upper = distribution.upper;
    }

    @Override
    public RealDistribution copy() {
        return new UniformRealDistribution(this);
    }

    @Override
    public double sample() {
        double range = this.upper - this.lower;
        return this.lower + range * this.randGen.draw();
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"uniform(%s, %s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.lower), CifSimulatorMath.realToStr(this.upper)});
    }
}

