/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.input;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.InteractiveGuiInputChoice;
import org.eclipse.escet.cif.simulator.input.InteractiveGuiInputEditor;
import org.eclipse.escet.cif.simulator.input.InteractiveInputComponent;
import org.eclipse.escet.cif.simulator.options.CifSpecOption;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEvent;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.HistoryTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.ResetTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.cif.simulator.runtime.transitions.UndoTransition;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.swt.widgets.Display;

public final class InteractiveGuiInputComponent<S extends RuntimeState>
extends InteractiveInputComponent<S> {
    private boolean doInteractive = false;
    private InteractiveGuiInputEditor<S> gui = null;
    private boolean targetTimeAvailable = false;
    private ChosenTargetTime lastTargetTime = null;

    public InteractiveGuiInputComponent(RuntimeSpec<S> spec) {
        super(spec);
    }

    @Override
    public void init() {
        super.init();
        if (!this.autoTime) {
            this.doInteractive = true;
        }
        if (!this.autoTimeDur) {
            this.doInteractive = true;
        }
        int i = 0;
        while (i < this.autoEvents.length) {
            if (!this.autoEvents[i]) {
                boolean isTau;
                boolean bl = isTau = i == this.autoEvents.length - 1;
                if (!isTau || this.spec.hasTauEdge()) {
                    this.doInteractive = true;
                    break;
                }
            }
            ++i;
        }
        if (this.isResetEnabled) {
            this.doInteractive = true;
        }
        if (this.isUndoEnabled) {
            this.doInteractive = true;
        }
        if (this.doInteractive) {
            String path = CifSpecOption.getCifSpecPath();
            this.gui = (InteractiveGuiInputEditor)ControlEditor.show((String)path, InteractiveGuiInputEditor.class, (String)"show the GUI input component");
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!InteractiveGuiInputComponent.this.gui.isAvailable()) {
                        return;
                    }
                    InteractiveGuiInputComponent.this.gui.init(InteractiveGuiInputComponent.this.spec, InteractiveGuiInputComponent.this);
                }
            });
        }
    }

    @Override
    protected boolean needAutomaticInputComponent() {
        return true;
    }

    @Override
    protected Transition<S> chooseTransitionInteractive(S state, List<Transition<S>> transitions) {
        Assert.check((boolean)this.doInteractive);
        this.targetTimeAvailable = false;
        this.lastTargetTime = null;
        Display.getDefault().syncExec(new Runnable((RuntimeState)state, transitions){
            private final /* synthetic */ RuntimeState val$state;
            private final /* synthetic */ List val$transitions;
            {
                this.val$state = runtimeState;
                this.val$transitions = list;
            }

            @Override
            public void run() {
                InteractiveGuiInputComponent.this.gui.choice.set(null);
                if (!InteractiveGuiInputComponent.this.gui.isAvailable()) {
                    InteractiveGuiInputComponent.this.gui.ready.set(true);
                    return;
                }
                InteractiveGuiInputComponent.this.gui.ready.set(false);
                InteractiveGuiInputComponent.this.gui.chooseTransition(this.val$state, this.val$transitions);
            }
        });
        this.waitForChoice();
        if (!this.gui.isAvailable()) {
            throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
        }
        InteractiveGuiInputChoice choice = this.gui.choice.get();
        if (!choice.hasTransitionChoice()) {
            throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
        }
        if (choice.resetChosen) {
            RuntimeState target = this.history.reset();
            return new ResetTransition<RuntimeState>((RuntimeState)state, target);
        }
        if (choice.undoCount > 0) {
            RuntimeState target = this.history.undo(choice.undoCount);
            return new UndoTransition<RuntimeState>((RuntimeState)state, target, choice.undoCount);
        }
        if (choice.transIdx != -1) {
            Assert.check((!choice.timeChosen ? 1 : 0) != 0);
            return transitions.get(choice.transIdx);
        }
        List autoTrans = Lists.listc((int)transitions.size());
        for (Transition<S> transition : transitions) {
            if (transition instanceof EventTransition) {
                RuntimeEvent event = ((EventTransition)transition).event;
                if (event.idx != choice.eventIdx) continue;
                autoTrans.add(transition);
                continue;
            }
            if (transition instanceof TimeTransition) {
                if (!choice.timeChosen) continue;
                Assert.check((!this.targetTimeAvailable ? 1 : 0) != 0);
                this.targetTimeAvailable = true;
                this.lastTargetTime = choice.targetTime;
                autoTrans.add(transition);
                continue;
            }
            throw new RuntimeException("Unknown trans: " + String.valueOf(transition));
        }
        Assert.check((!autoTrans.isEmpty() ? 1 : 0) != 0);
        if (autoTrans.size() == 1) {
            return (Transition)Lists.first((List)autoTrans);
        }
        return this.autoInput.chooseTransition(state, autoTrans, null);
    }

    @Override
    protected HistoryTransition<S> chooseTransitionInteractive(S state, SimulationResult result) {
        Assert.check((boolean)this.doInteractive);
        this.targetTimeAvailable = false;
        this.lastTargetTime = null;
        Display.getDefault().syncExec(new Runnable((RuntimeState)state){
            private final /* synthetic */ RuntimeState val$state;
            {
                this.val$state = runtimeState;
            }

            @Override
            public void run() {
                InteractiveGuiInputComponent.this.gui.choice.set(null);
                if (!InteractiveGuiInputComponent.this.gui.isAvailable()) {
                    InteractiveGuiInputComponent.this.gui.ready.set(true);
                    return;
                }
                InteractiveGuiInputComponent.this.gui.ready.set(false);
                InteractiveGuiInputComponent.this.gui.chooseNoTransition(this.val$state);
            }
        });
        this.waitForChoice();
        if (!this.gui.isAvailable()) {
            throw new SimulatorExitException(result);
        }
        InteractiveGuiInputChoice choice = this.gui.choice.get();
        if (!choice.hasNoTransitionChoice()) {
            throw new SimulatorExitException(result);
        }
        if (choice.resetChosen) {
            RuntimeState target = this.history.reset();
            return new ResetTransition<RuntimeState>((RuntimeState)state, target);
        }
        if (choice.undoCount > 0) {
            RuntimeState target = this.history.undo(choice.undoCount);
            return new UndoTransition<RuntimeState>((RuntimeState)state, target, choice.undoCount);
        }
        throw new RuntimeException("Unhandled choice.");
    }

    @Override
    protected ChosenTargetTime chooseTargetTimeInteractive(S state, double maxTargetTime) {
        Assert.check((boolean)this.doInteractive);
        if (this.targetTimeAvailable) {
            ChosenTargetTime rslt = this.lastTargetTime;
            this.targetTimeAvailable = false;
            this.lastTargetTime = null;
            if (rslt != null) {
                return rslt;
            }
            return this.autoInput.chooseTargetTime(state, maxTargetTime);
        }
        Display.getDefault().syncExec(new Runnable((RuntimeState)state, maxTargetTime){
            private final /* synthetic */ RuntimeState val$state;
            private final /* synthetic */ double val$maxTargetTime;
            {
                this.val$state = runtimeState;
                this.val$maxTargetTime = d;
            }

            @Override
            public void run() {
                InteractiveGuiInputComponent.this.gui.choice.set(null);
                if (!InteractiveGuiInputComponent.this.gui.isAvailable()) {
                    InteractiveGuiInputComponent.this.gui.ready.set(true);
                    return;
                }
                InteractiveGuiInputComponent.this.gui.ready.set(false);
                InteractiveGuiInputComponent.this.gui.chooseDelay(this.val$state, this.val$maxTargetTime);
            }
        });
        this.waitForChoice();
        if (!this.gui.isAvailable()) {
            throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
        }
        InteractiveGuiInputChoice choice = this.gui.choice.get();
        if (!choice.hasDelayChoice()) {
            throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
        }
        if (choice.targetTime != null) {
            return choice.targetTime;
        }
        return this.autoInput.chooseTargetTime(state, maxTargetTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForChoice() {
        AtomicBoolean atomicBoolean = this.gui.ready;
        synchronized (atomicBoolean) {
            while (!this.gui.ready.get()) {
                try {
                    this.gui.ready.wait(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                try {
                    this.spec.ctxt.checkTermination();
                }
                catch (SimulatorExitException e) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            InteractiveGuiInputComponent.this.gui.resetAndDisableUI();
                        }
                    });
                    throw e;
                }
            }
        }
    }
}

