/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.functions.AFuncParam;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.FunctionScope;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class FuncParamDeclWrap
extends DeclWrap<FunctionParameter> {
    private final AFuncParam astDecl;

    public FuncParamDeclWrap(CifTypeChecker tchecker, FunctionScope scope, AFuncParam astDecl, FunctionParameter mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((FunctionParameter)this.mmDecl).getParameter().getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)((FunctionParameter)this.mmDecl).getParameter());
    }

    @Override
    public void tcheckForUseImpl() {
        CifType type;
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            type = CifTypesTypeChecker.transCifType(this.astDecl.type, this.scope.getParent(), this.tchecker);
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
            this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Function parameter", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
            throw new SemanticException();
        }
        ((FunctionParameter)this.mmDecl).getParameter().setType(type);
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        CifType type = ((FunctionParameter)this.mmDecl).getParameter().getType();
        if (CifValueUtils.getPossibleValueCount((CifType)type) == 1.0) {
            this.tchecker.addProblem(ErrMsg.TYPE_ONE_VALUE, type.getPosition(), "", CifTextUtils.typeToStr((CifType)type), "function parameter", CifTextUtils.getAbsName((PositionObject)this.mmDecl, (boolean)false), "function parameter");
        }
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astDecl.annotations, this.scope, this.tchecker);
        ((FunctionParameter)this.mmDecl).getParameter().getAnnotations().addAll(annos);
        this.status = CheckStatus.FULL;
    }
}

