/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.runtime.exceptions;

import java.util.Locale;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;

public class ScanException
extends SyntaxException {
    private final int codePoint;

    public ScanException(int codePoint, TextPosition position) {
        super(position);
        this.codePoint = codePoint;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    @Override
    public String getMessage() {
        String src = this.getPosition().source;
        if (src == null) {
            src = "";
        }
        if (this.codePoint == -1) {
            return Strings.fmt((String)"%sScanning failed at line %d, column %d, due to premature end of input.", (Object[])new Object[]{src, this.getPosition().startLine, this.getPosition().startColumn});
        }
        String codePointTxt = Strings.isGraphicCodePoint((int)this.codePoint) ? Strings.codePointToStr((int)this.codePoint) : "";
        return Strings.fmt((String)"%sScanning failed for character \"%s\" (Unicode U+%s) at line %d, column %d.", (Object[])new Object[]{src, codePointTxt, Integer.toHexString(this.codePoint).toUpperCase(Locale.US), this.getPosition().startLine, this.getPosition().startColumn});
    }
}

