/**
 * Copyright (c) 2010, 2025 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the terms
 * of the MIT License which is available at https://opensource.org/licenses/MIT
 * 
 * SPDX-License-Identifier: MIT
 * 
 * Disable Eclipse Java formatter for generated code file:
 * @formatter:off
 */
package org.eclipse.escet.chi.metamodel.chi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Std Lib Functions</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.escet.chi.metamodel.chi.ChiPackage#getStdLibFunctions()
 * @model
 * @generated
 */
public enum StdLibFunctions implements Enumerator
{
    /**
     * The '<em><b>Abs</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ABS_VALUE
     * @generated
     * @ordered
     */
    ABS(16, "Abs", "Abs"),

    /**
     * The '<em><b>Acos</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ACOS_VALUE
     * @generated
     * @ordered
     */
    ACOS(26, "Acos", "Acos"),

    /**
     * The '<em><b>Acosh</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ACOSH_VALUE
     * @generated
     * @ordered
     */
    ACOSH(32, "Acosh", "Acosh"),

    /**
     * The '<em><b>Asin</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ASIN_VALUE
     * @generated
     * @ordered
     */
    ASIN(25, "Asin", "Asin"),

    /**
     * The '<em><b>Asinh</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ASINH_VALUE
     * @generated
     * @ordered
     */
    ASINH(31, "Asinh", "Asinh"),

    /**
     * The '<em><b>Atan</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ATAN_VALUE
     * @generated
     * @ordered
     */
    ATAN(27, "Atan", "Atan"),

    /**
     * The '<em><b>Atanh</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ATANH_VALUE
     * @generated
     * @ordered
     */
    ATANH(33, "Atanh", "Atanh"),

    /**
     * The '<em><b>Bernoulli</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #BERNOULLI_VALUE
     * @generated
     * @ordered
     */
    BERNOULLI(39, "Bernoulli", "Bernoulli"),

    /**
     * The '<em><b>Empty</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EMPTY_VALUE
     * @generated
     * @ordered
     */
    EMPTY(53, "Empty", "Empty"),

    /**
     * The '<em><b>Enumerate</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ENUMERATE_VALUE
     * @generated
     * @ordered
     */
    ENUMERATE(4, "Enumerate", "Enumerate"),

    /**
     * The '<em><b>Eof</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EOF_VALUE
     * @generated
     * @ordered
     */
    EOF(7, "Eof", "Eof"),

    /**
     * The '<em><b>Eol</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EOL_VALUE
     * @generated
     * @ordered
     */
    EOL(6, "Eol", "Eol"),

    /**
     * The '<em><b>Erlang</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ERLANG_VALUE
     * @generated
     * @ordered
     */
    ERLANG(45, "Erlang", "Erlang"),

    /**
     * The '<em><b>Exp</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EXP_VALUE
     * @generated
     * @ordered
     */
    EXP(17, "Exp", "Exp"),

    /**
     * The '<em><b>Exponential</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EXPONENTIAL_VALUE
     * @generated
     * @ordered
     */
    EXPONENTIAL(46, "Exponential", "Exponential"),

    /**
     * The '<em><b>Finished</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #FINISHED_VALUE
     * @generated
     * @ordered
     */
    FINISHED(3, "Finished", "Finished"),

    /**
     * The '<em><b>Floor</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #FLOOR_VALUE
     * @generated
     * @ordered
     */
    FLOOR(1, "Floor", "Floor"),

    /**
     * The '<em><b>Gamma</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #GAMMA_VALUE
     * @generated
     * @ordered
     */
    GAMMA(47, "Gamma", "Gamma"),

    /**
     * The '<em><b>Geometric</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #GEOMETRIC_VALUE
     * @generated
     * @ordered
     */
    GEOMETRIC(41, "Geometric", "Geometric"),

    /**
     * The '<em><b>Insert</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #INSERT_VALUE
     * @generated
     * @ordered
     */
    INSERT(36, "Insert", "Insert"),

    /**
     * The '<em><b>Ln</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #LN_VALUE
     * @generated
     * @ordered
     */
    LN(18, "Ln", "Ln"),

    /**
     * The '<em><b>Log</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #LOG_VALUE
     * @generated
     * @ordered
     */
    LOG(19, "Log", "Log"),

    /**
     * The '<em><b>Log Normal</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #LOG_NORMAL_VALUE
     * @generated
     * @ordered
     */
    LOG_NORMAL(48, "LogNormal", "LogNormal"),

    /**
     * The '<em><b>Max</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #MAX_VALUE
     * @generated
     * @ordered
     */
    MAX(62, "Max", "Max"),

    /**
     * The '<em><b>Min</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #MIN_VALUE
     * @generated
     * @ordered
     */
    MIN(61, "Min", "Min"),

    /**
     * The '<em><b>Newlines</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #NEWLINES_VALUE
     * @generated
     * @ordered
     */
    NEWLINES(8, "Newlines", "Newlines"),

    /**
     * The '<em><b>Normal</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #NORMAL_VALUE
     * @generated
     * @ordered
     */
    NORMAL(49, "Normal", "Normal"),

    /**
     * The '<em><b>Open</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #OPEN_VALUE
     * @generated
     * @ordered
     */
    OPEN(79, "Open", "Open"),

    /**
     * The '<em><b>Poisson</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #POISSON_VALUE
     * @generated
     * @ordered
     */
    POISSON(42, "Poisson", "Poisson"),

    /**
     * The '<em><b>Pop</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #POP_VALUE
     * @generated
     * @ordered
     */
    POP(64, "Pop", "Pop"),

    /**
     * The '<em><b>Random</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #RANDOM_VALUE
     * @generated
     * @ordered
     */
    RANDOM(51, "Random", "Random"),

    /**
     * The '<em><b>Range</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #RANGE_VALUE
     * @generated
     * @ordered
     */
    RANGE(54, "Range", "Range"),

    /**
     * The '<em><b>Ready</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #READY_VALUE
     * @generated
     * @ordered
     */
    READY(14, "Ready", "Ready"),

    /**
     * The '<em><b>Round</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ROUND_VALUE
     * @generated
     * @ordered
     */
    ROUND(2, "Round", "Round"),

    /**
     * The '<em><b>Sign</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SIGN_VALUE
     * @generated
     * @ordered
     */
    SIGN(15, "Sign", "Sign"),

    /**
     * The '<em><b>Sin</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SIN_VALUE
     * @generated
     * @ordered
     */
    SIN(22, "Sin", "Sin"),

    /**
     * The '<em><b>Sinh</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SINH_VALUE
     * @generated
     * @ordered
     */
    SINH(28, "Sinh", "Sinh"),

    /**
     * The '<em><b>Size</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SIZE_VALUE
     * @generated
     * @ordered
     */
    SIZE(34, "Size", "Size"),

    /**
     * The '<em><b>Sort</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SORT_VALUE
     * @generated
     * @ordered
     */
    SORT(35, "Sort", "Sort"),

    /**
     * The '<em><b>Sqrt</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SQRT_VALUE
     * @generated
     * @ordered
     */
    SQRT(20, "Sqrt", "Sqrt"),

    /**
     * The '<em><b>Tan</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #TAN_VALUE
     * @generated
     * @ordered
     */
    TAN(24, "Tan", "Tan"),

    /**
     * The '<em><b>Tanh</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #TANH_VALUE
     * @generated
     * @ordered
     */
    TANH(30, "Tanh", "Tanh"),

    /**
     * The '<em><b>Triangle</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #TRIANGLE_VALUE
     * @generated
     * @ordered
     */
    TRIANGLE(50, "Triangle", "Triangle"),

    /**
     * The '<em><b>Uniform</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #UNIFORM_VALUE
     * @generated
     * @ordered
     */
    UNIFORM(43, "Uniform", "Uniform"),

    /**
     * The '<em><b>Weibull</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #WEIBULL_VALUE
     * @generated
     * @ordered
     */
    WEIBULL(52, "Weibull", "Weibull"),

    /**
     * The '<em><b>Beta</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #BETA_VALUE
     * @generated
     * @ordered
     */
    BETA(44, "Beta", "Beta"),

    /**
     * The '<em><b>Binomial</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #BINOMIAL_VALUE
     * @generated
     * @ordered
     */
    BINOMIAL(40, "Binomial", "Binomial"),

    /**
     * The '<em><b>Cbrt</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #CBRT_VALUE
     * @generated
     * @ordered
     */
    CBRT(21, "Cbrt", "Cbrt"),

    /**
     * The '<em><b>Ceil</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #CEIL_VALUE
     * @generated
     * @ordered
     */
    CEIL(0, "Ceil", "Ceil"),

    /**
     * The '<em><b>Constant</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #CONSTANT_VALUE
     * @generated
     * @ordered
     */
    CONSTANT(38, "Constant", "Constant"),

    /**
     * The '<em><b>Cos</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #COS_VALUE
     * @generated
     * @ordered
     */
    COS(23, "Cos", "Cos"),

    /**
     * The '<em><b>Cosh</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #COSH_VALUE
     * @generated
     * @ordered
     */
    COSH(29, "Cosh", "Cosh"),

    /**
     * The '<em><b>Delete</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #DELETE_VALUE
     * @generated
     * @ordered
     */
    DELETE(5, "Delete", "Delete"),

    /**
     * The '<em><b>Dict Keys</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #DICT_KEYS_VALUE
     * @generated
     * @ordered
     */
    DICT_KEYS(9, "DictKeys", "DictKeys"),

    /**
     * The '<em><b>Dict Values</b></em>' literal object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #DICT_VALUES_VALUE
     * @generated
     * @ordered
     */
    DICT_VALUES(10, "DictValues", "DictValues");

    /**
     * The '<em><b>Abs</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ABS
     * @model name="Abs"
     * @generated
     * @ordered
     */
    public static final int ABS_VALUE = 16;

    /**
     * The '<em><b>Acos</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ACOS
     * @model name="Acos"
     * @generated
     * @ordered
     */
    public static final int ACOS_VALUE = 26;

    /**
     * The '<em><b>Acosh</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ACOSH
     * @model name="Acosh"
     * @generated
     * @ordered
     */
    public static final int ACOSH_VALUE = 32;

    /**
     * The '<em><b>Asin</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ASIN
     * @model name="Asin"
     * @generated
     * @ordered
     */
    public static final int ASIN_VALUE = 25;

    /**
     * The '<em><b>Asinh</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ASINH
     * @model name="Asinh"
     * @generated
     * @ordered
     */
    public static final int ASINH_VALUE = 31;

    /**
     * The '<em><b>Atan</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ATAN
     * @model name="Atan"
     * @generated
     * @ordered
     */
    public static final int ATAN_VALUE = 27;

    /**
     * The '<em><b>Atanh</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ATANH
     * @model name="Atanh"
     * @generated
     * @ordered
     */
    public static final int ATANH_VALUE = 33;

    /**
     * The '<em><b>Bernoulli</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #BERNOULLI
     * @model name="Bernoulli"
     * @generated
     * @ordered
     */
    public static final int BERNOULLI_VALUE = 39;

    /**
     * The '<em><b>Empty</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EMPTY
     * @model name="Empty"
     * @generated
     * @ordered
     */
    public static final int EMPTY_VALUE = 53;

    /**
     * The '<em><b>Enumerate</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ENUMERATE
     * @model name="Enumerate"
     * @generated
     * @ordered
     */
    public static final int ENUMERATE_VALUE = 4;

    /**
     * The '<em><b>Eof</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EOF
     * @model name="Eof"
     * @generated
     * @ordered
     */
    public static final int EOF_VALUE = 7;

    /**
     * The '<em><b>Eol</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EOL
     * @model name="Eol"
     * @generated
     * @ordered
     */
    public static final int EOL_VALUE = 6;

    /**
     * The '<em><b>Erlang</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ERLANG
     * @model name="Erlang"
     * @generated
     * @ordered
     */
    public static final int ERLANG_VALUE = 45;

    /**
     * The '<em><b>Exp</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EXP
     * @model name="Exp"
     * @generated
     * @ordered
     */
    public static final int EXP_VALUE = 17;

    /**
     * The '<em><b>Exponential</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #EXPONENTIAL
     * @model name="Exponential"
     * @generated
     * @ordered
     */
    public static final int EXPONENTIAL_VALUE = 46;

    /**
     * The '<em><b>Finished</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #FINISHED
     * @model name="Finished"
     * @generated
     * @ordered
     */
    public static final int FINISHED_VALUE = 3;

    /**
     * The '<em><b>Floor</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #FLOOR
     * @model name="Floor"
     * @generated
     * @ordered
     */
    public static final int FLOOR_VALUE = 1;

    /**
     * The '<em><b>Gamma</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #GAMMA
     * @model name="Gamma"
     * @generated
     * @ordered
     */
    public static final int GAMMA_VALUE = 47;

    /**
     * The '<em><b>Geometric</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #GEOMETRIC
     * @model name="Geometric"
     * @generated
     * @ordered
     */
    public static final int GEOMETRIC_VALUE = 41;

    /**
     * The '<em><b>Insert</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #INSERT
     * @model name="Insert"
     * @generated
     * @ordered
     */
    public static final int INSERT_VALUE = 36;

    /**
     * The '<em><b>Ln</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #LN
     * @model name="Ln"
     * @generated
     * @ordered
     */
    public static final int LN_VALUE = 18;

    /**
     * The '<em><b>Log</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #LOG
     * @model name="Log"
     * @generated
     * @ordered
     */
    public static final int LOG_VALUE = 19;

    /**
     * The '<em><b>Log Normal</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #LOG_NORMAL
     * @model name="LogNormal"
     * @generated
     * @ordered
     */
    public static final int LOG_NORMAL_VALUE = 48;

    /**
     * The '<em><b>Max</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #MAX
     * @model name="Max"
     * @generated
     * @ordered
     */
    public static final int MAX_VALUE = 62;

    /**
     * The '<em><b>Min</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #MIN
     * @model name="Min"
     * @generated
     * @ordered
     */
    public static final int MIN_VALUE = 61;

    /**
     * The '<em><b>Newlines</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #NEWLINES
     * @model name="Newlines"
     * @generated
     * @ordered
     */
    public static final int NEWLINES_VALUE = 8;

    /**
     * The '<em><b>Normal</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #NORMAL
     * @model name="Normal"
     * @generated
     * @ordered
     */
    public static final int NORMAL_VALUE = 49;

    /**
     * The '<em><b>Open</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #OPEN
     * @model name="Open"
     * @generated
     * @ordered
     */
    public static final int OPEN_VALUE = 79;

    /**
     * The '<em><b>Poisson</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #POISSON
     * @model name="Poisson"
     * @generated
     * @ordered
     */
    public static final int POISSON_VALUE = 42;

    /**
     * The '<em><b>Pop</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #POP
     * @model name="Pop"
     * @generated
     * @ordered
     */
    public static final int POP_VALUE = 64;

    /**
     * The '<em><b>Random</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #RANDOM
     * @model name="Random"
     * @generated
     * @ordered
     */
    public static final int RANDOM_VALUE = 51;

    /**
     * The '<em><b>Range</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #RANGE
     * @model name="Range"
     * @generated
     * @ordered
     */
    public static final int RANGE_VALUE = 54;

    /**
     * The '<em><b>Ready</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #READY
     * @model name="Ready"
     * @generated
     * @ordered
     */
    public static final int READY_VALUE = 14;

    /**
     * The '<em><b>Round</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #ROUND
     * @model name="Round"
     * @generated
     * @ordered
     */
    public static final int ROUND_VALUE = 2;

    /**
     * The '<em><b>Sign</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SIGN
     * @model name="Sign"
     * @generated
     * @ordered
     */
    public static final int SIGN_VALUE = 15;

    /**
     * The '<em><b>Sin</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SIN
     * @model name="Sin"
     * @generated
     * @ordered
     */
    public static final int SIN_VALUE = 22;

    /**
     * The '<em><b>Sinh</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SINH
     * @model name="Sinh"
     * @generated
     * @ordered
     */
    public static final int SINH_VALUE = 28;

    /**
     * The '<em><b>Size</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SIZE
     * @model name="Size"
     * @generated
     * @ordered
     */
    public static final int SIZE_VALUE = 34;

    /**
     * The '<em><b>Sort</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SORT
     * @model name="Sort"
     * @generated
     * @ordered
     */
    public static final int SORT_VALUE = 35;

    /**
     * The '<em><b>Sqrt</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #SQRT
     * @model name="Sqrt"
     * @generated
     * @ordered
     */
    public static final int SQRT_VALUE = 20;

    /**
     * The '<em><b>Tan</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #TAN
     * @model name="Tan"
     * @generated
     * @ordered
     */
    public static final int TAN_VALUE = 24;

    /**
     * The '<em><b>Tanh</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #TANH
     * @model name="Tanh"
     * @generated
     * @ordered
     */
    public static final int TANH_VALUE = 30;

    /**
     * The '<em><b>Triangle</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #TRIANGLE
     * @model name="Triangle"
     * @generated
     * @ordered
     */
    public static final int TRIANGLE_VALUE = 50;

    /**
     * The '<em><b>Uniform</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #UNIFORM
     * @model name="Uniform"
     * @generated
     * @ordered
     */
    public static final int UNIFORM_VALUE = 43;

    /**
     * The '<em><b>Weibull</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #WEIBULL
     * @model name="Weibull"
     * @generated
     * @ordered
     */
    public static final int WEIBULL_VALUE = 52;

    /**
     * The '<em><b>Beta</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #BETA
     * @model name="Beta"
     * @generated
     * @ordered
     */
    public static final int BETA_VALUE = 44;

    /**
     * The '<em><b>Binomial</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #BINOMIAL
     * @model name="Binomial"
     * @generated
     * @ordered
     */
    public static final int BINOMIAL_VALUE = 40;

    /**
     * The '<em><b>Cbrt</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #CBRT
     * @model name="Cbrt"
     * @generated
     * @ordered
     */
    public static final int CBRT_VALUE = 21;

    /**
     * The '<em><b>Ceil</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #CEIL
     * @model name="Ceil"
     * @generated
     * @ordered
     */
    public static final int CEIL_VALUE = 0;

    /**
     * The '<em><b>Constant</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #CONSTANT
     * @model name="Constant"
     * @generated
     * @ordered
     */
    public static final int CONSTANT_VALUE = 38;

    /**
     * The '<em><b>Cos</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #COS
     * @model name="Cos"
     * @generated
     * @ordered
     */
    public static final int COS_VALUE = 23;

    /**
     * The '<em><b>Cosh</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #COSH
     * @model name="Cosh"
     * @generated
     * @ordered
     */
    public static final int COSH_VALUE = 29;

    /**
     * The '<em><b>Delete</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #DELETE
     * @model name="Delete"
     * @generated
     * @ordered
     */
    public static final int DELETE_VALUE = 5;

    /**
     * The '<em><b>Dict Keys</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #DICT_KEYS
     * @model name="DictKeys"
     * @generated
     * @ordered
     */
    public static final int DICT_KEYS_VALUE = 9;

    /**
     * The '<em><b>Dict Values</b></em>' literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #DICT_VALUES
     * @model name="DictValues"
     * @generated
     * @ordered
     */
    public static final int DICT_VALUES_VALUE = 10;

    /**
     * An array of all the '<em><b>Std Lib Functions</b></em>' enumerators.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private static final StdLibFunctions[] VALUES_ARRAY =
        new StdLibFunctions[]
        {
            ABS,
            ACOS,
            ACOSH,
            ASIN,
            ASINH,
            ATAN,
            ATANH,
            BERNOULLI,
            EMPTY,
            ENUMERATE,
            EOF,
            EOL,
            ERLANG,
            EXP,
            EXPONENTIAL,
            FINISHED,
            FLOOR,
            GAMMA,
            GEOMETRIC,
            INSERT,
            LN,
            LOG,
            LOG_NORMAL,
            MAX,
            MIN,
            NEWLINES,
            NORMAL,
            OPEN,
            POISSON,
            POP,
            RANDOM,
            RANGE,
            READY,
            ROUND,
            SIGN,
            SIN,
            SINH,
            SIZE,
            SORT,
            SQRT,
            TAN,
            TANH,
            TRIANGLE,
            UNIFORM,
            WEIBULL,
            BETA,
            BINOMIAL,
            CBRT,
            CEIL,
            CONSTANT,
            COS,
            COSH,
            DELETE,
            DICT_KEYS,
            DICT_VALUES,
        };

    /**
     * A public read-only list of all the '<em><b>Std Lib Functions</b></em>' enumerators.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final List<StdLibFunctions> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    /**
     * Returns the '<em><b>Std Lib Functions</b></em>' literal with the specified literal value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param literal the literal.
     * @return the matching enumerator or <code>null</code>.
     * @generated
     */
    public static StdLibFunctions get(String literal)
    {
        for (int i = 0; i < VALUES_ARRAY.length; ++i)
        {
            StdLibFunctions result = VALUES_ARRAY[i];
            if (result.toString().equals(literal))
            {
                return result;
            }
        }
        return null;
    }

    /**
     * Returns the '<em><b>Std Lib Functions</b></em>' literal with the specified name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param name the name.
     * @return the matching enumerator or <code>null</code>.
     * @generated
     */
    public static StdLibFunctions getByName(String name)
    {
        for (int i = 0; i < VALUES_ARRAY.length; ++i)
        {
            StdLibFunctions result = VALUES_ARRAY[i];
            if (result.getName().equals(name))
            {
                return result;
            }
        }
        return null;
    }

    /**
     * Returns the '<em><b>Std Lib Functions</b></em>' literal with the specified integer value.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the integer value.
     * @return the matching enumerator or <code>null</code>.
     * @generated
     */
    public static StdLibFunctions get(int value)
    {
        switch (value)
        {
            case ABS_VALUE: return ABS;
            case ACOS_VALUE: return ACOS;
            case ACOSH_VALUE: return ACOSH;
            case ASIN_VALUE: return ASIN;
            case ASINH_VALUE: return ASINH;
            case ATAN_VALUE: return ATAN;
            case ATANH_VALUE: return ATANH;
            case BERNOULLI_VALUE: return BERNOULLI;
            case EMPTY_VALUE: return EMPTY;
            case ENUMERATE_VALUE: return ENUMERATE;
            case EOF_VALUE: return EOF;
            case EOL_VALUE: return EOL;
            case ERLANG_VALUE: return ERLANG;
            case EXP_VALUE: return EXP;
            case EXPONENTIAL_VALUE: return EXPONENTIAL;
            case FINISHED_VALUE: return FINISHED;
            case FLOOR_VALUE: return FLOOR;
            case GAMMA_VALUE: return GAMMA;
            case GEOMETRIC_VALUE: return GEOMETRIC;
            case INSERT_VALUE: return INSERT;
            case LN_VALUE: return LN;
            case LOG_VALUE: return LOG;
            case LOG_NORMAL_VALUE: return LOG_NORMAL;
            case MAX_VALUE: return MAX;
            case MIN_VALUE: return MIN;
            case NEWLINES_VALUE: return NEWLINES;
            case NORMAL_VALUE: return NORMAL;
            case OPEN_VALUE: return OPEN;
            case POISSON_VALUE: return POISSON;
            case POP_VALUE: return POP;
            case RANDOM_VALUE: return RANDOM;
            case RANGE_VALUE: return RANGE;
            case READY_VALUE: return READY;
            case ROUND_VALUE: return ROUND;
            case SIGN_VALUE: return SIGN;
            case SIN_VALUE: return SIN;
            case SINH_VALUE: return SINH;
            case SIZE_VALUE: return SIZE;
            case SORT_VALUE: return SORT;
            case SQRT_VALUE: return SQRT;
            case TAN_VALUE: return TAN;
            case TANH_VALUE: return TANH;
            case TRIANGLE_VALUE: return TRIANGLE;
            case UNIFORM_VALUE: return UNIFORM;
            case WEIBULL_VALUE: return WEIBULL;
            case BETA_VALUE: return BETA;
            case BINOMIAL_VALUE: return BINOMIAL;
            case CBRT_VALUE: return CBRT;
            case CEIL_VALUE: return CEIL;
            case CONSTANT_VALUE: return CONSTANT;
            case COS_VALUE: return COS;
            case COSH_VALUE: return COSH;
            case DELETE_VALUE: return DELETE;
            case DICT_KEYS_VALUE: return DICT_KEYS;
            case DICT_VALUES_VALUE: return DICT_VALUES;
        }
        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private final int value;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private final String name;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private final String literal;

    /**
     * Only this class can construct instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private StdLibFunctions(int value, String name, String literal)
    {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public int getValue()
    {
      return value;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String getName()
    {
      return name;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String getLiteral()
    {
      return literal;
    }

    /**
     * Returns the literal value of the enumerator, which is its string representation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        return literal;
    }
    
} //StdLibFunctions
