/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.chi.metamodel.chi.AssignmentStatement;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.BinaryOperators;
import org.eclipse.escet.chi.metamodel.chi.BoolType;
import org.eclipse.escet.chi.metamodel.chi.BreakStatement;
import org.eclipse.escet.chi.metamodel.chi.CallExpression;
import org.eclipse.escet.chi.metamodel.chi.ChannelOps;
import org.eclipse.escet.chi.metamodel.chi.ChannelType;
import org.eclipse.escet.chi.metamodel.chi.CloseStatement;
import org.eclipse.escet.chi.metamodel.chi.ContinueStatement;
import org.eclipse.escet.chi.metamodel.chi.CreateCase;
import org.eclipse.escet.chi.metamodel.chi.DelayStatement;
import org.eclipse.escet.chi.metamodel.chi.DictType;
import org.eclipse.escet.chi.metamodel.chi.ExitStatement;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FileType;
import org.eclipse.escet.chi.metamodel.chi.FinishStatement;
import org.eclipse.escet.chi.metamodel.chi.ForStatement;
import org.eclipse.escet.chi.metamodel.chi.IfCase;
import org.eclipse.escet.chi.metamodel.chi.IfStatement;
import org.eclipse.escet.chi.metamodel.chi.InstanceType;
import org.eclipse.escet.chi.metamodel.chi.IntType;
import org.eclipse.escet.chi.metamodel.chi.IteratedCreateCase;
import org.eclipse.escet.chi.metamodel.chi.IteratedSelectCase;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.PassStatement;
import org.eclipse.escet.chi.metamodel.chi.ProcessInstance;
import org.eclipse.escet.chi.metamodel.chi.ProcessType;
import org.eclipse.escet.chi.metamodel.chi.RealType;
import org.eclipse.escet.chi.metamodel.chi.ReceiveStatement;
import org.eclipse.escet.chi.metamodel.chi.ReturnStatement;
import org.eclipse.escet.chi.metamodel.chi.RunStatement;
import org.eclipse.escet.chi.metamodel.chi.SelectCase;
import org.eclipse.escet.chi.metamodel.chi.SelectStatement;
import org.eclipse.escet.chi.metamodel.chi.SendStatement;
import org.eclipse.escet.chi.metamodel.chi.SetType;
import org.eclipse.escet.chi.metamodel.chi.Statement;
import org.eclipse.escet.chi.metamodel.chi.StringLiteral;
import org.eclipse.escet.chi.metamodel.chi.StringType;
import org.eclipse.escet.chi.metamodel.chi.TupleExpression;
import org.eclipse.escet.chi.metamodel.chi.TupleField;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.Unwind;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.chi.VariableReference;
import org.eclipse.escet.chi.metamodel.chi.VoidType;
import org.eclipse.escet.chi.metamodel.chi.WhileStatement;
import org.eclipse.escet.chi.metamodel.chi.WriteStatement;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.CheckExpression;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.VariableSymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class CheckStatement {
    private static void checkAddressableExpression(Expression e, CheckContext ctxt) {
        Expression left;
        Type ltp;
        BinaryExpression be;
        if (e instanceof VariableReference) {
            VariableReference ref = (VariableReference)e;
            EObject obj = ref.getVariable().eContainer();
            if (obj instanceof BehaviourDeclaration) {
                return;
            }
            Assert.check((obj instanceof Unwind || obj instanceof ForStatement ? 1 : 0) != 0);
        }
        if (e instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)e;
            for (Expression expr : tuple.getFields()) {
                CheckStatement.checkAddressableExpression(expr, ctxt);
            }
            return;
        }
        if (e instanceof BinaryExpression && (be = (BinaryExpression)e).getOp() == BinaryOperators.PROJECTION && !((ltp = CheckType.dropReferences((left = be.getLeft()).getType())) instanceof StringType)) {
            CheckStatement.checkAddressableExpression(left, ctxt);
            return;
        }
        ctxt.throwError(Message.NOT_ADDRESSABLE, e.getPosition(), new String[0]);
    }

    private static LocalVarsResult checkLocalVariables(Expression source, List<VariableDeclaration> vars, CheckContext ctxt) {
        Expression newSource = CheckExpression.transExpression(source, ctxt);
        Type elmType = CheckType.dropReferences(newSource.getType());
        if (elmType instanceof ListType) {
            elmType = CheckType.dropReferences(((ListType)elmType).getElementType());
            elmType = CheckType.copyType(elmType);
        } else if (elmType instanceof SetType) {
            elmType = CheckType.dropReferences(((SetType)elmType).getElementType());
            elmType = CheckType.copyType(elmType);
        } else if (elmType instanceof DictType) {
            DictType dt = (DictType)elmType;
            TupleField tf0 = ChiConstructors.newTupleField(null, null, (Type)CheckType.copyType(dt.getKeyType()));
            TupleField tf1 = ChiConstructors.newTupleField(null, null, (Type)CheckType.copyType(dt.getValueType()));
            elmType = ChiConstructors.newTupleType((List)Lists.list((Object[])new TupleField[]{tf0, tf1}), null);
        } else {
            ctxt.throwError(Message.LIST_SET_DICT_EXPECTED, source.getPosition(), CheckType.toString(elmType));
        }
        List newVars = Lists.list();
        if (vars.size() == 1) {
            VariableDeclaration varDecl = vars.get(0);
            VariableDeclaration newVarDecl = ChiConstructors.newVariableDeclaration(null, (String)varDecl.getName(), (Boolean)false, (Position)PositionUtils.copyPosition((PositionObject)varDecl), (Type)elmType);
            newVars.add(newVarDecl);
        } else {
            boolean cond = elmType instanceof TupleType;
            ctxt.checkThrowError(cond, Message.TUPLE_N_EXPECTED, source.getPosition(), String.valueOf(vars.size()), CheckType.toString(elmType));
            TupleType tt = (TupleType)elmType;
            cond = tt.getFields().size() == vars.size();
            ctxt.checkThrowError(cond, Message.TUPLE_N_EXPECTED_FOUND_M, source.getPosition(), String.valueOf(tt.getFields().size()), String.valueOf(vars.size()));
            int i = 0;
            while (i < vars.size()) {
                VariableDeclaration varDecl = vars.get(i);
                Type varType = ((TupleField)tt.getFields().get(i)).getType();
                VariableDeclaration newVarDecl = ChiConstructors.newVariableDeclaration(null, (String)varDecl.getName(), (Boolean)false, (Position)PositionUtils.copyPosition((PositionObject)varDecl), (Type)CheckType.copyType(varType));
                newVars.add(newVarDecl);
                ++i;
            }
        }
        CheckContext newCtxt = ctxt.newSymbolContext();
        for (VariableDeclaration vd : newVars) {
            VariableSymbolEntry se = new VariableSymbolEntry(false, vd, ctxt);
            newCtxt.addSymbol(se);
        }
        return new LocalVarsResult(newSource, newVars, newCtxt);
    }

    private static CheckContext transUnwinds(List<Unwind> unwinds, List<Unwind> newUnwinds, CheckContext ctxt) {
        for (Unwind unw : unwinds) {
            LocalVarsResult lvr = CheckStatement.checkLocalVariables(unw.getSource(), (List<VariableDeclaration>)unw.getVariables(), ctxt);
            newUnwinds.add(ChiConstructors.newUnwind((Position)PositionUtils.copyPosition((PositionObject)unw), (Expression)lvr.newSource, lvr.newVars));
            ctxt = lvr.newCtxt;
        }
        return ctxt;
    }

    public static List<Statement> transStatementList(List<Statement> stats, CheckContext ctxt) {
        List newStats = Lists.list();
        for (Statement s : stats) {
            newStats.add(CheckStatement.transStatement(s, ctxt));
        }
        return newStats;
    }

    protected static Statement transStatement(Statement stat, CheckContext ctxt) {
        if (stat instanceof AssignmentStatement) {
            return CheckStatement.transAssignmentStatement((AssignmentStatement)stat, ctxt);
        }
        if (stat instanceof BreakStatement) {
            return CheckStatement.transBreakStatement((BreakStatement)stat, ctxt);
        }
        if (stat instanceof CloseStatement) {
            return CheckStatement.transCloseStatement((CloseStatement)stat, ctxt);
        }
        if (stat instanceof ContinueStatement) {
            return CheckStatement.transContinueStatement((ContinueStatement)stat, ctxt);
        }
        if (stat instanceof DelayStatement) {
            return CheckStatement.transDelayStatement((DelayStatement)stat, ctxt);
        }
        if (stat instanceof FinishStatement) {
            return CheckStatement.transFinishStatement((FinishStatement)stat, ctxt);
        }
        if (stat instanceof ForStatement) {
            return CheckStatement.transForStatement((ForStatement)stat, ctxt);
        }
        if (stat instanceof IfStatement) {
            return CheckStatement.transIfStatement((IfStatement)stat, ctxt);
        }
        if (stat instanceof PassStatement) {
            return CheckStatement.transPassStatement((PassStatement)stat);
        }
        if (stat instanceof ReceiveStatement) {
            return CheckStatement.transReceiveStatement((ReceiveStatement)stat, ctxt);
        }
        if (stat instanceof ReturnStatement) {
            return CheckStatement.transReturnStatement((ReturnStatement)stat, ctxt);
        }
        if (stat instanceof RunStatement) {
            return CheckStatement.transRunStatement((RunStatement)stat, ctxt);
        }
        if (stat instanceof SelectStatement) {
            return CheckStatement.transSelectStatement((SelectStatement)stat, ctxt);
        }
        if (stat instanceof SendStatement) {
            return CheckStatement.transSendStatement((SendStatement)stat, ctxt);
        }
        if (stat instanceof ExitStatement) {
            return CheckStatement.transExitStatement((ExitStatement)stat, ctxt);
        }
        if (stat instanceof WhileStatement) {
            return CheckStatement.transWhileStatement((WhileStatement)stat, ctxt);
        }
        if (stat instanceof WriteStatement) {
            return CheckStatement.transWriteStatement((WriteStatement)stat, ctxt);
        }
        Assert.fail((Object)"Unknown statement type encountered");
        return null;
    }

    private static Statement transAssignmentStatement(AssignmentStatement stat, CheckContext ctxt) {
        CheckContext lhsCtxt = ctxt.add(CheckContext.ContextItem.NO_READ, CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_CHANNEL, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_SAMPLE);
        Expression newLhs = CheckExpression.transExpression(stat.getLhs(), lhsCtxt);
        Expression newRhs = CheckExpression.transExpression(stat.getRhs(), ctxt);
        boolean cond = CheckType.matchType(newRhs.getType(), newLhs.getType());
        ctxt.checkThrowError(cond, Message.CANNOT_ASSIGN, stat.getPosition(), CheckType.toString(newRhs.getType()), CheckType.toString(newLhs.getType()));
        CheckStatement.checkAddressableExpression(newLhs, ctxt);
        return ChiConstructors.newAssignmentStatement((Expression)newLhs, (Position)PositionUtils.copyPosition((PositionObject)stat), (Expression)newRhs);
    }

    private static Statement transBreakStatement(BreakStatement stat, CheckContext ctxt) {
        ctxt.checkThrowError(ctxt.contains(CheckContext.ContextItem.INSIDE_LOOP), Message.BREAK_IN_LOOP, stat.getPosition(), new String[0]);
        return ChiConstructors.newBreakStatement((Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transCloseStatement(CloseStatement stat, CheckContext ctxt) {
        Expression handle = CheckExpression.transExpression(stat.getHandle(), ctxt);
        Type tp = CheckType.dropReferences(handle.getType());
        ctxt.checkThrowError(tp instanceof FileType, Message.FILE_TYPE_EXPECTED, stat.getPosition(), CheckType.toString(tp));
        return ChiConstructors.newCloseStatement((Expression)handle, (Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transContinueStatement(ContinueStatement stat, CheckContext ctxt) {
        ctxt.checkThrowError(ctxt.contains(CheckContext.ContextItem.INSIDE_LOOP), Message.CONTINUE_IN_LOOP, stat.getPosition(), new String[0]);
        return ChiConstructors.newContinueStatement((Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transDelayStatement(DelayStatement stat, CheckContext ctxt) {
        ctxt.checkThrowError(!ctxt.contains(CheckContext.ContextItem.NO_DELAY), Message.STATEMENT_NOT_IN_FUNCTION, stat.getPosition(), "delay");
        Expression newLength = CheckExpression.transExpression(stat.getLength(), ctxt);
        Type tp = CheckType.dropReferences(newLength.getType());
        boolean cond = tp instanceof IntType || tp instanceof RealType;
        ctxt.checkThrowError(cond, Message.NUMERIC_TYPE_EXPECTED, stat.getPosition(), CheckType.toString(tp));
        return ChiConstructors.newDelayStatement((Expression)newLength, (Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transFinishStatement(FinishStatement stat, CheckContext ctxt) {
        List<Expression> newInsts = CheckExpression.transExpressionList((List<Expression>)stat.getInstances(), ctxt);
        for (Expression e : newInsts) {
            Type tp = CheckType.dropReferences(e.getType());
            ctxt.checkThrowError(tp instanceof InstanceType, Message.INSTANCE_TYPE_EXPECTED, e.getPosition(), CheckType.toString(tp));
        }
        return ChiConstructors.newFinishStatement(newInsts, (Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transForStatement(ForStatement stat, CheckContext ctxt) {
        List newUnwinds = Lists.list();
        CheckContext loopCtxt = ctxt.add(CheckContext.ContextItem.INSIDE_LOOP);
        loopCtxt = CheckStatement.transUnwinds((List<Unwind>)stat.getUnwinds(), newUnwinds, loopCtxt);
        List<Statement> newBody = CheckStatement.transStatementList((List<Statement>)stat.getBody(), loopCtxt);
        loopCtxt.checkSymbolUsage();
        return ChiConstructors.newForStatement(newBody, (Position)PositionUtils.copyPosition((PositionObject)stat), (List)newUnwinds);
    }

    private static Statement transIfStatement(IfStatement stat, CheckContext ctxt) {
        List newCases = Lists.list();
        for (IfCase ifc : stat.getCases()) {
            Expression cond = null;
            if (ifc.getCondition() != null) {
                cond = CheckExpression.transExpression(ifc.getCondition(), ctxt);
                Type tp = CheckType.dropReferences(cond.getType());
                ctxt.checkThrowError(tp instanceof BoolType, Message.BOOLEAN_TYPE_EXPECTED, ifc.getCondition().getPosition(), CheckType.toString(tp));
            }
            List<Statement> newBody = CheckStatement.transStatementList((List<Statement>)ifc.getBody(), ctxt);
            newCases.add(ChiConstructors.newIfCase(newBody, (Expression)cond, (Position)PositionUtils.copyPosition((PositionObject)ifc)));
        }
        return ChiConstructors.newIfStatement((List)newCases, (Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transPassStatement(PassStatement stat) {
        return ChiConstructors.newPassStatement((Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transReceiveStatement(ReceiveStatement stat, CheckContext ctxt) {
        Expression newData;
        ctxt.checkThrowError(!ctxt.contains(CheckContext.ContextItem.NO_COMM), Message.STATEMENT_NOT_IN_FUNCTION, stat.getPosition(), "receive");
        CheckContext chanCtxt = ctxt.add(CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_READ, CheckContext.ContextItem.NO_INPUT, CheckContext.ContextItem.NO_CHANNEL, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_SAMPLE);
        Expression newChan = CheckExpression.transExpression(stat.getChannel(), chanCtxt);
        Type tp = CheckType.dropReferences(newChan.getType());
        ctxt.checkThrowError(tp instanceof ChannelType, Message.CHANNEL_TYPE_EXPECTED, stat.getChannel().getPosition(), CheckType.toString(tp));
        ChannelType chanType = (ChannelType)tp;
        if (chanType.getOps() == ChannelOps.SEND) {
            ctxt.throwError(Message.CANNOT_RECEIVE_ON_SEND_ONLY_CHANNEL, stat.getPosition(), new String[0]);
        }
        if ((tp = CheckType.dropReferences(chanType.getElementType())) instanceof VoidType) {
            ctxt.checkThrowError(stat.getData() == null, Message.SYNC_CHANNELS_NO_DATA, stat.getPosition(), new String[0]);
            newData = null;
        } else {
            ctxt.checkThrowError(stat.getData() != null, Message.VARIABLES_MISSING_WITH_RECEIVE, stat.getPosition(), CheckType.toString(tp));
            CheckContext lhsCtxt = ctxt.add(CheckContext.ContextItem.NO_READ, CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_CHANNEL, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_SAMPLE);
            newData = CheckExpression.transExpression(stat.getData(), lhsCtxt);
            boolean cond = CheckType.matchType(tp, newData.getType());
            ctxt.checkThrowError(cond, Message.RECV_DATA_NOT_MATCH_CHANNEL, stat.getPosition(), CheckType.toString(newData.getType()), CheckType.toString(tp));
            CheckStatement.checkAddressableExpression(newData, ctxt);
        }
        return ChiConstructors.newReceiveStatement((Expression)newChan, newData, (Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transReturnStatement(ReturnStatement stat, CheckContext ctxt) {
        if (ctxt.funcReturnType == null) {
            ctxt.throwError(Message.STATEMENT_NOT_OUTSIDE_FUNCTION, stat.getPosition(), "return");
        }
        Expression newRet = CheckExpression.transExpression(stat.getValue(), ctxt);
        boolean cond = CheckType.matchType(newRet.getType(), ctxt.funcReturnType);
        ctxt.checkThrowError(cond, Message.RETURNED_DATA_NOT_MATCH_FUNC_RET_TYPE, stat.getPosition(), CheckType.toString(newRet.getType()), CheckType.toString(ctxt.funcReturnType));
        return ChiConstructors.newReturnStatement((Position)PositionUtils.copyPosition((PositionObject)stat), (Expression)newRet);
    }

    private static List<CreateCase> transCreateCase(List<CreateCase> cases, boolean startOnly, CheckContext ctxt) {
        List newCases = Lists.list();
        for (CreateCase cc : cases) {
            if (cc instanceof ProcessInstance) {
                ProcessInstance pi = (ProcessInstance)cc;
                Expression newVar = null;
                if (pi.getVar() != null) {
                    ctxt.checkThrowError(startOnly, Message.INST_USELESS_WITH_RUN, pi.getVar().getPosition(), new String[0]);
                    newVar = CheckExpression.transExpression(pi.getVar(), ctxt);
                    Type tp = CheckType.dropReferences(newVar.getType());
                    ctxt.checkThrowError(tp instanceof InstanceType, Message.VAR_INST_TYPE, pi.getVar().getPosition(), CheckType.toString(tp));
                }
                Expression newCall = CheckExpression.transExpression(pi.getCall(), ctxt);
                Type tp = CheckType.dropReferences(newCall.getType());
                ctxt.checkThrowError(tp instanceof InstanceType, Message.NEED_RUN_START_STAT, pi.getCall().getPosition(), new String[0]);
                CallExpression ce = (CallExpression)newCall;
                ProcessType pt = (ProcessType)ce.getFunction().getType();
                if (pt.getExitType() != null) {
                    if (ctxt.exitType == null) {
                        ctxt.throwError(Message.CANNOT_START_PROCESS_WITH_EXIT_IN_NO_EXIT, newCall.getPosition(), CheckType.toString(pt.getExitType()));
                    } else if (!CheckType.matchType(pt.getExitType(), ctxt.exitType)) {
                        ctxt.throwError(Message.EXIT_TYPES_DO_NOT_MATCH, newCall.getPosition(), CheckType.toString(pt.getExitType()), CheckType.toString(ctxt.exitType));
                    }
                }
                newCases.add(ChiConstructors.newProcessInstance((Expression)newCall, (Position)PositionUtils.copyPosition((PositionObject)pi), (Expression)newVar));
                continue;
            }
            if (cc instanceof IteratedCreateCase) {
                IteratedCreateCase icc = (IteratedCreateCase)cc;
                List newUnwinds = Lists.list();
                CheckContext loopCtxt = ctxt.add(CheckContext.ContextItem.INSIDE_LOOP);
                loopCtxt = CheckStatement.transUnwinds((List<Unwind>)icc.getUnwinds(), newUnwinds, loopCtxt);
                List<CreateCase> newInstances = CheckStatement.transCreateCase((List<CreateCase>)icc.getInstances(), startOnly, loopCtxt);
                newCases.add(ChiConstructors.newIteratedCreateCase(newInstances, (Position)PositionUtils.copyPosition((PositionObject)cc), (List)newUnwinds));
                loopCtxt.checkSymbolUsage();
                continue;
            }
            Assert.fail((Object)"Unknown create case");
        }
        return newCases;
    }

    private static Statement transRunStatement(RunStatement stat, CheckContext ctxt) {
        ctxt.checkThrowError(!ctxt.contains(CheckContext.ContextItem.NO_RUN), Message.STATEMENT_NOT_IN_FUNCTION, stat.getPosition(), "run/create");
        List<CreateCase> newCases = CheckStatement.transCreateCase((List<CreateCase>)stat.getCases(), stat.isStartOnly(), ctxt);
        return ChiConstructors.newRunStatement(newCases, (Position)PositionUtils.copyPosition((PositionObject)stat), (Boolean)stat.isStartOnly());
    }

    private static Expression checkGuardExpression(Expression guard, CheckContext ctxt) {
        if (guard == null) {
            return null;
        }
        CheckContext gCtxt = ctxt.add(CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_READ, CheckContext.ContextItem.NO_INPUT, CheckContext.ContextItem.NO_CHANNEL, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_SAMPLE);
        Expression newGuard = CheckExpression.transExpression(guard, gCtxt);
        Type tp = CheckType.dropReferences(newGuard.getType());
        ctxt.checkThrowError(tp instanceof BoolType, Message.BOOLEAN_TYPE_EXPECTED, guard.getPosition(), CheckType.toString(tp));
        return newGuard;
    }

    private static Statement transSelectStatement(SelectStatement stat, CheckContext ctxt) {
        ctxt.checkThrowError(!ctxt.contains(CheckContext.ContextItem.NO_SELECT), Message.STATEMENT_NOT_IN_FUNCTION, stat.getPosition(), "select");
        List newCases = Lists.list();
        for (SelectCase sc : stat.getCases()) {
            if (sc instanceof IteratedSelectCase) {
                IteratedSelectCase isc = (IteratedSelectCase)sc;
                List newUnwinds = Lists.list();
                CheckContext loopCtxt = ctxt.add(CheckContext.ContextItem.INSIDE_LOOP);
                loopCtxt = CheckStatement.transUnwinds((List<Unwind>)isc.getUnwinds(), newUnwinds, loopCtxt);
                CheckContext guardCtxt = loopCtxt.add(CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_SAMPLE);
                Expression newGuard = CheckStatement.checkGuardExpression(sc.getGuard(), guardCtxt);
                List<Statement> newBody = CheckStatement.transStatementList((List<Statement>)sc.getBody(), loopCtxt);
                newCases.add(ChiConstructors.newIteratedSelectCase(newBody, (Expression)newGuard, (Position)PositionUtils.copyPosition((PositionObject)sc), (List)newUnwinds));
                loopCtxt.checkSymbolUsage();
                continue;
            }
            CheckContext guardCtxt = ctxt.add(CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_SAMPLE);
            Expression newGuard = CheckStatement.checkGuardExpression(sc.getGuard(), guardCtxt);
            List<Statement> newBody = CheckStatement.transStatementList((List<Statement>)sc.getBody(), ctxt);
            newCases.add(ChiConstructors.newSelectCase(newBody, (Expression)newGuard, (Position)PositionUtils.copyPosition((PositionObject)sc)));
        }
        return ChiConstructors.newSelectStatement((List)newCases, (Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transSendStatement(SendStatement stat, CheckContext ctxt) {
        Expression newData;
        ctxt.checkThrowError(!ctxt.contains(CheckContext.ContextItem.NO_COMM), Message.STATEMENT_NOT_IN_FUNCTION, stat.getPosition(), "send");
        CheckContext chanCtxt = ctxt.add(CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_READ, CheckContext.ContextItem.NO_INPUT, CheckContext.ContextItem.NO_CHANNEL, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_SAMPLE);
        Expression newChan = CheckExpression.transExpression(stat.getChannel(), chanCtxt);
        Type elementType = CheckType.dropReferences(newChan.getType());
        ctxt.checkThrowError(elementType instanceof ChannelType, Message.CHANNEL_TYPE_EXPECTED, stat.getChannel().getPosition(), CheckType.toString(elementType));
        ChannelType chanType = (ChannelType)elementType;
        if (chanType.getOps() == ChannelOps.RECEIVE) {
            ctxt.throwError(Message.CANNOT_SEND_ON_RECEIVE_ONLY_CHANNEL, stat.getPosition(), new String[0]);
        }
        elementType = chanType.getElementType();
        if ((elementType = CheckType.dropReferences(elementType)) instanceof VoidType) {
            ctxt.checkThrowError(stat.getData() == null, Message.SYNC_CHANNELS_NO_DATA, stat.getPosition(), new String[0]);
            newData = null;
        } else {
            ctxt.checkThrowError(stat.getData() != null, Message.DATA_MISSING_WITH_SEND, stat.getPosition(), CheckType.toString(elementType));
            newData = CheckExpression.transExpression(stat.getData(), ctxt);
            boolean cond = CheckType.matchType(newData.getType(), elementType);
            ctxt.checkThrowError(cond, Message.SENT_DATA_NOT_MATCH_CHANNEL, stat.getPosition(), CheckType.toString(newData.getType()), CheckType.toString(elementType));
        }
        return ChiConstructors.newSendStatement((Expression)newChan, newData, (Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transExitStatement(ExitStatement stat, CheckContext ctxt) {
        VoidType actualType;
        Expression newExit;
        if (ctxt.exitType == null) {
            if (ctxt.contains(CheckContext.ContextItem.NO_EXIT)) {
                ctxt.throwError(Message.EXIT_STATEMENT_NOT_ALLOWED, stat.getPosition(), new String[0]);
            } else {
                ctxt.throwError(Message.PROC_MODEL_NO_EXIT_TYPE, stat.getPosition(), new String[0]);
            }
        }
        if (stat.getValue() == null) {
            newExit = null;
            actualType = ChiConstructors.newVoidType();
        } else {
            newExit = CheckExpression.transExpression(stat.getValue(), ctxt);
            actualType = newExit.getType();
        }
        ctxt.checkThrowError(CheckType.matchType((Type)actualType, ctxt.exitType), Message.RETURNED_DATA_NOT_MATCH_EXIT_TYPE, stat.getPosition(), CheckType.toString((Type)actualType), CheckType.toString(ctxt.exitType));
        return ChiConstructors.newExitStatement((Position)PositionUtils.copyPosition((PositionObject)stat), (Expression)newExit);
    }

    private static Statement transWhileStatement(WhileStatement stat, CheckContext ctxt) {
        Expression cond = CheckExpression.transExpression(stat.getCondition(), ctxt);
        Type tp = CheckType.dropReferences(cond.getType());
        ctxt.checkThrowError(tp instanceof BoolType, Message.BOOLEAN_TYPE_EXPECTED, stat.getCondition().getPosition(), CheckType.toString(tp));
        CheckContext loopCtxt = ctxt.add(CheckContext.ContextItem.INSIDE_LOOP);
        List<Statement> body = CheckStatement.transStatementList((List<Statement>)stat.getBody(), loopCtxt);
        return ChiConstructors.newWhileStatement(body, (Expression)cond, (Position)PositionUtils.copyPosition((PositionObject)stat));
    }

    private static Statement transWriteStatement(WriteStatement stat, CheckContext ctxt) {
        List<Expression> newValues = CheckExpression.transExpressionList((List<Expression>)stat.getValues(), ctxt);
        ctxt.checkThrowError(!newValues.isEmpty(), Message.WRITE_NEEDS_FORMATTING_STRING, stat.getPosition(), new String[0]);
        Type ftp = CheckType.dropReferences(newValues.get(0).getType());
        int start = ftp instanceof FileType ? 1 : 0;
        ctxt.checkThrowError(newValues.size() > start, Message.WRITE_STRING_LITERAL_FORMATTING, stat.getPosition(), new String[0]);
        boolean cond = newValues.get(start) instanceof StringLiteral;
        ctxt.checkThrowError(cond, Message.WRITE_STRING_LITERAL_FORMATTING, newValues.get(start).getPosition(), new String[0]);
        StringLiteral fmtExpr = (StringLiteral)newValues.get(start);
        Position fmtPos = fmtExpr.getPosition();
        String fmtPattern = fmtExpr.getValue();
        int offset = start + 1;
        FormatDecoder decoder = new FormatDecoder();
        int implicitIdx = 0;
        boolean[] used = new boolean[newValues.size()];
        int i = 0;
        while (i < offset) {
            used[i] = true;
            ++i;
        }
        for (FormatDescription fd : decoder.decode(fmtPattern)) {
            Position fdPos = CheckStatement.makeSubPosition(fmtPos, fd);
            int idx = offset;
            if (fd.conversion != FormatDescription.Conversion.LITERAL && fd.conversion != FormatDescription.Conversion.ERROR) {
                if (fd.index.isEmpty()) {
                    idx += implicitIdx;
                    ++implicitIdx;
                } else {
                    int explicitIdx = fd.getExplicitIndex();
                    ctxt.checkThrowError(explicitIdx != -1, Message.FORMAT_EXPLICIT_IDX_OVERFLOW, fdPos, fd.index);
                    idx += explicitIdx - 1;
                }
                ctxt.checkThrowError(idx < newValues.size(), Message.FORMAT_STRING_TOO_MANY_SPECIFIERS, fdPos, new String[0]);
                used[idx] = true;
            }
            switch (fd.conversion) {
                case LITERAL: {
                    break;
                }
                case BOOLEAN: {
                    Expression val = newValues.get(idx);
                    Type tp = CheckType.dropReferences(val.getType());
                    ctxt.checkThrowError(tp instanceof BoolType, Message.FORMAT_N_WRONG_TYPE, fdPos, String.valueOf(idx), CheckType.toString(tp), "bool");
                    break;
                }
                case INTEGER: {
                    Expression val = newValues.get(idx);
                    Type tp = CheckType.dropReferences(val.getType());
                    ctxt.checkThrowError(tp instanceof IntType, Message.FORMAT_N_WRONG_TYPE, fdPos, String.valueOf(idx), CheckType.toString(tp), "int");
                    break;
                }
                case REAL: {
                    Expression val = newValues.get(idx);
                    Type tp = CheckType.dropReferences(val.getType());
                    ctxt.checkThrowError(tp instanceof RealType, Message.FORMAT_N_WRONG_TYPE, fdPos, String.valueOf(idx), CheckType.toString(tp), "real");
                    break;
                }
                case STRING: {
                    Expression val = newValues.get(idx);
                    Type tp = val.getType();
                    ctxt.checkThrowError(CheckType.isPrintable(tp), Message.FORMAT_N_NON_PRINTABLE, fdPos, String.valueOf(idx), CheckType.toString(tp));
                    break;
                }
                case ERROR: {
                    ctxt.throwError(Message.FORMAT_ERROR, fdPos, fd.toString());
                }
            }
        }
        boolean unused = false;
        boolean[] blArray = used;
        int n = used.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (!b) {
                unused = true;
            }
            ++n2;
        }
        ctxt.checkThrowError(!unused, Message.FORMAT_NOT_ENOUGH_SPECIFIERS, newValues.get(start).getPosition(), new String[0]);
        return ChiConstructors.newWriteStatement((Boolean)stat.isAddNewline(), (Position)PositionUtils.copyPosition((PositionObject)stat), newValues);
    }

    private static Position makeSubPosition(Position origPos, FormatDescription fd) {
        return PositionUtils.getSubRange((Position)origPos, (int)(fd.offset + 1), (int)fd.length);
    }

    private static class LocalVarsResult {
        public final Expression newSource;
        public final List<VariableDeclaration> newVars;
        public final CheckContext newCtxt;

        public LocalVarsResult(Expression newSource, List<VariableDeclaration> newVars, CheckContext newCtxt) {
            this.newSource = newSource;
            this.newVars = newVars;
            this.newCtxt = newCtxt;
        }
    }
}

